Liferay.Loader.define("frontend-js-components-web@1.0.17/treeview/Treeview", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './NodeList', './TreeviewCard', './TreeviewContext', './TreeviewLabel', './Treeview.scss'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _NodeList = _interopRequireDefault(require("./NodeList"));

  var _TreeviewCard = _interopRequireDefault(require("./TreeviewCard"));

  var _TreeviewContext = _interopRequireDefault(require("./TreeviewContext"));

  var _TreeviewLabel = _interopRequireDefault(require("./TreeviewLabel"));

  require("./Treeview.scss");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Adds parent, sibling and child links to make tree traversal in any
   * direction easy.
   */
  function addLinks(nodes) {
    var parentId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return nodes.map(function (node, i) {
      var _ref = [nodes[i - 1], nodes[i + 1]],
          previous = _ref[0],
          next = _ref[1];
      var children = node.children ? addLinks(node.children, node.id) : [];
      return _objectSpread({}, node, {
        children: children,
        nextSiblingId: next != null ? next.id : null,
        parentId: parentId,
        previousSiblingId: previous != null ? previous.id : null
      });
    });
  }
  /**
   * Updates the selection status of the node based on its children.
   * Having all the children selected will mark the item as selected.
   */

  function computeParentSelection(nodeId, selectedNodeIds, nodes) {
    var node = nodes[nodeId];

    if (!node) {
      return selectedNodeIds;
    }

    var allChildrenSelected = node.children.every(function (children) {
      return selectedNodeIds.has(children.id);
    });
    var nextSelectedNodeIds;

    if (allChildrenSelected) {
      nextSelectedNodeIds = selectedNodeIds.has(nodeId) ? selectedNodeIds : new Set([].concat(_toConsumableArray(selectedNodeIds), [nodeId]));
    } else {
      nextSelectedNodeIds = selectedNodeIds.has(nodeId) ? new Set(_toConsumableArray(selectedNodeIds).filter(function (id) {
        return id !== nodeId;
      })) : selectedNodeIds;
    }

    return computeParentSelection(node.parentId, nextSelectedNodeIds, nodes);
  }

  function filterNodes(nodes, filterQuery) {
    if (!filterQuery) {
      return null;
    }

    filterQuery = filterQuery.toLowerCase();
    var filteredNodes = [];
    nodes.forEach(function (node) {
      if (node.name.toLowerCase().indexOf(filterQuery) !== -1) {
        filteredNodes.push(_objectSpread({}, node, {
          children: []
        }));
      }

      filteredNodes.push.apply(filteredNodes, _toConsumableArray(filterNodes(node.children, filterQuery)));
    });
    return filteredNodes;
  }
  /**
   * Recursively get all the children of a parent.
   */

  function getChildrenIds(node) {
    var childrenIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    node.children.forEach(function (children) {
      childrenIds.push(children.id);
      getChildrenIds(children, childrenIds);
    });
    return childrenIds;
  }
  /**
   * Finds the deepest visible node in the subtree rooted at `node`.
   */

  function getLastVisible(node) {
    var childCount = node.children.length;

    if (!node.expanded || !childCount) {
      return node;
    } else {
      return getLastVisible(node.children[childCount - 1]);
    }
  }
  /**
   * Prepares the initial reducer state given the supplied props.
   */

  function init(_ref2) {
    var filterQuery = _ref2.filterQuery,
        inheritSelection = _ref2.inheritSelection,
        initialNodes = _ref2.initialNodes,
        initialSelectedNodeIds = _ref2.initialSelectedNodeIds,
        multiSelection = _ref2.multiSelection;
    var selectedNodeIds = new Set(initialSelectedNodeIds);
    var nodeMap = {};
    var nodes = addLinks(initialNodes).map(function (node) {
      return visit(node, function (node) {
        var expanded = node.expanded || node.children.some(function (child) {
          return child.expanded || child.selected;
        });
        var selected = selectedNodeIds.has(node.id);
        return _objectSpread({}, node, {
          expanded: expanded,
          selected: selected
        });
      }, nodeMap);
    });
    return {
      active: false,
      filterQuery: filterQuery,
      filteredNodes: filterNodes(nodes, filterQuery),
      focusedNodeId: null,
      inheritSelection: inheritSelection,
      multiSelection: multiSelection,
      nodeMap: nodeMap,
      nodes: nodes,
      selectedNodeIds: selectedNodeIds
    };
  }
  /**
   * Given a `state` object, updates the node with `id` by passing it to `callback`.
   *
   * Returns an updated (non-destructive) copy of the `state.nodes`.
   */

  function updateNode(state, id, callback) {
    var nodeMap = state.nodeMap;

    if (!nodeMap[id]) {
      throw new Error("Could not get node with id ".concat(id));
    }

    var node = callback(nodeMap[id]);

    if (node === nodeMap[id]) {
      // Node didn't change, so leave state as-is.
      return state.nodes;
    }

    nodeMap[id] = node; // Walk back to root updating subtrees.

    while (node.parentId) {
      var parent = nodeMap[node.parentId];
      node = _objectSpread({}, parent, {
        children: parent.children.map(function (child) {
          return child.id === node.id ? node : child;
        })
      });
      nodeMap[node.id] = node;
    }

    return state.nodes.map(function (child) {
      return child.id === node.id ? node : child;
    });
  }
  /**
   * Reducer function for use with `useReducer`.
   */

  function reducer(state, action) {
    var filteredNodes = state.filteredNodes,
        nodeMap = state.nodeMap;
    var nodes = filteredNodes || state.nodes;

    switch (action.type) {
      case 'ACTIVATE':
        {
          var focusedNodeId = state.focusedNodeId || nodes[0] && nodes[0].id;
          return _objectSpread({}, state, {
            active: true,
            focusedNodeId: focusedNodeId
          });
        }

      case 'DEACTIVATE':
        return _objectSpread({}, state, {
          active: false
        });

      case 'COLLAPSE':
        // eg double click
        if (!filteredNodes) {
          return _objectSpread({}, state, {
            nodes: updateNode(state, action.nodeId, function (node) {
              return node.expanded ? _objectSpread({}, node, {
                expanded: false
              }) : node;
            })
          });
        }

        break;

      case 'SELECT_ROOT':
        {
          var rootId = nodes[0] && nodes[0].id;

          if (state.focusedNodeId !== rootId) {
            return _objectSpread({}, state, {
              focusedNodeId: rootId
            });
          }
        }
        break;

      case 'SELECT_NEXT_VISIBLE':
        {
          var node = nodeMap[action.nodeId];

          if (filteredNodes) {
            for (var i = 0; i < filteredNodes.length - 1; i++) {
              if (filteredNodes[i].id === state.focusedNodeId) {
                node = nodes[i + 1];
                break;
              }
            }
          } else {
            while (node) {
              if (node.id !== action.nodeId) {
                // Not the first iteration and we found a match: done.
                break;
              }

              if (node.expanded && node.children.length) {
                // Expanded, so go to first visible child.
                node = node.children[0];
                break;
              } // No visible children, so go to first visible sibling.


              if (node.nextSiblingId) {
                node = nodeMap[node.nextSiblingId];
                continue;
              } // As last resort, go to parent's sibling.


              if (node.parentId) {
                var nextId = nodeMap[node.parentId].nextSiblingId;

                if (nextId) {
                  node = nodeMap[nextId];
                  continue;
                }
              } // Give up.


              node = null;
              break;
            }
          }

          if (node) {
            return _objectSpread({}, state, {
              focusedNodeId: node.id
            });
          }
        }
        break;

      case 'SELECT_PREVIOUS_VISIBLE':
        {
          var _node = nodeMap[action.nodeId];

          if (filteredNodes) {
            for (var _i = 1; _i < filteredNodes.length; _i++) {
              if (filteredNodes[_i].id === state.focusedNodeId) {
                _node = nodes[_i - 1];
                break;
              }
            }
          } else {
            while (_node) {
              if (_node.id !== action.nodeId) {
                break;
              }

              if (_node.previousSiblingId) {
                _node = getLastVisible(nodeMap[_node.previousSiblingId]);
                break;
              } else {
                // Go to parent.
                _node = nodeMap[_node.parentId];
                break;
              }
            }
          }

          if (_node) {
            return _objectSpread({}, state, {
              focusedNodeId: _node.id
            });
          }
        }
        break;

      case 'SELECT_LAST_VISIBLE':
        {
          var lastIndex = nodes.length - 1;
          var lastId;

          if (filteredNodes) {
            lastId = nodes[lastIndex] && nodes[lastIndex].id;
          } else {
            var _node2 = nodes[lastIndex];

            while (_node2) {
              if (_node2.children.length && _node2.expanded) {
                _node2 = _node2.children[_node2.children.length - 1];
              } else {
                break;
              }
            }

            lastId = _node2 && _node2.id;
          }

          if (lastId && state.focusedNodeId !== lastId) {
            return _objectSpread({}, state, {
              focusedNodeId: lastId
            });
          }
        }
        break;

      case 'TOGGLE_EXPANDED':
        // Toggles the expanded or collapsed state of the selected
        // parent node. eg. by double clicking; doesn't select a child.
        if (!filteredNodes) {
          return _objectSpread({}, state, {
            nodes: updateNode(state, action.nodeId, function (node) {
              return _objectSpread({}, node, {
                expanded: !node.expanded
              });
            })
          });
        }

        break;

      case 'EXPAND_ALL':
        {
          if (!filteredNodes) {
            var _nodes = state.nodes.map(function (node) {
              return visit(node, function (node) {
                return !node.expanded ? _objectSpread({}, node, {
                  expanded: true
                }) : node;
              }, nodeMap);
            });

            return _objectSpread({}, state, {
              nodes: _nodes
            });
          }
        }
        break;

      case 'FILTER':
        return _objectSpread({}, state, {
          filterQuery: action.filterQuery,
          filteredNodes: filterNodes(state.nodes, action.filterQuery),
          focusedNodeId: null
        });

      case 'FOCUS':
        if (action.nodeId !== state.focusedNodeId) {
          return _objectSpread({}, state, {
            focusedNodeId: action.nodeId
          });
        }

        break;

      case 'COLLAPSE_PARENT':
        {
          // Collapse the currently selected parent node if it is
          // expanded; otherwise move to the previous parent node
          // (if possible).
          if (!filteredNodes) {
            var _node3 = nodeMap[action.nodeId];

            if (_node3.expanded) {
              return _objectSpread({}, state, {
                nodes: updateNode(state, action.nodeId, function (node) {
                  return _objectSpread({}, node, {
                    expanded: false
                  });
                })
              });
            } else if (_node3.parentId) {
              return _objectSpread({}, state, {
                focusedNodeId: _node3.parentId
              });
            }
          }
        }
        break;

      case 'EXPAND_AND_ENTER':
        {
          // Expand the currently selected parent node if it is closed;
          // move to the first child list item if it was already expanded.
          if (!filteredNodes) {
            var _node4 = nodeMap[action.nodeId];

            if (!_node4.expanded) {
              return _objectSpread({}, state, {
                nodes: updateNode(state, action.nodeId, function (node) {
                  return _objectSpread({}, node, {
                    expanded: true
                  });
                })
              });
            } else if (_node4.children.length) {
              return _objectSpread({}, state, {
                focusedNodeId: _node4.children[0].id
              });
            }
          }
        }
        break;

      case 'TOGGLE_SELECT':
        {
          var id = action.nodeId;

          if (!nodeMap[id].disabled) {
            var inheritSelection = state.inheritSelection,
                multiSelection = state.multiSelection;
            var selectedNodeIds = state.selectedNodeIds;

            if (inheritSelection) {
              var selectedNode = nodeMap[id];
              var parentAndChildrenIds = [id].concat(_toConsumableArray(getChildrenIds(selectedNode)));
              var nextSelectedNodeIds;

              if (selectedNodeIds.has(id)) {
                nextSelectedNodeIds = new Set(_toConsumableArray(selectedNodeIds).filter(function (selectedId) {
                  return !parentAndChildrenIds.includes(selectedId);
                }));
              } else {
                nextSelectedNodeIds = new Set([].concat(_toConsumableArray(selectedNodeIds), _toConsumableArray(parentAndChildrenIds)));
              }

              selectedNodeIds = computeParentSelection(selectedNode.parentId, nextSelectedNodeIds, nodeMap);
            } else {
              if (selectedNodeIds.has(id)) {
                selectedNodeIds = new Set(_toConsumableArray(selectedNodeIds).filter(function (selectedId) {
                  return selectedId !== id;
                }));
              } else if (multiSelection) {
                selectedNodeIds = new Set([].concat(_toConsumableArray(selectedNodeIds), [id]));
              } else {
                selectedNodeIds = new Set([id]);
              }
            }

            return _objectSpread({}, state, {
              filteredNodes: filteredNodes && filteredNodes.map(function (node) {
                return toggleNode(node, selectedNodeIds);
              }),
              focusedNodeId: id,
              nodes: state.nodes.map(function (node) {
                return visit(node, function (node) {
                  return toggleNode(node, selectedNodeIds);
                }, nodeMap);
              }),
              selectedNodeIds: selectedNodeIds
            });
          }

          break;
        }

      case 'EXIT':
        // Navigate away from tree.
        break;

      case 'UPDATE_NODES':
        {
          var _nodes2 = addLinks(action.newNodes).map(function (node) {
            return visit(node, function (node) {
              var selectedNodeIds = state.selectedNodeIds;
              var oldNode = nodeMap[node.id] || {};
              var expanded = oldNode.expanded || node.expanded || node.children.some(function (child) {
                return child.expanded || child.selected;
              });
              var selected = oldNode.selected || selectedNodeIds.has(node.id);
              return _objectSpread({}, node, {
                expanded: expanded,
                selected: selected
              });
            }, nodeMap);
          });

          return _objectSpread({}, state, {
            nodes: _nodes2
          });
        }

      default:
        break;
    }

    return state;
  }
  /**
   * Toggles the `selected` property of `node` based on its membership
   * within `selectedNodeIds`.
   *
   * Returns the original node if it was already in the desired state;
   * otherwise returns a copy.
   */

  function toggleNode(node, selectedNodeIds) {
    if (node.selected !== selectedNodeIds.has(node.id)) {
      return _objectSpread({}, node, {
        selected: !node.selected
      });
    } else {
      return node;
    }
  }
  /**
   * Visits the tree represented by `node`, passing each visited node to
   * `callback`, which should return an updated node and update the `nodeMap`
   * cache.
   *
   * If `callback` returns the same node, no actual copies are made.
   */

  function visit(node, callback, nodeMap) {
    var children = node.children;
    var nextChildren;

    for (var i = 0; i < children.length; i++) {
      var child = children[i];
      var updated = visit(child, callback, nodeMap);

      if (nextChildren) {
        nextChildren.push(updated);
      } else if (updated !== child) {
        nextChildren = children.slice(0, i).concat([updated]);
      }
    }

    var nextNode = callback(nextChildren ? _objectSpread({}, node, {
      children: nextChildren
    }) : node);

    if (nextNode !== node) {
      nodeMap[nextNode.id] = nextNode;
    }

    return nextNode;
  }

  function Treeview(_ref3) {
    var NodeComponent = _ref3.NodeComponent,
        filterQuery = _ref3.filterQuery,
        inheritSelection = _ref3.inheritSelection,
        initialSelectedNodeIds = _ref3.initialSelectedNodeIds,
        multiSelection = _ref3.multiSelection,
        initialNodes = _ref3.nodes,
        onSelectedNodesChange = _ref3.onSelectedNodesChange;
    var delay = (0, _frontendJsReactWeb.useTimeout)();
    var focusTimer = (0, _react.useRef)();

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        setHasFocus = _useState2[1];

    var _useReducer = (0, _react.useReducer)(reducer, {
      filterQuery: filterQuery,
      inheritSelection: inheritSelection,
      initialNodes: initialNodes,
      initialSelectedNodeIds: initialSelectedNodeIds,
      multiSelection: multiSelection
    }, init),
        _useReducer2 = _slicedToArray(_useReducer, 2),
        state = _useReducer2[0],
        dispatch = _useReducer2[1];

    var filteredNodes = state.filteredNodes,
        nodes = state.nodes,
        selectedNodeIds = state.selectedNodeIds;
    (0, _react.useEffect)(function () {
      dispatch({
        filterQuery: filterQuery,
        type: 'FILTER'
      });
    }, [filterQuery]);
    (0, _react.useEffect)(function () {
      dispatch({
        newNodes: initialNodes,
        type: 'UPDATE_NODES'
      });
    }, [initialNodes]);
    (0, _react.useEffect)(function () {
      if (onSelectedNodesChange) {
        onSelectedNodesChange(selectedNodeIds);
      }
    }, [onSelectedNodesChange, selectedNodeIds]);

    var cancelTimer = function cancelTimer() {
      if (focusTimer.current) {
        focusTimer.current();
        focusTimer.current = null;
      }
    };

    return _react["default"].createElement(_TreeviewContext["default"].Provider, {
      value: {
        dispatch: dispatch,
        state: state
      }
    }, _react["default"].createElement(_NodeList["default"], {
      NodeComponent: NodeComponent,
      nodes: filteredNodes || nodes,
      onBlur: function handleBlur() {
        cancelTimer(); // Due to React's event bubbling, we may get a "focus" event
        // immediately after this "blur" (eg. when moving around inside
        // the treeview); so, we defer this state update until the next
        // tick, giving us a chance to cancel it if needed.

        focusTimer.current = delay(function () {
          setHasFocus(function (hadFocus) {
            if (hadFocus) {
              dispatch({
                type: 'DEACTIVATE'
              });
            }

            return false;
          });
        }, 0);
      },
      onFocus: function handleFocus() {
        cancelTimer();
        setHasFocus(function (hadFocus) {
          if (!hadFocus) {
            dispatch({
              type: 'ACTIVATE'
            });
          }

          return true;
        });
      },
      role: "tree",
      tabIndex: 0
    }));
  }

  Treeview.defaultProps = {
    NodeComponent: _TreeviewLabel["default"],
    multiSelection: true
  };
  Treeview.Card = _TreeviewCard["default"];
  Treeview.Label = _TreeviewLabel["default"];
  var _default = Treeview;
  exports["default"] = _default;
  //# sourceMappingURL=Treeview.js.map
});
//# sourceMappingURL=Treeview.js.map