Liferay.Loader.define("frontend-js-components-web@1.0.17/treeview/NodeListItem", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './NodeList', './TreeviewContext', './useFocus', './useKeyboardNavigation'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = NodeListItem;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _NodeList = _interopRequireDefault(require("./NodeList"));

  var _TreeviewContext = _interopRequireDefault(require("./TreeviewContext"));

  var _useFocus = _interopRequireDefault(require("./useFocus"));

  var _useKeyboardNavigation = _interopRequireDefault(require("./useKeyboardNavigation"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function NodeListItem(_ref) {
    var NodeComponent = _ref.NodeComponent,
        node = _ref.node;

    var _useContext = (0, _react.useContext)(_TreeviewContext["default"]),
        dispatch = _useContext.dispatch;

    var focusable = (0, _useFocus["default"])(node.id);
    var handleKeyDown = (0, _useKeyboardNavigation["default"])(node.id);
    var children = node.children || [];
    var nodeListItemClassNames = (0, _classnames["default"])('lfr-treeview-node-list-item', {
      'with-children': children.length > 0
    });
    var childrenId = "node-list-item-".concat(node.id, "-children");
    var symbol = node.expanded ? 'hr' : 'plus';

    var toggleExpanded = function toggleExpanded(event) {
      if (node.children.length) {
        event.stopPropagation();
        dispatch({
          nodeId: node.id,
          type: 'TOGGLE_EXPANDED'
        });
      }
    };

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
      className: nodeListItemClassNames,
      onBlur: function onBlur() {},
      onClick: function toggleSelected() {
        dispatch({
          nodeId: node.id,
          type: 'TOGGLE_SELECT'
        });
      },
      onDoubleClick: toggleExpanded,
      onKeyDown: handleKeyDown,
      ref: focusable,
      role: "treeitem",
      tabIndex: "-1"
    }, children.length ? _react["default"].createElement("button", {
      "aria-controls": childrenId,
      "aria-expanded": node.expanded,
      "aria-label": "".concat(node.expanded ? 'Collapse' : 'Expand', " ").concat(node.name),
      className: "lfr-treeview-node-list-item__button",
      onClick: toggleExpanded,
      tabIndex: "-1",
      type: "button"
    }, _react["default"].createElement(_icon["default"], {
      className: "lfr-treeview-node-list-item__button-icon",
      key: symbol,
      symbol: symbol
    })) : null, _react["default"].createElement("div", {
      className: "lfr-treeview-node-list-item__node"
    }, _react["default"].createElement(NodeComponent, {
      node: node
    }))), node.expanded && _react["default"].createElement("div", {
      className: "lfr-treeview-node-list-item__children",
      id: childrenId
    }, _react["default"].createElement(_NodeList["default"], {
      NodeComponent: NodeComponent,
      nodes: children
    })));
  }
  //# sourceMappingURL=NodeListItem.js.map
});
//# sourceMappingURL=NodeListItem.js.map