Liferay.Loader.define("frontend-js-components-web@1.0.17/treeview/NodeList", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './NodeListItem'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = NodeList;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _NodeListItem = _interopRequireDefault(require("./NodeListItem"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function NodeList(_ref) {
    var NodeComponent = _ref.NodeComponent,
        nodes = _ref.nodes,
        _onBlur = _ref.onBlur,
        _onFocus = _ref.onFocus,
        _ref$role = _ref.role,
        role = _ref$role === void 0 ? 'group' : _ref$role,
        _ref$tabIndex = _ref.tabIndex,
        tabIndex = _ref$tabIndex === void 0 ? -1 : _ref$tabIndex;
    var rootNodeId = nodes[0] && nodes[0].id;

    if (!rootNodeId) {
      // All nodes have been filtered.
      return null;
    }

    return _react["default"].createElement("div", {
      className: "lfr-treeview-node-list",
      onBlur: function onBlur() {
        if (_onBlur) {
          _onBlur();
        }
      },
      onFocus: function onFocus(event) {
        if (_onFocus) {
          _onFocus(event);
        }
      },
      role: role,
      tabIndex: tabIndex
    }, nodes.map(function (node) {
      return _react["default"].createElement(_NodeListItem["default"], {
        key: node.id,
        node: node,
        NodeComponent: NodeComponent
      });
    }));
  }
  //# sourceMappingURL=NodeList.js.map
});
//# sourceMappingURL=NodeList.js.map