Liferay.Loader.define('frontend-js-components-web$react-transition-group@4.4.1/dist/react-transition-group', ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom'], function (module, exports, require) {
  var define = undefined;
  (function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('frontend-js-react-web$react'), require('frontend-js-react-web$react-dom')) : typeof define === 'function' && define.amd ? define(['exports', 'react', 'react-dom'], factory) : (global = global || self, factory(global.ReactTransitionGroup = {}, global.React, global.ReactDOM));
  })(this, function (exports, React, ReactDOM) {
    'use strict';

    var React__default = 'default' in React ? React['default'] : React;
    ReactDOM = ReactDOM && Object.prototype.hasOwnProperty.call(ReactDOM, 'default') ? ReactDOM['default'] : ReactDOM;

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];

          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }

        return target;
      };

      return _extends.apply(this, arguments);
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;

      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        target[key] = source[key];
      }

      return target;
    }

    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }

    function createCommonjsModule(fn, module) {
      return module = { exports: {} }, fn(module, module.exports), module.exports;
    }

    var reactIs_development = createCommonjsModule(function (module, exports) {

      {
        (function () {

          // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
          // nor polyfill, then a plain number is used for performance.
          var hasSymbol = typeof Symbol === 'function' && Symbol.for;
          var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
          var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
          var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
          var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
          var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
          var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
          var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
          // (unstable) APIs that have been removed. Can we remove the symbols?

          var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
          var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
          var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
          var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
          var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
          var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
          var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
          var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
          var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
          var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
          var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

          function typeOf(object) {
            if (typeof object === 'object' && object !== null) {
              var $$typeof = object.$$typeof;

              switch ($$typeof) {
                case REACT_ELEMENT_TYPE:
                  var type = object.type;

                  switch (type) {
                    case REACT_ASYNC_MODE_TYPE:
                    case REACT_CONCURRENT_MODE_TYPE:
                    case REACT_FRAGMENT_TYPE:
                    case REACT_PROFILER_TYPE:
                    case REACT_STRICT_MODE_TYPE:
                    case REACT_SUSPENSE_TYPE:
                      return type;

                    default:
                      var $$typeofType = type && type.$$typeof;

                      switch ($$typeofType) {
                        case REACT_CONTEXT_TYPE:
                        case REACT_FORWARD_REF_TYPE:
                        case REACT_LAZY_TYPE:
                        case REACT_MEMO_TYPE:
                        case REACT_PROVIDER_TYPE:
                          return $$typeofType;

                        default:
                          return $$typeof;
                      }

                  }

                case REACT_PORTAL_TYPE:
                  return $$typeof;
              }
            }

            return undefined;
          } // AsyncMode is deprecated along with isAsyncMode

          var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

          function isAsyncMode(object) {
            {
              if (!hasWarnedAboutDeprecatedIsAsyncMode) {
                hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

                console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
              }
            }

            return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
          }
          function isConcurrentMode(object) {
            return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
          }


          exports.AsyncMode = REACT_ASYNC_MODE_TYPE;
          exports.ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
          exports.ContextConsumer = REACT_CONTEXT_TYPE;
          exports.ContextProvider = REACT_PROVIDER_TYPE;
          exports.Element = REACT_ELEMENT_TYPE;
          exports.ForwardRef = REACT_FORWARD_REF_TYPE;
          exports.Fragment = REACT_FRAGMENT_TYPE;
          exports.Lazy = REACT_LAZY_TYPE;
          exports.Memo = REACT_MEMO_TYPE;
          exports.Portal = REACT_PORTAL_TYPE;
          exports.Profiler = REACT_PROFILER_TYPE;
          exports.StrictMode = REACT_STRICT_MODE_TYPE;
          exports.Suspense = REACT_SUSPENSE_TYPE;
          exports.isAsyncMode = isAsyncMode;
          exports.isConcurrentMode = isConcurrentMode;
          exports.isContextConsumer = function isContextConsumer(object) {
            return typeOf(object) === REACT_CONTEXT_TYPE;
          };
          exports.isContextProvider = function isContextProvider(object) {
            return typeOf(object) === REACT_PROVIDER_TYPE;
          };
          exports.isElement = function isElement(object) {
            return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
          };
          exports.isForwardRef = function isForwardRef(object) {
            return typeOf(object) === REACT_FORWARD_REF_TYPE;
          };
          exports.isFragment = function isFragment(object) {
            return typeOf(object) === REACT_FRAGMENT_TYPE;
          };
          exports.isLazy = function isLazy(object) {
            return typeOf(object) === REACT_LAZY_TYPE;
          };
          exports.isMemo = function isMemo(object) {
            return typeOf(object) === REACT_MEMO_TYPE;
          };
          exports.isPortal = function isPortal(object) {
            return typeOf(object) === REACT_PORTAL_TYPE;
          };
          exports.isProfiler = function isProfiler(object) {
            return typeOf(object) === REACT_PROFILER_TYPE;
          };
          exports.isStrictMode = function isStrictMode(object) {
            return typeOf(object) === REACT_STRICT_MODE_TYPE;
          };
          exports.isSuspense = function isSuspense(object) {
            return typeOf(object) === REACT_SUSPENSE_TYPE;
          };
          exports.isValidElementType = function isValidElementType(type) {
            return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
            type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
          };
          exports.typeOf = typeOf;
        })();
      }
    });
    reactIs_development.AsyncMode;
    reactIs_development.ConcurrentMode;
    reactIs_development.ContextConsumer;
    reactIs_development.ContextProvider;
    reactIs_development.Element;
    reactIs_development.ForwardRef;
    reactIs_development.Fragment;
    reactIs_development.Lazy;
    reactIs_development.Memo;
    reactIs_development.Portal;
    reactIs_development.Profiler;
    reactIs_development.StrictMode;
    reactIs_development.Suspense;
    reactIs_development.isAsyncMode;
    reactIs_development.isConcurrentMode;
    reactIs_development.isContextConsumer;
    reactIs_development.isContextProvider;
    reactIs_development.isElement;
    reactIs_development.isForwardRef;
    reactIs_development.isFragment;
    reactIs_development.isLazy;
    reactIs_development.isMemo;
    reactIs_development.isPortal;
    reactIs_development.isProfiler;
    reactIs_development.isStrictMode;
    reactIs_development.isSuspense;
    reactIs_development.isValidElementType;
    reactIs_development.typeOf;


    var reactIs = createCommonjsModule(function (module) {

      {
        module.exports = reactIs_development;
      }
    });

    /*
    object-assign
    (c) Sindre Sorhus
    @license MIT
    */
    /* eslint-disable no-unused-vars */
    var getOwnPropertySymbols = Object.getOwnPropertySymbols;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var propIsEnumerable = Object.prototype.propertyIsEnumerable;

    function toObject(val) {
      if (val === null || val === undefined) {
        throw new TypeError('Object.assign cannot be called with null or undefined');
      }

      return Object(val);
    }

    var objectAssign = function shouldUseNative() {
      try {
        if (!Object.assign) {
          return false;
        }

        // Detect buggy property enumeration order in older V8 versions.

        // https://bugs.chromium.org/p/v8/issues/detail?id=4118
        var test1 = new String('abc'); // eslint-disable-line no-new-wrappers
        test1[5] = 'de';
        if (Object.getOwnPropertyNames(test1)[0] === '5') {
          return false;
        }

        // https://bugs.chromium.org/p/v8/issues/detail?id=3056
        var test2 = {};
        for (var i = 0; i < 10; i++) {
          test2['_' + String.fromCharCode(i)] = i;
        }
        var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
          return test2[n];
        });
        if (order2.join('') !== '0123456789') {
          return false;
        }

        // https://bugs.chromium.org/p/v8/issues/detail?id=3056
        var test3 = {};
        'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
          test3[letter] = letter;
        });
        if (Object.keys(Object.assign({}, test3)).join('') !== 'abcdefghijklmnopqrst') {
          return false;
        }

        return true;
      } catch (err) {
        // We don't expect any of the above to throw, but better to be safe.
        return false;
      }
    }() ? Object.assign : function (target, source) {
      var from;
      var to = toObject(target);
      var symbols;

      for (var s = 1; s < arguments.length; s++) {
        from = Object(arguments[s]);

        for (var key in from) {
          if (hasOwnProperty.call(from, key)) {
            to[key] = from[key];
          }
        }

        if (getOwnPropertySymbols) {
          symbols = getOwnPropertySymbols(from);
          for (var i = 0; i < symbols.length; i++) {
            if (propIsEnumerable.call(from, symbols[i])) {
              to[symbols[i]] = from[symbols[i]];
            }
          }
        }
      }

      return to;
    };

    /**
     * Copyright (c) 2013-present, Facebook, Inc.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */

    var ReactPropTypesSecret_1 = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

    var printWarning = function () {};

    {
      var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;
      var loggedTypeFailures = {};
      var has = Function.call.bind(Object.prototype.hasOwnProperty);

      printWarning = function (text) {
        var message = 'Warning: ' + text;
        if (typeof console !== 'undefined') {
          console.error(message);
        }
        try {
          // --- Welcome to debugging React ---
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch (x) {}
      };
    }

    /**
     * Assert that the values match with the type specs.
     * Error messages are memorized and will only be shown once.
     *
     * @param {object} typeSpecs Map of name to a ReactPropType
     * @param {object} values Runtime values that need to be type-checked
     * @param {string} location e.g. "prop", "context", "child context"
     * @param {string} componentName Name of the component for error messages.
     * @param {?Function} getStack Returns the component stack.
     * @private
     */
    function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
      {
        for (var typeSpecName in typeSpecs) {
          if (has(typeSpecs, typeSpecName)) {
            var error;
            // Prop type validation may throw. In case they do, we don't want to
            // fail the render phase where it didn't fail before. So we log it.
            // After these have been cleaned up, we'll let them throw.
            try {
              // This is intentionally an invariant that gets caught. It's the same
              // behavior as without this statement except with a better message.
              if (typeof typeSpecs[typeSpecName] !== 'function') {
                var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.');
                err.name = 'Invariant Violation';
                throw err;
              }
              error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$1);
            } catch (ex) {
              error = ex;
            }
            if (error && !(error instanceof Error)) {
              printWarning((componentName || 'React class') + ': type specification of ' + location + ' `' + typeSpecName + '` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a ' + typeof error + '. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).');
            }
            if (error instanceof Error && !(error.message in loggedTypeFailures)) {
              // Only monitor this failure once because there tends to be a lot of the
              // same error.
              loggedTypeFailures[error.message] = true;

              var stack = getStack ? getStack() : '';

              printWarning('Failed ' + location + ' type: ' + error.message + (stack != null ? stack : ''));
            }
          }
        }
      }
    }

    /**
     * Resets warning cache when testing.
     *
     * @private
     */
    checkPropTypes.resetWarningCache = function () {
      {
        loggedTypeFailures = {};
      }
    };

    var checkPropTypes_1 = checkPropTypes;

    var has$1 = Function.call.bind(Object.prototype.hasOwnProperty);
    var printWarning$1 = function () {};

    {
      printWarning$1 = function (text) {
        var message = 'Warning: ' + text;
        if (typeof console !== 'undefined') {
          console.error(message);
        }
        try {
          // --- Welcome to debugging React ---
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch (x) {}
      };
    }

    function emptyFunctionThatReturnsNull() {
      return null;
    }

    var factoryWithTypeCheckers = function (isValidElement, throwOnDirectAccess) {
      /* global Symbol */
      var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
      // Before Symbol spec.

      /**
       * Returns the iterator method function contained on the iterable object.
       *
       * Be sure to invoke the function with the iterable as context:
       *
       *     var iteratorFn = getIteratorFn(myIterable);
       *     if (iteratorFn) {
       *       var iterator = iteratorFn.call(myIterable);
       *       ...
       *     }
       *
       * @param {?object} maybeIterable
       * @return {?function}
       */
      function getIteratorFn(maybeIterable) {
        var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable['@@iterator']);
        if (typeof iteratorFn === 'function') {
          return iteratorFn;
        }
      }

      /**
       * Collection of methods that allow declaration and validation of props that are
       * supplied to React components. Example usage:
       *
       *   var Props = require('ReactPropTypes');
       *   var MyArticle = React.createClass({
       *     propTypes: {
       *       // An optional string prop named "description".
       *       description: Props.string,
       *
       *       // A required enum prop named "category".
       *       category: Props.oneOf(['News','Photos']).isRequired,
       *
       *       // A prop named "dialog" that requires an instance of Dialog.
       *       dialog: Props.instanceOf(Dialog).isRequired
       *     },
       *     render: function() { ... }
       *   });
       *
       * A more formal specification of how these methods are used:
       *
       *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
       *   decl := ReactPropTypes.{type}(.isRequired)?
       *
       * Each and every declaration produces a function with the same signature. This
       * allows the creation of custom validation functions. For example:
       *
       *  var MyLink = React.createClass({
       *    propTypes: {
       *      // An optional string or URI prop named "href".
       *      href: function(props, propName, componentName) {
       *        var propValue = props[propName];
       *        if (propValue != null && typeof propValue !== 'string' &&
       *            !(propValue instanceof URI)) {
       *          return new Error(
       *            'Expected a string or an URI for ' + propName + ' in ' +
       *            componentName
       *          );
       *        }
       *      }
       *    },
       *    render: function() {...}
       *  });
       *
       * @internal
       */

      var ANONYMOUS = '<<anonymous>>';

      // Important!
      // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
      var ReactPropTypes = {
        array: createPrimitiveTypeChecker('array'),
        bool: createPrimitiveTypeChecker('boolean'),
        func: createPrimitiveTypeChecker('function'),
        number: createPrimitiveTypeChecker('number'),
        object: createPrimitiveTypeChecker('object'),
        string: createPrimitiveTypeChecker('string'),
        symbol: createPrimitiveTypeChecker('symbol'),

        any: function createAnyTypeChecker() {
          return createChainableTypeChecker(emptyFunctionThatReturnsNull);
        }(),
        arrayOf: function createArrayOfTypeChecker(typeChecker) {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            if (typeof typeChecker !== 'function') {
              return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
            }
            var propValue = props[propName];
            if (!Array.isArray(propValue)) {
              var propType = getPropType(propValue);
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
            }
            for (var i = 0; i < propValue.length; i++) {
              var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
              if (error instanceof Error) {
                return error;
              }
            }
            return null;
          });
        },
        element: function createElementTypeChecker() {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            var propValue = props[propName];
            if (!isValidElement(propValue)) {
              var propType = getPropType(propValue);
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
            }
            return null;
          });
        }(),
        elementType: function createElementTypeTypeChecker() {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            var propValue = props[propName];
            if (!reactIs.isValidElementType(propValue)) {
              var propType = getPropType(propValue);
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
            }
            return null;
          });
        }(),
        instanceOf: function createInstanceTypeChecker(expectedClass) {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            if (!(props[propName] instanceof expectedClass)) {
              var expectedClassName = expectedClass.name || ANONYMOUS;
              var actualClassName = getClassName(props[propName]);
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
            }
            return null;
          });
        },
        node: function createNodeChecker() {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            if (!isNode(props[propName])) {
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
            }
            return null;
          });
        }(),
        objectOf: function createObjectOfTypeChecker(typeChecker) {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            if (typeof typeChecker !== 'function') {
              return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
            }
            var propValue = props[propName];
            var propType = getPropType(propValue);
            if (propType !== 'object') {
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
            }
            for (var key in propValue) {
              if (has$1(propValue, key)) {
                var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
                if (error instanceof Error) {
                  return error;
                }
              }
            }
            return null;
          });
        },
        oneOf: createEnumTypeChecker,
        oneOfType: createUnionTypeChecker,
        shape: function createShapeTypeChecker(shapeTypes) {
          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            var propValue = props[propName];
            var propType = getPropType(propValue);
            if (propType !== 'object') {
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
            }
            for (var key in shapeTypes) {
              var checker = shapeTypes[key];
              if (!checker) {
                continue;
              }
              var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
              if (error) {
                return error;
              }
            }
            return null;
          });
        },
        exact: function createStrictShapeTypeChecker(shapeTypes) {

          return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
            var propValue = props[propName];
            var propType = getPropType(propValue);
            if (propType !== 'object') {
              return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
            }
            // We need to check all keys in case some are required but missing from
            // props.
            var allKeys = objectAssign({}, props[propName], shapeTypes);
            for (var key in allKeys) {
              var checker = shapeTypes[key];
              if (!checker) {
                return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' + '\nBad object: ' + JSON.stringify(props[propName], null, '  ') + '\nValid keys: ' + JSON.stringify(Object.keys(shapeTypes), null, '  '));
              }
              var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
              if (error) {
                return error;
              }
            }
            return null;
          });
        }
      };

      /**
       * inlined Object.is polyfill to avoid requiring consumers ship their own
       * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
       */
      /*eslint-disable no-self-compare*/
      function is(x, y) {
        // SameValue algorithm
        if (x === y) {
          // Steps 1-5, 7-10
          // Steps 6.b-6.e: +0 != -0
          return x !== 0 || 1 / x === 1 / y;
        } else {
          // Step 6.a: NaN == NaN
          return x !== x && y !== y;
        }
      }
      /*eslint-enable no-self-compare*/

      /**
       * We use an Error-like object for backward compatibility as people may call
       * PropTypes directly and inspect their output. However, we don't use real
       * Errors anymore. We don't inspect their stack anyway, and creating them
       * is prohibitively expensive if they are created too often, such as what
       * happens in oneOfType() for any type before the one that matched.
       */
      function PropTypeError(message) {
        this.message = message;
        this.stack = '';
      }
      // Make `instanceof Error` still work for returned errors.
      PropTypeError.prototype = Error.prototype;

      function createChainableTypeChecker(validate) {
        {
          var manualPropTypeCallCache = {};
          var manualPropTypeWarningCount = 0;
        }
        function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
          componentName = componentName || ANONYMOUS;
          propFullName = propFullName || propName;

          if (secret !== ReactPropTypesSecret_1) {
            if (throwOnDirectAccess) {
              // New behavior only for users of `prop-types` package
              var err = new Error('Calling PropTypes validators directly is not supported by the `prop-types` package. ' + 'Use `PropTypes.checkPropTypes()` to call them. ' + 'Read more at http://fb.me/use-check-prop-types');
              err.name = 'Invariant Violation';
              throw err;
            } else if (typeof console !== 'undefined') {
              // Old behavior for people using React.PropTypes
              var cacheKey = componentName + ':' + propName;
              if (!manualPropTypeCallCache[cacheKey] &&
              // Avoid spamming the console because they are often not actionable except for lib authors
              manualPropTypeWarningCount < 3) {
                printWarning$1('You are manually calling a React.PropTypes validation ' + 'function for the `' + propFullName + '` prop on `' + componentName + '`. This is deprecated ' + 'and will throw in the standalone `prop-types` package. ' + 'You may be seeing this warning due to a third-party PropTypes ' + 'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.');
                manualPropTypeCallCache[cacheKey] = true;
                manualPropTypeWarningCount++;
              }
            }
          }
          if (props[propName] == null) {
            if (isRequired) {
              if (props[propName] === null) {
                return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
              }
              return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
            }
            return null;
          } else {
            return validate(props, propName, componentName, location, propFullName);
          }
        }

        var chainedCheckType = checkType.bind(null, false);
        chainedCheckType.isRequired = checkType.bind(null, true);

        return chainedCheckType;
      }

      function createPrimitiveTypeChecker(expectedType) {
        return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName, secret) {
          var propValue = props[propName];
          var propType = getPropType(propValue);
          if (propType !== expectedType) {
            // `propValue` being instance of, say, date/regexp, pass the 'object'
            // check, but we can offer a more precise error message here rather than
            // 'of type `object`'.
            var preciseType = getPreciseType(propValue);

            return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
          }
          return null;
        });
      }

      function createEnumTypeChecker(expectedValues) {
        if (!Array.isArray(expectedValues)) {
          {
            if (arguments.length > 1) {
              printWarning$1('Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' + 'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).');
            } else {
              printWarning$1('Invalid argument supplied to oneOf, expected an array.');
            }
          }
          return emptyFunctionThatReturnsNull;
        }

        return createChainableTypeChecker(function validate(props, propName, componentName, location, propFullName) {
          var propValue = props[propName];
          for (var i = 0; i < expectedValues.length; i++) {
            if (is(propValue, expectedValues[i])) {
              return null;
            }
          }

          var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
            var type = getPreciseType(value);
            if (type === 'symbol') {
              return String(value);
            }
            return value;
          });
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
        });
      }

      function createUnionTypeChecker(arrayOfTypeCheckers) {
        if (!Array.isArray(arrayOfTypeCheckers)) {
          printWarning$1('Invalid argument supplied to oneOfType, expected an instance of array.');
          return emptyFunctionThatReturnsNull;
        }

        for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
          var checker = arrayOfTypeCheckers[i];
          if (typeof checker !== 'function') {
            printWarning$1('Invalid argument supplied to oneOfType. Expected an array of check functions, but ' + 'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.');
            return emptyFunctionThatReturnsNull;
          }
        }

        function validate(props, propName, componentName, location, propFullName) {
          for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
            var checker = arrayOfTypeCheckers[i];
            if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1) == null) {
              return null;
            }
          }

          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
        }
        return createChainableTypeChecker(validate);
      }

      function isNode(propValue) {
        switch (typeof propValue) {
          case 'number':
          case 'string':
          case 'undefined':
            return true;
          case 'boolean':
            return !propValue;
          case 'object':
            if (Array.isArray(propValue)) {
              return propValue.every(isNode);
            }
            if (propValue === null || isValidElement(propValue)) {
              return true;
            }

            var iteratorFn = getIteratorFn(propValue);
            if (iteratorFn) {
              var iterator = iteratorFn.call(propValue);
              var step;
              if (iteratorFn !== propValue.entries) {
                while (!(step = iterator.next()).done) {
                  if (!isNode(step.value)) {
                    return false;
                  }
                }
              } else {
                // Iterator will provide entry [k,v] tuples rather than values.
                while (!(step = iterator.next()).done) {
                  var entry = step.value;
                  if (entry) {
                    if (!isNode(entry[1])) {
                      return false;
                    }
                  }
                }
              }
            } else {
              return false;
            }

            return true;
          default:
            return false;
        }
      }

      function isSymbol(propType, propValue) {
        // Native Symbol.
        if (propType === 'symbol') {
          return true;
        }

        // falsy value can't be a Symbol
        if (!propValue) {
          return false;
        }

        // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
        if (propValue['@@toStringTag'] === 'Symbol') {
          return true;
        }

        // Fallback for non-spec compliant Symbols which are polyfilled.
        if (typeof Symbol === 'function' && propValue instanceof Symbol) {
          return true;
        }

        return false;
      }

      // Equivalent of `typeof` but with special handling for array and regexp.
      function getPropType(propValue) {
        var propType = typeof propValue;
        if (Array.isArray(propValue)) {
          return 'array';
        }
        if (propValue instanceof RegExp) {
          // Old webkits (at least until Android 4.0) return 'function' rather than
          // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
          // passes PropTypes.object.
          return 'object';
        }
        if (isSymbol(propType, propValue)) {
          return 'symbol';
        }
        return propType;
      }

      // This handles more types than `getPropType`. Only used for error messages.
      // See `createPrimitiveTypeChecker`.
      function getPreciseType(propValue) {
        if (typeof propValue === 'undefined' || propValue === null) {
          return '' + propValue;
        }
        var propType = getPropType(propValue);
        if (propType === 'object') {
          if (propValue instanceof Date) {
            return 'date';
          } else if (propValue instanceof RegExp) {
            return 'regexp';
          }
        }
        return propType;
      }

      // Returns a string that is postfixed to a warning about an invalid type.
      // For example, "undefined" or "of type array"
      function getPostfixForTypeWarning(value) {
        var type = getPreciseType(value);
        switch (type) {
          case 'array':
          case 'object':
            return 'an ' + type;
          case 'boolean':
          case 'date':
          case 'regexp':
            return 'a ' + type;
          default:
            return type;
        }
      }

      // Returns class name of the object, if any.
      function getClassName(propValue) {
        if (!propValue.constructor || !propValue.constructor.name) {
          return ANONYMOUS;
        }
        return propValue.constructor.name;
      }

      ReactPropTypes.checkPropTypes = checkPropTypes_1;
      ReactPropTypes.resetWarningCache = checkPropTypes_1.resetWarningCache;
      ReactPropTypes.PropTypes = ReactPropTypes;

      return ReactPropTypes;
    };

    var propTypes = createCommonjsModule(function (module) {
      /**
       * Copyright (c) 2013-present, Facebook, Inc.
       *
       * This source code is licensed under the MIT license found in the
       * LICENSE file in the root directory of this source tree.
       */

      {
        module.exports = factoryWithTypeCheckers(reactIs.isElement, true);

        // By explicitly using `prop-types` you are opting into new development behavior.
        // http://fb.me/prop-types-in-prod
      }
    });
    propTypes.object;
    propTypes.oneOfType;
    propTypes.element;
    propTypes.bool;
    propTypes.func;


    function hasClass(element, className) {
      if (element.classList) return !!className && element.classList.contains(className);
      return (" " + (element.className.baseVal || element.className) + " ").indexOf(" " + className + " ") !== -1;
    }

    function addClass(element, className) {
      if (element.classList) element.classList.add(className);else if (!hasClass(element, className)) if (typeof element.className === 'string') element.className = element.className + " " + className;else element.setAttribute('class', (element.className && element.className.baseVal || '') + " " + className);
    }

    function replaceClassName(origClass, classToRemove) {
      return origClass.replace(new RegExp("(^|\\s)" + classToRemove + "(?:\\s|$)", 'g'), '$1').replace(/\s+/g, ' ').replace(/^\s*|\s*$/g, '');
    }

    function removeClass(element, className) {
      if (element.classList) {
        element.classList.remove(className);
      } else if (typeof element.className === 'string') {
        element.className = replaceClassName(element.className, className);
      } else {
        element.setAttribute('class', replaceClassName(element.className && element.className.baseVal || '', className));
      }
    }

    var config = {
      disabled: false
    };

    var timeoutsShape = propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number,
      appear: propTypes.number
    }).isRequired]);
    var classNamesShape = propTypes.oneOfType([propTypes.string, propTypes.shape({
      enter: propTypes.string,
      exit: propTypes.string,
      active: propTypes.string
    }), propTypes.shape({
      enter: propTypes.string,
      enterDone: propTypes.string,
      enterActive: propTypes.string,
      exit: propTypes.string,
      exitDone: propTypes.string,
      exitActive: propTypes.string
    })]);

    var TransitionGroupContext = React__default.createContext(null);

    var UNMOUNTED = 'unmounted';
    var EXITED = 'exited';
    var ENTERING = 'entering';
    var ENTERED = 'entered';
    var EXITING = 'exiting';
    /**
     * The Transition component lets you describe a transition from one component
     * state to another _over time_ with a simple declarative API. Most commonly
     * it's used to animate the mounting and unmounting of a component, but can also
     * be used to describe in-place transition states as well.
     *
     * ---
     *
     * **Note**: `Transition` is a platform-agnostic base component. If you're using
     * transitions in CSS, you'll probably want to use
     * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)
     * instead. It inherits all the features of `Transition`, but contains
     * additional features necessary to play nice with CSS transitions (hence the
     * name of the component).
     *
     * ---
     *
     * By default the `Transition` component does not alter the behavior of the
     * component it renders, it only tracks "enter" and "exit" states for the
     * components. It's up to you to give meaning and effect to those states. For
     * example we can add styles to a component when it enters or exits:
     *
     * ```jsx
     * import { Transition } from 'react-transition-group';
     *
     * const duration = 300;
     *
     * const defaultStyle = {
     *   transition: `opacity ${duration}ms ease-in-out`,
     *   opacity: 0,
     * }
     *
     * const transitionStyles = {
     *   entering: { opacity: 1 },
     *   entered:  { opacity: 1 },
     *   exiting:  { opacity: 0 },
     *   exited:  { opacity: 0 },
     * };
     *
     * const Fade = ({ in: inProp }) => (
     *   <Transition in={inProp} timeout={duration}>
     *     {state => (
     *       <div style={{
     *         ...defaultStyle,
     *         ...transitionStyles[state]
     *       }}>
     *         I'm a fade Transition!
     *       </div>
     *     )}
     *   </Transition>
     * );
     * ```
     *
     * There are 4 main states a Transition can be in:
     *  - `'entering'`
     *  - `'entered'`
     *  - `'exiting'`
     *  - `'exited'`
     *
     * Transition state is toggled via the `in` prop. When `true` the component
     * begins the "Enter" stage. During this stage, the component will shift from
     * its current transition state, to `'entering'` for the duration of the
     * transition and then to the `'entered'` stage once it's complete. Let's take
     * the following example (we'll use the
     * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):
     *
     * ```jsx
     * function App() {
     *   const [inProp, setInProp] = useState(false);
     *   return (
     *     <div>
     *       <Transition in={inProp} timeout={500}>
     *         {state => (
     *           // ...
     *         )}
     *       </Transition>
     *       <button onClick={() => setInProp(true)}>
     *         Click to Enter
     *       </button>
     *     </div>
     *   );
     * }
     * ```
     *
     * When the button is clicked the component will shift to the `'entering'` state
     * and stay there for 500ms (the value of `timeout`) before it finally switches
     * to `'entered'`.
     *
     * When `in` is `false` the same thing happens except the state moves from
     * `'exiting'` to `'exited'`.
     */

    var Transition = /*#__PURE__*/function (_React$Component) {
      _inheritsLoose(Transition, _React$Component);

      function Transition(props, context) {
        var _this = _React$Component.call(this, props, context) || this;

        var parentGroup = context; // In the context of a TransitionGroup all enters are really appears

        var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
        var initialStatus;
        _this.appearStatus = null;

        if (props.in) {
          if (appear) {
            initialStatus = EXITED;
            _this.appearStatus = ENTERING;
          } else {
            initialStatus = ENTERED;
          }
        } else {
          if (props.unmountOnExit || props.mountOnEnter) {
            initialStatus = UNMOUNTED;
          } else {
            initialStatus = EXITED;
          }
        }

        _this.state = {
          status: initialStatus
        };
        _this.nextCallback = null;
        return _this;
      }

      Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
        var nextIn = _ref.in;

        if (nextIn && prevState.status === UNMOUNTED) {
          return {
            status: EXITED
          };
        }

        return null;
      } // getSnapshotBeforeUpdate(prevProps) {
      //   let nextStatus = null
      //   if (prevProps !== this.props) {
      //     const { status } = this.state
      //     if (this.props.in) {
      //       if (status !== ENTERING && status !== ENTERED) {
      //         nextStatus = ENTERING
      //       }
      //     } else {
      //       if (status === ENTERING || status === ENTERED) {
      //         nextStatus = EXITING
      //       }
      //     }
      //   }
      //   return { nextStatus }
      // }
      ;

      var _proto = Transition.prototype;

      _proto.componentDidMount = function componentDidMount() {
        this.updateStatus(true, this.appearStatus);
      };

      _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
        var nextStatus = null;

        if (prevProps !== this.props) {
          var status = this.state.status;

          if (this.props.in) {
            if (status !== ENTERING && status !== ENTERED) {
              nextStatus = ENTERING;
            }
          } else {
            if (status === ENTERING || status === ENTERED) {
              nextStatus = EXITING;
            }
          }
        }

        this.updateStatus(false, nextStatus);
      };

      _proto.componentWillUnmount = function componentWillUnmount() {
        this.cancelNextCallback();
      };

      _proto.getTimeouts = function getTimeouts() {
        var timeout = this.props.timeout;
        var exit, enter, appear;
        exit = enter = appear = timeout;

        if (timeout != null && typeof timeout !== 'number') {
          exit = timeout.exit;
          enter = timeout.enter; // TODO: remove fallback for next major

          appear = timeout.appear !== undefined ? timeout.appear : enter;
        }

        return {
          exit: exit,
          enter: enter,
          appear: appear
        };
      };

      _proto.updateStatus = function updateStatus(mounting, nextStatus) {
        if (mounting === void 0) {
          mounting = false;
        }

        if (nextStatus !== null) {
          // nextStatus will always be ENTERING or EXITING.
          this.cancelNextCallback();

          if (nextStatus === ENTERING) {
            this.performEnter(mounting);
          } else {
            this.performExit();
          }
        } else if (this.props.unmountOnExit && this.state.status === EXITED) {
          this.setState({
            status: UNMOUNTED
          });
        }
      };

      _proto.performEnter = function performEnter(mounting) {
        var _this2 = this;

        var enter = this.props.enter;
        var appearing = this.context ? this.context.isMounting : mounting;

        var _ref2 = this.props.nodeRef ? [appearing] : [ReactDOM.findDOMNode(this), appearing],
            maybeNode = _ref2[0],
            maybeAppearing = _ref2[1];

        var timeouts = this.getTimeouts();
        var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED
        // if we are mounting and running this it means appear _must_ be set

        if (!mounting && !enter || config.disabled) {
          this.safeSetState({
            status: ENTERED
          }, function () {
            _this2.props.onEntered(maybeNode);
          });
          return;
        }

        this.props.onEnter(maybeNode, maybeAppearing);
        this.safeSetState({
          status: ENTERING
        }, function () {
          _this2.props.onEntering(maybeNode, maybeAppearing);

          _this2.onTransitionEnd(enterTimeout, function () {
            _this2.safeSetState({
              status: ENTERED
            }, function () {
              _this2.props.onEntered(maybeNode, maybeAppearing);
            });
          });
        });
      };

      _proto.performExit = function performExit() {
        var _this3 = this;

        var exit = this.props.exit;
        var timeouts = this.getTimeouts();
        var maybeNode = this.props.nodeRef ? undefined : ReactDOM.findDOMNode(this); // no exit animation skip right to EXITED

        if (!exit || config.disabled) {
          this.safeSetState({
            status: EXITED
          }, function () {
            _this3.props.onExited(maybeNode);
          });
          return;
        }

        this.props.onExit(maybeNode);
        this.safeSetState({
          status: EXITING
        }, function () {
          _this3.props.onExiting(maybeNode);

          _this3.onTransitionEnd(timeouts.exit, function () {
            _this3.safeSetState({
              status: EXITED
            }, function () {
              _this3.props.onExited(maybeNode);
            });
          });
        });
      };

      _proto.cancelNextCallback = function cancelNextCallback() {
        if (this.nextCallback !== null) {
          this.nextCallback.cancel();
          this.nextCallback = null;
        }
      };

      _proto.safeSetState = function safeSetState(nextState, callback) {
        // This shouldn't be necessary, but there are weird race conditions with
        // setState callbacks and unmounting in testing, so always make sure that
        // we can cancel any pending setState callbacks after we unmount.
        callback = this.setNextCallback(callback);
        this.setState(nextState, callback);
      };

      _proto.setNextCallback = function setNextCallback(callback) {
        var _this4 = this;

        var active = true;

        this.nextCallback = function (event) {
          if (active) {
            active = false;
            _this4.nextCallback = null;
            callback(event);
          }
        };

        this.nextCallback.cancel = function () {
          active = false;
        };

        return this.nextCallback;
      };

      _proto.onTransitionEnd = function onTransitionEnd(timeout, handler) {
        this.setNextCallback(handler);
        var node = this.props.nodeRef ? this.props.nodeRef.current : ReactDOM.findDOMNode(this);
        var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;

        if (!node || doesNotHaveTimeoutOrListener) {
          setTimeout(this.nextCallback, 0);
          return;
        }

        if (this.props.addEndListener) {
          var _ref3 = this.props.nodeRef ? [this.nextCallback] : [node, this.nextCallback],
              maybeNode = _ref3[0],
              maybeNextCallback = _ref3[1];

          this.props.addEndListener(maybeNode, maybeNextCallback);
        }

        if (timeout != null) {
          setTimeout(this.nextCallback, timeout);
        }
      };

      _proto.render = function render() {
        var status = this.state.status;

        if (status === UNMOUNTED) {
          return null;
        }

        var _this$props = this.props,
            children = _this$props.children,
            _in = _this$props.in,
            _mountOnEnter = _this$props.mountOnEnter,
            _unmountOnExit = _this$props.unmountOnExit,
            _appear = _this$props.appear,
            _enter = _this$props.enter,
            _exit = _this$props.exit,
            _timeout = _this$props.timeout,
            _addEndListener = _this$props.addEndListener,
            _onEnter = _this$props.onEnter,
            _onEntering = _this$props.onEntering,
            _onEntered = _this$props.onEntered,
            _onExit = _this$props.onExit,
            _onExiting = _this$props.onExiting,
            _onExited = _this$props.onExited,
            _nodeRef = _this$props.nodeRef,
            childProps = _objectWithoutPropertiesLoose(_this$props, ["children", "in", "mountOnEnter", "unmountOnExit", "appear", "enter", "exit", "timeout", "addEndListener", "onEnter", "onEntering", "onEntered", "onExit", "onExiting", "onExited", "nodeRef"]);

        return (
          /*#__PURE__*/
          // allows for nested Transitions
          React__default.createElement(TransitionGroupContext.Provider, {
            value: null
          }, typeof children === 'function' ? children(status, childProps) : React__default.cloneElement(React__default.Children.only(children), childProps))
        );
      };

      return Transition;
    }(React__default.Component);

    Transition.contextType = TransitionGroupContext;
    Transition.propTypes = {
      /**
       * A React reference to DOM element that need to transition:
       * https://stackoverflow.com/a/51127130/4671932
       *
       *   - When `nodeRef` prop is used, `node` is not passed to callback functions
       *      (e.g. `onEnter`) because user already has direct access to the node.
       *   - When changing `key` prop of `Transition` in a `TransitionGroup` a new
       *     `nodeRef` need to be provided to `Transition` with changed `key` prop
       *     (see
       *     [test/CSSTransition-test.js](https://github.com/reactjs/react-transition-group/blob/13435f897b3ab71f6e19d724f145596f5910581c/test/CSSTransition-test.js#L362-L437)).
       */
      nodeRef: propTypes.shape({
        current: typeof Element === 'undefined' ? propTypes.any : propTypes.instanceOf(Element)
      }),

      /**
       * A `function` child can be used instead of a React element. This function is
       * called with the current transition status (`'entering'`, `'entered'`,
       * `'exiting'`, `'exited'`), which can be used to apply context
       * specific props to a component.
       *
       * ```jsx
       * <Transition in={this.state.in} timeout={150}>
       *   {state => (
       *     <MyComponent className={`fade fade-${state}`} />
       *   )}
       * </Transition>
       * ```
       */
      children: propTypes.oneOfType([propTypes.func.isRequired, propTypes.element.isRequired]).isRequired,

      /**
       * Show the component; triggers the enter or exit states
       */
      in: propTypes.bool,

      /**
       * By default the child component is mounted immediately along with
       * the parent `Transition` component. If you want to "lazy mount" the component on the
       * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
       * mounted, even on "exited", unless you also specify `unmountOnExit`.
       */
      mountOnEnter: propTypes.bool,

      /**
       * By default the child component stays mounted after it reaches the `'exited'` state.
       * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
       */
      unmountOnExit: propTypes.bool,

      /**
       * By default the child component does not perform the enter transition when
       * it first mounts, regardless of the value of `in`. If you want this
       * behavior, set both `appear` and `in` to `true`.
       *
       * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop
       * > only adds an additional enter transition. However, in the
       * > `<CSSTransition>` component that first enter transition does result in
       * > additional `.appear-*` classes, that way you can choose to style it
       * > differently.
       */
      appear: propTypes.bool,

      /**
       * Enable or disable enter transitions.
       */
      enter: propTypes.bool,

      /**
       * Enable or disable exit transitions.
       */
      exit: propTypes.bool,

      /**
       * The duration of the transition, in milliseconds.
       * Required unless `addEndListener` is provided.
       *
       * You may specify a single timeout for all transitions:
       *
       * ```jsx
       * timeout={500}
       * ```
       *
       * or individually:
       *
       * ```jsx
       * timeout={{
       *  appear: 500,
       *  enter: 300,
       *  exit: 500,
       * }}
       * ```
       *
       * - `appear` defaults to the value of `enter`
       * - `enter` defaults to `0`
       * - `exit` defaults to `0`
       *
       * @type {number | { enter?: number, exit?: number, appear?: number }}
       */
      timeout: function timeout(props) {
        var pt = timeoutsShape;
        if (!props.addEndListener) pt = pt.isRequired;

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        return pt.apply(void 0, [props].concat(args));
      },

      /**
       * Add a custom transition end trigger. Called with the transitioning
       * DOM node and a `done` callback. Allows for more fine grained transition end
       * logic. Timeouts are still used as a fallback if provided.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * ```jsx
       * addEndListener={(node, done) => {
       *   // use the css transitionend event to mark the finish of a transition
       *   node.addEventListener('transitionend', done, false);
       * }}
       * ```
       */
      addEndListener: propTypes.func,

      /**
       * Callback fired before the "entering" status is applied. An extra parameter
       * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement, isAppearing: bool) -> void
       */
      onEnter: propTypes.func,

      /**
       * Callback fired after the "entering" status is applied. An extra parameter
       * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement, isAppearing: bool)
       */
      onEntering: propTypes.func,

      /**
       * Callback fired after the "entered" status is applied. An extra parameter
       * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement, isAppearing: bool) -> void
       */
      onEntered: propTypes.func,

      /**
       * Callback fired before the "exiting" status is applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement) -> void
       */
      onExit: propTypes.func,

      /**
       * Callback fired after the "exiting" status is applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement) -> void
       */
      onExiting: propTypes.func,

      /**
       * Callback fired after the "exited" status is applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed
       *
       * @type Function(node: HtmlElement) -> void
       */
      onExited: propTypes.func
    }; // Name the function so it is clearer in the documentation

    function noop() {}

    Transition.defaultProps = {
      in: false,
      mountOnEnter: false,
      unmountOnExit: false,
      appear: false,
      enter: true,
      exit: true,
      onEnter: noop,
      onEntering: noop,
      onEntered: noop,
      onExit: noop,
      onExiting: noop,
      onExited: noop
    };
    Transition.UNMOUNTED = UNMOUNTED;
    Transition.EXITED = EXITED;
    Transition.ENTERING = ENTERING;
    Transition.ENTERED = ENTERED;
    Transition.EXITING = EXITING;

    var _addClass = function addClass$1(node, classes) {
      return node && classes && classes.split(' ').forEach(function (c) {
        return addClass(node, c);
      });
    };

    var removeClass$1 = function removeClass$1(node, classes) {
      return node && classes && classes.split(' ').forEach(function (c) {
        return removeClass(node, c);
      });
    };
    /**
     * A transition component inspired by the excellent
     * [ng-animate](https://docs.angularjs.org/api/ngAnimate) library, you should
     * use it if you're using CSS transitions or animations. It's built upon the
     * [`Transition`](https://reactcommunity.org/react-transition-group/transition)
     * component, so it inherits all of its props.
     *
     * `CSSTransition` applies a pair of class names during the `appear`, `enter`,
     * and `exit` states of the transition. The first class is applied and then a
     * second `*-active` class in order to activate the CSS transition. After the
     * transition, matching `*-done` class names are applied to persist the
     * transition state.
     *
     * ```jsx
     * function App() {
     *   const [inProp, setInProp] = useState(false);
     *   return (
     *     <div>
     *       <CSSTransition in={inProp} timeout={200} classNames="my-node">
     *         <div>
     *           {"I'll receive my-node-* classes"}
     *         </div>
     *       </CSSTransition>
     *       <button type="button" onClick={() => setInProp(true)}>
     *         Click to Enter
     *       </button>
     *     </div>
     *   );
     * }
     * ```
     *
     * When the `in` prop is set to `true`, the child component will first receive
     * the class `example-enter`, then the `example-enter-active` will be added in
     * the next tick. `CSSTransition` [forces a
     * reflow](https://github.com/reactjs/react-transition-group/blob/5007303e729a74be66a21c3e2205e4916821524b/src/CSSTransition.js#L208-L215)
     * between before adding the `example-enter-active`. This is an important trick
     * because it allows us to transition between `example-enter` and
     * `example-enter-active` even though they were added immediately one after
     * another. Most notably, this is what makes it possible for us to animate
     * _appearance_.
     *
     * ```css
     * .my-node-enter {
     *   opacity: 0;
     * }
     * .my-node-enter-active {
     *   opacity: 1;
     *   transition: opacity 200ms;
     * }
     * .my-node-exit {
     *   opacity: 1;
     * }
     * .my-node-exit-active {
     *   opacity: 0;
     *   transition: opacity 200ms;
     * }
     * ```
     *
     * `*-active` classes represent which styles you want to animate **to**, so it's
     * important to add `transition` declaration only to them, otherwise transitions
     * might not behave as intended! This might not be obvious when the transitions
     * are symmetrical, i.e. when `*-enter-active` is the same as `*-exit`, like in
     * the example above (minus `transition`), but it becomes apparent in more
     * complex transitions.
     *
     * **Note**: If you're using the
     * [`appear`](http://reactcommunity.org/react-transition-group/transition#Transition-prop-appear)
     * prop, make sure to define styles for `.appear-*` classes as well.
     */

    var CSSTransition = /*#__PURE__*/function (_React$Component) {
      _inheritsLoose(CSSTransition, _React$Component);

      function CSSTransition() {
        var _this;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
        _this.appliedClasses = {
          appear: {},
          enter: {},
          exit: {}
        };

        _this.onEnter = function (maybeNode, maybeAppearing) {
          var _this$resolveArgument = _this.resolveArguments(maybeNode, maybeAppearing),
              node = _this$resolveArgument[0],
              appearing = _this$resolveArgument[1];

          _this.removeClasses(node, 'exit');

          _this.addClass(node, appearing ? 'appear' : 'enter', 'base');

          if (_this.props.onEnter) {
            _this.props.onEnter(maybeNode, maybeAppearing);
          }
        };

        _this.onEntering = function (maybeNode, maybeAppearing) {
          var _this$resolveArgument2 = _this.resolveArguments(maybeNode, maybeAppearing),
              node = _this$resolveArgument2[0],
              appearing = _this$resolveArgument2[1];

          var type = appearing ? 'appear' : 'enter';

          _this.addClass(node, type, 'active');

          if (_this.props.onEntering) {
            _this.props.onEntering(maybeNode, maybeAppearing);
          }
        };

        _this.onEntered = function (maybeNode, maybeAppearing) {
          var _this$resolveArgument3 = _this.resolveArguments(maybeNode, maybeAppearing),
              node = _this$resolveArgument3[0],
              appearing = _this$resolveArgument3[1];

          var type = appearing ? 'appear' : 'enter';

          _this.removeClasses(node, type);

          _this.addClass(node, type, 'done');

          if (_this.props.onEntered) {
            _this.props.onEntered(maybeNode, maybeAppearing);
          }
        };

        _this.onExit = function (maybeNode) {
          var _this$resolveArgument4 = _this.resolveArguments(maybeNode),
              node = _this$resolveArgument4[0];

          _this.removeClasses(node, 'appear');

          _this.removeClasses(node, 'enter');

          _this.addClass(node, 'exit', 'base');

          if (_this.props.onExit) {
            _this.props.onExit(maybeNode);
          }
        };

        _this.onExiting = function (maybeNode) {
          var _this$resolveArgument5 = _this.resolveArguments(maybeNode),
              node = _this$resolveArgument5[0];

          _this.addClass(node, 'exit', 'active');

          if (_this.props.onExiting) {
            _this.props.onExiting(maybeNode);
          }
        };

        _this.onExited = function (maybeNode) {
          var _this$resolveArgument6 = _this.resolveArguments(maybeNode),
              node = _this$resolveArgument6[0];

          _this.removeClasses(node, 'exit');

          _this.addClass(node, 'exit', 'done');

          if (_this.props.onExited) {
            _this.props.onExited(maybeNode);
          }
        };

        _this.resolveArguments = function (maybeNode, maybeAppearing) {
          return _this.props.nodeRef ? [_this.props.nodeRef.current, maybeNode] // here `maybeNode` is actually `appearing`
          : [maybeNode, maybeAppearing];
        };

        _this.getClassNames = function (type) {
          var classNames = _this.props.classNames;
          var isStringClassNames = typeof classNames === 'string';
          var prefix = isStringClassNames && classNames ? classNames + "-" : '';
          var baseClassName = isStringClassNames ? "" + prefix + type : classNames[type];
          var activeClassName = isStringClassNames ? baseClassName + "-active" : classNames[type + "Active"];
          var doneClassName = isStringClassNames ? baseClassName + "-done" : classNames[type + "Done"];
          return {
            baseClassName: baseClassName,
            activeClassName: activeClassName,
            doneClassName: doneClassName
          };
        };

        return _this;
      }

      var _proto = CSSTransition.prototype;

      _proto.addClass = function addClass(node, type, phase) {
        var className = this.getClassNames(type)[phase + "ClassName"];

        var _this$getClassNames = this.getClassNames('enter'),
            doneClassName = _this$getClassNames.doneClassName;

        if (type === 'appear' && phase === 'done' && doneClassName) {
          className += " " + doneClassName;
        } // This is for to force a repaint,
        // which is necessary in order to transition styles when adding a class name.


        if (phase === 'active') {
          /* eslint-disable no-unused-expressions */
          node && node.scrollTop;
        }

        if (className) {
          this.appliedClasses[type][phase] = className;

          _addClass(node, className);
        }
      };

      _proto.removeClasses = function removeClasses(node, type) {
        var _this$appliedClasses$ = this.appliedClasses[type],
            baseClassName = _this$appliedClasses$.base,
            activeClassName = _this$appliedClasses$.active,
            doneClassName = _this$appliedClasses$.done;
        this.appliedClasses[type] = {};

        if (baseClassName) {
          removeClass$1(node, baseClassName);
        }

        if (activeClassName) {
          removeClass$1(node, activeClassName);
        }

        if (doneClassName) {
          removeClass$1(node, doneClassName);
        }
      };

      _proto.render = function render() {
        var _this$props = this.props,
            _ = _this$props.classNames,
            props = _objectWithoutPropertiesLoose(_this$props, ["classNames"]);

        return (/*#__PURE__*/React__default.createElement(Transition, _extends({}, props, {
            onEnter: this.onEnter,
            onEntered: this.onEntered,
            onEntering: this.onEntering,
            onExit: this.onExit,
            onExiting: this.onExiting,
            onExited: this.onExited
          }))
        );
      };

      return CSSTransition;
    }(React__default.Component);

    CSSTransition.defaultProps = {
      classNames: ''
    };
    CSSTransition.propTypes = _extends({}, Transition.propTypes, {
      /**
       * The animation classNames applied to the component as it appears, enters,
       * exits or has finished the transition. A single name can be provided, which
       * will be suffixed for each stage, e.g. `classNames="fade"` applies:
       *
       * - `fade-appear`, `fade-appear-active`, `fade-appear-done`
       * - `fade-enter`, `fade-enter-active`, `fade-enter-done`
       * - `fade-exit`, `fade-exit-active`, `fade-exit-done`
       *
       * A few details to note about how these classes are applied:
       *
       * 1. They are _joined_ with the ones that are already defined on the child
       *    component, so if you want to add some base styles, you can use
       *    `className` without worrying that it will be overridden.
       *
       * 2. If the transition component mounts with `in={false}`, no classes are
       *    applied yet. You might be expecting `*-exit-done`, but if you think
       *    about it, a component cannot finish exiting if it hasn't entered yet.
       *
       * 2. `fade-appear-done` and `fade-enter-done` will _both_ be applied. This
       *    allows you to define different behavior for when appearing is done and
       *    when regular entering is done, using selectors like
       *    `.fade-enter-done:not(.fade-appear-done)`. For example, you could apply
       *    an epic entrance animation when element first appears in the DOM using
       *    [Animate.css](https://daneden.github.io/animate.css/). Otherwise you can
       *    simply use `fade-enter-done` for defining both cases.
       *
       * Each individual classNames can also be specified independently like:
       *
       * ```js
       * classNames={{
       *  appear: 'my-appear',
       *  appearActive: 'my-active-appear',
       *  appearDone: 'my-done-appear',
       *  enter: 'my-enter',
       *  enterActive: 'my-active-enter',
       *  enterDone: 'my-done-enter',
       *  exit: 'my-exit',
       *  exitActive: 'my-active-exit',
       *  exitDone: 'my-done-exit',
       * }}
       * ```
       *
       * If you want to set these classes using CSS Modules:
       *
       * ```js
       * import styles from './styles.css';
       * ```
       *
       * you might want to use camelCase in your CSS file, that way could simply
       * spread them instead of listing them one by one:
       *
       * ```js
       * classNames={{ ...styles }}
       * ```
       *
       * @type {string | {
       *  appear?: string,
       *  appearActive?: string,
       *  appearDone?: string,
       *  enter?: string,
       *  enterActive?: string,
       *  enterDone?: string,
       *  exit?: string,
       *  exitActive?: string,
       *  exitDone?: string,
       * }}
       */
      classNames: classNamesShape,

      /**
       * A `<Transition>` callback fired immediately after the 'enter' or 'appear' class is
       * applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement, isAppearing: bool)
       */
      onEnter: propTypes.func,

      /**
       * A `<Transition>` callback fired immediately after the 'enter-active' or
       * 'appear-active' class is applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement, isAppearing: bool)
       */
      onEntering: propTypes.func,

      /**
       * A `<Transition>` callback fired immediately after the 'enter' or
       * 'appear' classes are **removed** and the `done` class is added to the DOM node.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed.
       *
       * @type Function(node: HtmlElement, isAppearing: bool)
       */
      onEntered: propTypes.func,

      /**
       * A `<Transition>` callback fired immediately after the 'exit' class is
       * applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed
       *
       * @type Function(node: HtmlElement)
       */
      onExit: propTypes.func,

      /**
       * A `<Transition>` callback fired immediately after the 'exit-active' is applied.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed
       *
       * @type Function(node: HtmlElement)
       */
      onExiting: propTypes.func,

      /**
       * A `<Transition>` callback fired immediately after the 'exit' classes
       * are **removed** and the `exit-done` class is added to the DOM node.
       *
       * **Note**: when `nodeRef` prop is passed, `node` is not passed
       *
       * @type Function(node: HtmlElement)
       */
      onExited: propTypes.func
    });

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }

      return self;
    }

    /**
     * Given `this.props.children`, return an object mapping key to child.
     *
     * @param {*} children `this.props.children`
     * @return {object} Mapping of key to child
     */

    function getChildMapping(children, mapFn) {
      var mapper = function mapper(child) {
        return mapFn && React.isValidElement(child) ? mapFn(child) : child;
      };

      var result = Object.create(null);
      if (children) React.Children.map(children, function (c) {
        return c;
      }).forEach(function (child) {
        // run the map function here instead so that the key is the computed one
        result[child.key] = mapper(child);
      });
      return result;
    }
    /**
     * When you're adding or removing children some may be added or removed in the
     * same render pass. We want to show *both* since we want to simultaneously
     * animate elements in and out. This function takes a previous set of keys
     * and a new set of keys and merges them with its best guess of the correct
     * ordering. In the future we may expose some of the utilities in
     * ReactMultiChild to make this easy, but for now React itself does not
     * directly have this concept of the union of prevChildren and nextChildren
     * so we implement it here.
     *
     * @param {object} prev prev children as returned from
     * `ReactTransitionChildMapping.getChildMapping()`.
     * @param {object} next next children as returned from
     * `ReactTransitionChildMapping.getChildMapping()`.
     * @return {object} a key set that contains all keys in `prev` and all keys
     * in `next` in a reasonable order.
     */

    function mergeChildMappings(prev, next) {
      prev = prev || {};
      next = next || {};

      function getValueForKey(key) {
        return key in next ? next[key] : prev[key];
      } // For each key of `next`, the list of keys to insert before that key in
      // the combined list


      var nextKeysPending = Object.create(null);
      var pendingKeys = [];

      for (var prevKey in prev) {
        if (prevKey in next) {
          if (pendingKeys.length) {
            nextKeysPending[prevKey] = pendingKeys;
            pendingKeys = [];
          }
        } else {
          pendingKeys.push(prevKey);
        }
      }

      var i;
      var childMapping = {};

      for (var nextKey in next) {
        if (nextKeysPending[nextKey]) {
          for (i = 0; i < nextKeysPending[nextKey].length; i++) {
            var pendingNextKey = nextKeysPending[nextKey][i];
            childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
          }
        }

        childMapping[nextKey] = getValueForKey(nextKey);
      } // Finally, add the keys which didn't appear before any key in `next`


      for (i = 0; i < pendingKeys.length; i++) {
        childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
      }

      return childMapping;
    }

    function getProp(child, prop, props) {
      return props[prop] != null ? props[prop] : child.props[prop];
    }

    function getInitialChildMapping(props, onExited) {
      return getChildMapping(props.children, function (child) {
        return React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: true,
          appear: getProp(child, 'appear', props),
          enter: getProp(child, 'enter', props),
          exit: getProp(child, 'exit', props)
        });
      });
    }
    function getNextChildMapping(nextProps, prevChildMapping, onExited) {
      var nextChildMapping = getChildMapping(nextProps.children);
      var children = mergeChildMappings(prevChildMapping, nextChildMapping);
      Object.keys(children).forEach(function (key) {
        var child = children[key];
        if (!React.isValidElement(child)) return;
        var hasPrev = key in prevChildMapping;
        var hasNext = key in nextChildMapping;
        var prevChild = prevChildMapping[key];
        var isLeaving = React.isValidElement(prevChild) && !prevChild.props.in; // item is new (entering)

        if (hasNext && (!hasPrev || isLeaving)) {
          // console.log('entering', key)
          children[key] = React.cloneElement(child, {
            onExited: onExited.bind(null, child),
            in: true,
            exit: getProp(child, 'exit', nextProps),
            enter: getProp(child, 'enter', nextProps)
          });
        } else if (!hasNext && hasPrev && !isLeaving) {
          // item is old (exiting)
          // console.log('leaving', key)
          children[key] = React.cloneElement(child, {
            in: false
          });
        } else if (hasNext && hasPrev && React.isValidElement(prevChild)) {
          // item hasn't changed transition states
          // copy over the last transition props;
          // console.log('unchanged', key)
          children[key] = React.cloneElement(child, {
            onExited: onExited.bind(null, child),
            in: prevChild.props.in,
            exit: getProp(child, 'exit', nextProps),
            enter: getProp(child, 'enter', nextProps)
          });
        }
      });
      return children;
    }

    var values = Object.values || function (obj) {
      return Object.keys(obj).map(function (k) {
        return obj[k];
      });
    };

    /**
     * The `<TransitionGroup>` component manages a set of transition components
     * (`<Transition>` and `<CSSTransition>`) in a list. Like with the transition
     * components, `<TransitionGroup>` is a state machine for managing the mounting
     * and unmounting of components over time.
     *
     * Consider the example below. As items are removed or added to the TodoList the
     * `in` prop is toggled automatically by the `<TransitionGroup>`.
     *
     * Note that `<TransitionGroup>`  does not define any animation behavior!
     * Exactly _how_ a list item animates is up to the individual transition
     * component. This means you can mix and match animations across different list
     * items.
     */

    var TransitionGroup = /*#__PURE__*/function (_React$Component) {
      _inheritsLoose(TransitionGroup, _React$Component);

      function TransitionGroup(props, context) {
        var _this = _React$Component.call(this, props, context) || this;

        var handleExited = _this.handleExited.bind(_assertThisInitialized(_this)); // Initial children should all be entering, dependent on appear


        _this.state = {
          contextValue: {
            isMounting: true
          },
          handleExited: handleExited,
          firstRender: true
        };
        return _this;
      }

      var _proto = TransitionGroup.prototype;

      _proto.componentDidMount = function componentDidMount() {
        this.mounted = true;
        this.setState({
          contextValue: {
            isMounting: false
          }
        });
      };

      _proto.componentWillUnmount = function componentWillUnmount() {
        this.mounted = false;
      };

      TransitionGroup.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
        var prevChildMapping = _ref.children,
            handleExited = _ref.handleExited,
            firstRender = _ref.firstRender;
        return {
          children: firstRender ? getInitialChildMapping(nextProps, handleExited) : getNextChildMapping(nextProps, prevChildMapping, handleExited),
          firstRender: false
        };
      } // node is `undefined` when user provided `nodeRef` prop
      ;

      _proto.handleExited = function handleExited(child, node) {
        var currentChildMapping = getChildMapping(this.props.children);
        if (child.key in currentChildMapping) return;

        if (child.props.onExited) {
          child.props.onExited(node);
        }

        if (this.mounted) {
          this.setState(function (state) {
            var children = _extends({}, state.children);

            delete children[child.key];
            return {
              children: children
            };
          });
        }
      };

      _proto.render = function render() {
        var _this$props = this.props,
            Component = _this$props.component,
            childFactory = _this$props.childFactory,
            props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);

        var contextValue = this.state.contextValue;
        var children = values(this.state.children).map(childFactory);
        delete props.appear;
        delete props.enter;
        delete props.exit;

        if (Component === null) {
          return (/*#__PURE__*/React__default.createElement(TransitionGroupContext.Provider, {
              value: contextValue
            }, children)
          );
        }

        return (/*#__PURE__*/React__default.createElement(TransitionGroupContext.Provider, {
            value: contextValue
          }, /*#__PURE__*/React__default.createElement(Component, props, children))
        );
      };

      return TransitionGroup;
    }(React__default.Component);

    TransitionGroup.propTypes = {
      /**
       * `<TransitionGroup>` renders a `<div>` by default. You can change this
       * behavior by providing a `component` prop.
       * If you use React v16+ and would like to avoid a wrapping `<div>` element
       * you can pass in `component={null}`. This is useful if the wrapping div
       * borks your css styles.
       */
      component: propTypes.any,

      /**
       * A set of `<Transition>` components, that are toggled `in` and out as they
       * leave. the `<TransitionGroup>` will inject specific transition props, so
       * remember to spread them through if you are wrapping the `<Transition>` as
       * with our `<Fade>` example.
       *
       * While this component is meant for multiple `Transition` or `CSSTransition`
       * children, sometimes you may want to have a single transition child with
       * content that you want to be transitioned out and in when you change it
       * (e.g. routes, images etc.) In that case you can change the `key` prop of
       * the transition child as you change its content, this will cause
       * `TransitionGroup` to transition the child out and back in.
       */
      children: propTypes.node,

      /**
       * A convenience prop that enables or disables appear animations
       * for all children. Note that specifying this will override any defaults set
       * on individual children Transitions.
       */
      appear: propTypes.bool,

      /**
       * A convenience prop that enables or disables enter animations
       * for all children. Note that specifying this will override any defaults set
       * on individual children Transitions.
       */
      enter: propTypes.bool,

      /**
       * A convenience prop that enables or disables exit animations
       * for all children. Note that specifying this will override any defaults set
       * on individual children Transitions.
       */
      exit: propTypes.bool,

      /**
       * You may need to apply reactive updates to a child as it is exiting.
       * This is generally done by using `cloneElement` however in the case of an exiting
       * child the element has already been removed and not accessible to the consumer.
       *
       * If you do need to update a child as it leaves you can provide a `childFactory`
       * to wrap every child, even the ones that are leaving.
       *
       * @type Function(child: ReactElement) -> ReactElement
       */
      childFactory: propTypes.func
    };
    TransitionGroup.defaultProps = {
      component: 'div',
      childFactory: function childFactory(child) {
        return child;
      }
    };

    /**
     * The `<ReplaceTransition>` component is a specialized `Transition` component
     * that animates between two children.
     *
     * ```jsx
     * <ReplaceTransition in>
     *   <Fade><div>I appear first</div></Fade>
     *   <Fade><div>I replace the above</div></Fade>
     * </ReplaceTransition>
     * ```
     */

    var ReplaceTransition = /*#__PURE__*/function (_React$Component) {
      _inheritsLoose(ReplaceTransition, _React$Component);

      function ReplaceTransition() {
        var _this;

        for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
          _args[_key] = arguments[_key];
        }

        _this = _React$Component.call.apply(_React$Component, [this].concat(_args)) || this;

        _this.handleEnter = function () {
          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }

          return _this.handleLifecycle('onEnter', 0, args);
        };

        _this.handleEntering = function () {
          for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
            args[_key3] = arguments[_key3];
          }

          return _this.handleLifecycle('onEntering', 0, args);
        };

        _this.handleEntered = function () {
          for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
            args[_key4] = arguments[_key4];
          }

          return _this.handleLifecycle('onEntered', 0, args);
        };

        _this.handleExit = function () {
          for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
            args[_key5] = arguments[_key5];
          }

          return _this.handleLifecycle('onExit', 1, args);
        };

        _this.handleExiting = function () {
          for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
            args[_key6] = arguments[_key6];
          }

          return _this.handleLifecycle('onExiting', 1, args);
        };

        _this.handleExited = function () {
          for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
            args[_key7] = arguments[_key7];
          }

          return _this.handleLifecycle('onExited', 1, args);
        };

        return _this;
      }

      var _proto = ReplaceTransition.prototype;

      _proto.handleLifecycle = function handleLifecycle(handler, idx, originalArgs) {
        var _child$props;

        var children = this.props.children;
        var child = React__default.Children.toArray(children)[idx];
        if (child.props[handler]) (_child$props = child.props)[handler].apply(_child$props, originalArgs);

        if (this.props[handler]) {
          var maybeNode = child.props.nodeRef ? undefined : ReactDOM.findDOMNode(this);
          this.props[handler](maybeNode);
        }
      };

      _proto.render = function render() {
        var _this$props = this.props,
            children = _this$props.children,
            inProp = _this$props.in,
            props = _objectWithoutPropertiesLoose(_this$props, ["children", "in"]);

        var _React$Children$toArr = React__default.Children.toArray(children),
            first = _React$Children$toArr[0],
            second = _React$Children$toArr[1];

        delete props.onEnter;
        delete props.onEntering;
        delete props.onEntered;
        delete props.onExit;
        delete props.onExiting;
        delete props.onExited;
        return (/*#__PURE__*/React__default.createElement(TransitionGroup, props, inProp ? React__default.cloneElement(first, {
            key: 'first',
            onEnter: this.handleEnter,
            onEntering: this.handleEntering,
            onEntered: this.handleEntered
          }) : React__default.cloneElement(second, {
            key: 'second',
            onEnter: this.handleExit,
            onEntering: this.handleExiting,
            onEntered: this.handleExited
          }))
        );
      };

      return ReplaceTransition;
    }(React__default.Component);

    ReplaceTransition.propTypes = {
      in: propTypes.bool.isRequired,
      children: function children(props, propName) {
        if (React__default.Children.count(props[propName]) !== 2) return new Error("\"" + propName + "\" must be exactly two transition components.");
        return null;
      }
    };

    var _leaveRenders, _enterRenders;

    function areChildrenDifferent(oldChildren, newChildren) {
      if (oldChildren === newChildren) return false;

      if (React__default.isValidElement(oldChildren) && React__default.isValidElement(newChildren) && oldChildren.key != null && oldChildren.key === newChildren.key) {
        return false;
      }

      return true;
    }
    /**
     * Enum of modes for SwitchTransition component
     * @enum { string }
     */

    var modes = {
      out: 'out-in',
      in: 'in-out'
    };

    var callHook = function callHook(element, name, cb) {
      return function () {
        var _element$props;

        element.props[name] && (_element$props = element.props)[name].apply(_element$props, arguments);
        cb();
      };
    };

    var leaveRenders = (_leaveRenders = {}, _leaveRenders[modes.out] = function (_ref) {
      var current = _ref.current,
          changeState = _ref.changeState;
      return React__default.cloneElement(current, {
        in: false,
        onExited: callHook(current, 'onExited', function () {
          changeState(ENTERING, null);
        })
      });
    }, _leaveRenders[modes.in] = function (_ref2) {
      var current = _ref2.current,
          changeState = _ref2.changeState,
          children = _ref2.children;
      return [current, React__default.cloneElement(children, {
        in: true,
        onEntered: callHook(children, 'onEntered', function () {
          changeState(ENTERING);
        })
      })];
    }, _leaveRenders);
    var enterRenders = (_enterRenders = {}, _enterRenders[modes.out] = function (_ref3) {
      var children = _ref3.children,
          changeState = _ref3.changeState;
      return React__default.cloneElement(children, {
        in: true,
        onEntered: callHook(children, 'onEntered', function () {
          changeState(ENTERED, React__default.cloneElement(children, {
            in: true
          }));
        })
      });
    }, _enterRenders[modes.in] = function (_ref4) {
      var current = _ref4.current,
          children = _ref4.children,
          changeState = _ref4.changeState;
      return [React__default.cloneElement(current, {
        in: false,
        onExited: callHook(current, 'onExited', function () {
          changeState(ENTERED, React__default.cloneElement(children, {
            in: true
          }));
        })
      }), React__default.cloneElement(children, {
        in: true
      })];
    }, _enterRenders);
    /**
     * A transition component inspired by the [vue transition modes](https://vuejs.org/v2/guide/transitions.html#Transition-Modes).
     * You can use it when you want to control the render between state transitions.
     * Based on the selected mode and the child's key which is the `Transition` or `CSSTransition` component, the `SwitchTransition` makes a consistent transition between them.
     *
     * If the `out-in` mode is selected, the `SwitchTransition` waits until the old child leaves and then inserts a new child.
     * If the `in-out` mode is selected, the `SwitchTransition` inserts a new child first, waits for the new child to enter and then removes the old child.
     *
     * **Note**: If you want the animation to happen simultaneously
     * (that is, to have the old child removed and a new child inserted **at the same time**),
     * you should use
     * [`TransitionGroup`](https://reactcommunity.org/react-transition-group/transition-group)
     * instead.
     *
     * ```jsx
     * function App() {
     *  const [state, setState] = useState(false);
     *  return (
     *    <SwitchTransition>
     *      <CSSTransition
     *        key={state ? "Goodbye, world!" : "Hello, world!"}
     *        addEndListener={(node, done) => node.addEventListener("transitionend", done, false)}
     *        classNames='fade'
     *      >
     *        <button onClick={() => setState(state => !state)}>
     *          {state ? "Goodbye, world!" : "Hello, world!"}
     *        </button>
     *      </CSSTransition>
     *    </SwitchTransition>
     *  );
     * }
     * ```
     *
     * ```css
     * .fade-enter{
     *    opacity: 0;
     * }
     * .fade-exit{
     *    opacity: 1;
     * }
     * .fade-enter-active{
     *    opacity: 1;
     * }
     * .fade-exit-active{
     *    opacity: 0;
     * }
     * .fade-enter-active,
     * .fade-exit-active{
     *    transition: opacity 500ms;
     * }
     * ```
     */

    var SwitchTransition = /*#__PURE__*/function (_React$Component) {
      _inheritsLoose(SwitchTransition, _React$Component);

      function SwitchTransition() {
        var _this;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
        _this.state = {
          status: ENTERED,
          current: null
        };
        _this.appeared = false;

        _this.changeState = function (status, current) {
          if (current === void 0) {
            current = _this.state.current;
          }

          _this.setState({
            status: status,
            current: current
          });
        };

        return _this;
      }

      var _proto = SwitchTransition.prototype;

      _proto.componentDidMount = function componentDidMount() {
        this.appeared = true;
      };

      SwitchTransition.getDerivedStateFromProps = function getDerivedStateFromProps(props, state) {
        if (props.children == null) {
          return {
            current: null
          };
        }

        if (state.status === ENTERING && props.mode === modes.in) {
          return {
            status: ENTERING
          };
        }

        if (state.current && areChildrenDifferent(state.current, props.children)) {
          return {
            status: EXITING
          };
        }

        return {
          current: React__default.cloneElement(props.children, {
            in: true
          })
        };
      };

      _proto.render = function render() {
        var _this$props = this.props,
            children = _this$props.children,
            mode = _this$props.mode,
            _this$state = this.state,
            status = _this$state.status,
            current = _this$state.current;
        var data = {
          children: children,
          current: current,
          changeState: this.changeState,
          status: status
        };
        var component;

        switch (status) {
          case ENTERING:
            component = enterRenders[mode](data);
            break;

          case EXITING:
            component = leaveRenders[mode](data);
            break;

          case ENTERED:
            component = current;
        }

        return (/*#__PURE__*/React__default.createElement(TransitionGroupContext.Provider, {
            value: {
              isMounting: !this.appeared
            }
          }, component)
        );
      };

      return SwitchTransition;
    }(React__default.Component);

    SwitchTransition.propTypes = {
      /**
       * Transition modes.
       * `out-in`: Current element transitions out first, then when complete, the new element transitions in.
       * `in-out`: New element transitions in first, then when complete, the current element transitions out.
       *
       * @type {'out-in'|'in-out'}
       */
      mode: propTypes.oneOf([modes.in, modes.out]),

      /**
       * Any `Transition` or `CSSTransition` component.
       */
      children: propTypes.oneOfType([propTypes.element.isRequired])
    };
    SwitchTransition.defaultProps = {
      mode: modes.out
    };

    exports.CSSTransition = CSSTransition;
    exports.ReplaceTransition = ReplaceTransition;
    exports.SwitchTransition = SwitchTransition;
    exports.Transition = Transition;
    exports.TransitionGroup = TransitionGroup;
    exports.config = config;

    Object.defineProperty(exports, '__esModule', { value: true });
  });
});
//# sourceMappingURL=react-transition-group.js.map