Liferay.Loader.define('frontend-js-components-web$lodash-es@4.17.15/meanBy', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseIteratee from './_baseIteratee.js';
  import baseMean from './_baseMean.js';

  /**
   * This method is like `_.mean` except that it accepts `iteratee` which is
   * invoked for each element in `array` to generate the value to be averaged.
   * The iteratee is invoked with one argument: (value).
   *
   * @static
   * @memberOf _
   * @since 4.7.0
   * @category Math
   * @param {Array} array The array to iterate over.
   * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
   * @returns {number} Returns the mean.
   * @example
   *
   * var objects = [{ 'n': 4 }, { 'n': 2 }, { 'n': 8 }, { 'n': 6 }];
   *
   * _.meanBy(objects, function(o) { return o.n; });
   * // => 5
   *
   * // The `_.property` iteratee shorthand.
   * _.meanBy(objects, 'n');
   * // => 5
   */
  function meanBy(array, iteratee) {
    return baseMean(array, baseIteratee(iteratee, 2));
  }

  export default meanBy;
});
//# sourceMappingURL=meanBy.js.map