Liferay.Loader.define('frontend-js-components-web$lodash-es@4.17.15/functions', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseFunctions from './_baseFunctions.js';
  import keys from './keys.js';

  /**
   * Creates an array of function property names from own enumerable properties
   * of `object`.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Object
   * @param {Object} object The object to inspect.
   * @returns {Array} Returns the function names.
   * @see _.functionsIn
   * @example
   *
   * function Foo() {
   *   this.a = _.constant('a');
   *   this.b = _.constant('b');
   * }
   *
   * Foo.prototype.c = _.constant('c');
   *
   * _.functions(new Foo);
   * // => ['a', 'b']
   */
  function functions(object) {
    return object == null ? [] : baseFunctions(object, keys(object));
  }

  export default functions;
});
//# sourceMappingURL=functions.js.map