Liferay.Loader.define('frontend-js-components-web$lodash-es@4.17.15/_MapCache', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import mapCacheClear from './_mapCacheClear.js';
  import mapCacheDelete from './_mapCacheDelete.js';
  import mapCacheGet from './_mapCacheGet.js';
  import mapCacheHas from './_mapCacheHas.js';
  import mapCacheSet from './_mapCacheSet.js';

  /**
   * Creates a map cache object to store key-value pairs.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */
  function MapCache(entries) {
    var index = -1,
        length = entries == null ? 0 : entries.length;

    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }

  // Add methods to `MapCache`.
  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype['delete'] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;

  export default MapCache;
});
//# sourceMappingURL=_MapCache.js.map