Liferay.Loader.define("frontend-image-editor-web@4.0.20/BrightnessComponent.es", ['module', 'exports', 'require', 'frontend-js-web', './BrightnessSlider.es', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './BrightnessComponent.soy', './BrightnessControls.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  require("./BrightnessSlider.es");

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _BrightnessComponent = _interopRequireDefault(require("./BrightnessComponent.soy"));

  require("./BrightnessControls.soy");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Brightness component.
   */
  var BrightnessComponent = /*#__PURE__*/function (_Component) {
    _inherits(BrightnessComponent, _Component);

    function BrightnessComponent() {
      _classCallCheck(this, BrightnessComponent);

      return _possibleConstructorReturn(this, _getPrototypeOf(BrightnessComponent).apply(this, arguments));
    }

    _createClass(BrightnessComponent, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.requestImageEditorPreview_ = (0, _frontendJsWeb.debounce)(this.requestImageEditorPreview, 50);
        this.cache_ = {};
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        this.cache_ = {};
      }
      /**
       * Applies a brightness filter to the image.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {Promise} A promise that resolves when the webworker
       * finishes processing the image.
       */

    }, {
      key: "preview",
      value: function preview(imageData) {
        return this.process(imageData);
      }
      /**
       * Applies a brightness filter to the image.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {Promise} A promise that resolves when the webworker
       * finishes processing the image.
       */

    }, {
      key: "process",
      value: function process(imageData) {
        var brightnessValue = this.components.slider.value;
        var promise = this.cache_[brightnessValue];

        if (!promise) {
          promise = this.spawnWorker_({
            brightnessValue: brightnessValue,
            imageData: imageData
          });
          this.cache_[brightnessValue] = promise;
        }

        return promise;
      }
      /**
       * Notifies the editor that this component wants to generate
       * a different preview version of the current image. It debounces
       * the calls.
       */

    }, {
      key: "requestPreview",
      value: function requestPreview() {
        this.requestImageEditorPreview_();
      }
      /**
       * Spawns a webworker to process the image in a different thread.
       *
       * @param  {Object} message The image and brightness value.
       * @return {Promise} A promise that resolves when the webworker
       * finishes processing the image.
       */

    }, {
      key: "spawnWorker_",
      value: function spawnWorker_(message) {
        var _this = this;

        return new Promise(function (resolve) {
          var workerURI = _this.modulePath + '/BrightnessWorker.js';
          var processWorker = new Worker(workerURI);

          processWorker.onmessage = function (event) {
            return resolve(event.data);
          };

          processWorker.postMessage(message);
        });
      }
    }]);

    return BrightnessComponent;
  }(_metalComponent["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  BrightnessComponent.STATE = {
    /**
     * Path of this module.
     *
     * @type {String}
     */
    modulePath: {
      validator: _metal.core.isString
    },

    /**
     * Injected method that notifies the editor that the component wants to
     * generate a preview version of the image.
     *
     * @type {Function}
     */
    requestImageEditorPreview: {
      validator: _metal.core.isFunction
    }
  };

  _metalSoy["default"].register(BrightnessComponent, _BrightnessComponent["default"]);

  var _default = BrightnessComponent;
  exports["default"] = _default;
  //# sourceMappingURL=BrightnessComponent.es.js.map
});
//# sourceMappingURL=BrightnessComponent.es.js.map