/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.web.internal.portlet.action;

import com.liferay.frontend.image.editor.capability.ImageEditorCapability;
import com.liferay.frontend.image.editor.web.internal.portlet.tracker.ImageEditorCapabilityTracker;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_image_editor_web_portlet_ImageEditorPortlet", "mvc.command.name=/", "mvc.command.name=/image_editor/view"}, service={MVCRenderCommand.class})
public class ViewMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private ImageEditorCapabilityTracker _imageEditorCapabilityTracker;
    @Reference
    private Portal _portal;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) {
        Template template = this._getTemplate(renderRequest);
        template.put((Object)"imageEditorCapabilities", (Object)HashMapBuilder.put((Object)"tools", this._getImageEditorToolsContexts(renderRequest)).build());
        String entityURL = ParamUtil.getString((PortletRequest)renderRequest, (String)"entityURL");
        template.put((Object)"image", (Object)entityURL);
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        template.put((Object)"pathThemeImages", (Object)themeDisplay.getPathThemeImages());
        String eventName = ParamUtil.getString((PortletRequest)renderRequest, (String)"eventName");
        template.put((Object)"saveEventName", (Object)eventName);
        String saveFileEntryId = ParamUtil.getString((PortletRequest)renderRequest, (String)"saveFileEntryId");
        template.put((Object)"saveFileEntryId", (Object)saveFileEntryId);
        String saveFileName = ParamUtil.getString((PortletRequest)renderRequest, (String)"saveFileName");
        template.put((Object)"saveFileName", (Object)saveFileName);
        String saveMimeType = ParamUtil.getString((PortletRequest)renderRequest, (String)"saveMimeType");
        template.put((Object)"saveMimeType", (Object)saveMimeType);
        String saveParamName = ParamUtil.getString((PortletRequest)renderRequest, (String)"saveParamName");
        template.put((Object)"saveParamName", (Object)saveParamName);
        String saveURL = ParamUtil.getString((PortletRequest)renderRequest, (String)"saveURL");
        template.put((Object)"saveURL", (Object)saveURL);
        return "ImageEditor";
    }

    private Map<String, List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor>> _getImageEditorCapabilityDescriptorsList(List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor> imageEditorCapabilityDescriptors) {
        HashMap<String, List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor>> imageEditorCapabilityDescriptorsMap = new HashMap<String, List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor>>();
        for (ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor : imageEditorCapabilityDescriptors) {
            Map<String, Object> properties = imageEditorCapabilityDescriptor.getProperties();
            String category = GetterUtil.getString((Object)properties.get("com.liferay.frontend.image.editor.capability.category"));
            List curImageEditorCapabilityDescriptors = imageEditorCapabilityDescriptorsMap.computeIfAbsent(category, key -> new ArrayList());
            curImageEditorCapabilityDescriptors.add(imageEditorCapabilityDescriptor);
        }
        return imageEditorCapabilityDescriptorsMap;
    }

    private List<Map<String, Object>> _getImageEditorToolsContexts(RenderRequest renderRequest) {
        ArrayList<Map<String, Object>> imageEditorToolsContexts = new ArrayList<Map<String, Object>>();
        List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor> toolImageEditorCapabilityDescriptors = this._imageEditorCapabilityTracker.getImageEditorCapabilityDescriptors("tool");
        if (toolImageEditorCapabilityDescriptors == null) {
            return imageEditorToolsContexts;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)renderRequest.getLocale(), this.getClass());
        Map<String, List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor>> imageEditorCapabilityDescriptorsMap = this._getImageEditorCapabilityDescriptorsList(toolImageEditorCapabilityDescriptors);
        for (Map.Entry<String, List<ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor>> entry : imageEditorCapabilityDescriptorsMap.entrySet()) {
            ArrayList<HashMap> controlContexts = new ArrayList<HashMap>();
            String icon = "";
            for (ImageEditorCapabilityTracker.ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor : entry.getValue()) {
                ImageEditorCapability imageEditorCapability = imageEditorCapabilityDescriptor.getImageEditorCapability();
                Map<String, Object> properties = imageEditorCapabilityDescriptor.getProperties();
                HashMap controlContext = HashMapBuilder.put((Object)"label", (Object)imageEditorCapability.getLabel(themeDisplay.getLocale())).put((Object)"modulePath", () -> {
                    ServletContext servletContext = imageEditorCapability.getServletContext();
                    return servletContext.getContextPath();
                }).put((Object)"variant", (Object)GetterUtil.getString((Object)properties.get("com.liferay.frontend.image.editor.capability.controls"))).build();
                imageEditorCapability.prepareContext((Map)controlContext, this._portal.getHttpServletRequest((PortletRequest)renderRequest));
                controlContexts.add(controlContext);
                icon = GetterUtil.getString((Object)properties.get("com.liferay.frontend.image.editor.capability.icon"));
            }
            imageEditorToolsContexts.add(HashMapBuilder.put((Object)"controls", controlContexts).put((Object)"icon", (Object)icon).put((Object)"title", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getKey())).build());
        }
        return imageEditorToolsContexts;
    }

    private Template _getTemplate(RenderRequest renderRequest) {
        return (Template)renderRequest.getAttribute("TEMPLATE");
    }
}

