Liferay.Loader.define("frontend-image-editor-web@2.0.1/ImageEditor.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-dom/src/all/dom', 'metal-promise/src/promise/Promise', 'metal/src/metal', './ImageEditorHistoryEntry.es', './ImageEditorLoading.es', './ImageEditor.soy', 'frontend-js-web/liferay/compat/dropdown/Dropdown.es'], function (exports, _component, _Soy, _dom, _Promise, _metal, _ImageEditorHistoryEntry, _ImageEditorLoading, _ImageEditor) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _dom2 = _interopRequireDefault(_dom);

	var _ImageEditorHistoryEntry2 = _interopRequireDefault(_ImageEditorHistoryEntry);

	var _ImageEditorLoading2 = _interopRequireDefault(_ImageEditorLoading);

	var _ImageEditor2 = _interopRequireDefault(_ImageEditor);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ImageEditor = function (_Component) {
		_inherits(ImageEditor, _Component);

		function ImageEditor() {
			_classCallCheck(this, ImageEditor);

			return _possibleConstructorReturn(this, (ImageEditor.__proto__ || Object.getPrototypeOf(ImageEditor)).apply(this, arguments));
		}

		_createClass(ImageEditor, [{
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				/**
     * This index points to the current state in the history.
     * @protected
     * @review
     * @type {Number}
     */
				this.historyIndex_ = 0;

				/**
     * History of the different image states during edition. Every
     * entry entry represents a change to the image on top of the
     * previous one.
     * - History entries are objects with
     *     - url (optional): the url representing the image
     *     - data: the ImageData object of the image
     * @protected
     * @review
     * @type {Array.<Object>}
     */
				this.history_ = [new _ImageEditorHistoryEntry2.default({
					url: this.image
				})];

				// Polyfill svg usage for lexicon icons
				svg4everybody({
					attributeName: 'data-href',
					polyfill: true
				});

				// Load the first entry imageData and render it on the app.
				this.history_[0].getImageData().then(function (imageData) {
					_metal.async.nextTick(function () {
						_this2.imageEditorReady = true;

						_this2.syncImageData_(imageData);
					});
				});
			}
		}, {
			key: 'accept',
			value: function accept() {
				var _this3 = this;

				var selectedControl = this.components[this.id + '_selected_control_' + this.selectedControl.variant];

				this.history_[this.historyIndex_].getImageData().then(function (imageData) {
					return selectedControl.process(imageData);
				}).then(function (imageData) {
					return _this3.createHistoryEntry_(imageData);
				}).then(function () {
					return _this3.syncHistory_();
				}).then(function () {
					_this3.selectedControl = null;
					_this3.selectedTool = null;
				});
			}
		}, {
			key: 'close_',
			value: function close_() {
				Liferay.Util.getWindow().hide();
			}
		}, {
			key: 'createHistoryEntry_',
			value: function createHistoryEntry_(imageData) {
				// Push new state and discard stale redo states
				this.historyIndex_++;
				this.history_.length = this.historyIndex_ + 1;
				this.history_[this.historyIndex_] = new _ImageEditorHistoryEntry2.default({ data: imageData });

				return _Promise.CancellablePromise.resolve();
			}
		}, {
			key: 'discard',
			value: function discard() {
				this.selectedControl = null;
				this.selectedTool = null;
				this.syncHistory_();
			}
		}, {
			key: 'getImageEditorCanvas',
			value: function getImageEditorCanvas() {
				return this.element.querySelector('.lfr-image-editor-image-container canvas');
			}
		}, {
			key: 'getImageEditorImageBlob',
			value: function getImageEditorImageBlob() {
				var _this4 = this;

				return new _Promise.CancellablePromise(function (resolve, reject) {
					_this4.getImageEditorImageData().then(function (imageData) {
						var canvas = document.createElement('canvas');
						canvas.width = imageData.width;
						canvas.height = imageData.height;

						canvas.getContext('2d').putImageData(imageData, 0, 0);

						if (canvas.toBlob) {
							canvas.toBlob(resolve, _this4.saveMimeType);
						} else {
							var data = atob(canvas.toDataURL(_this4.saveMimeType).split(',')[1]);
							var length = data.length;
							var bytes = new Uint8Array(length);

							for (var i = 0; i < length; i++) {
								bytes[i] = data.charCodeAt(i);
							}

							resolve(new Blob([bytes], { type: _this4.saveMimeType }));
						}
					});
				});
			}
		}, {
			key: 'getImageEditorImageData',
			value: function getImageEditorImageData() {
				return this.history_[this.historyIndex_].getImageData();
			}
		}, {
			key: 'normalizeCanvasMimeType_',
			value: function normalizeCanvasMimeType_(mimeType) {
				return mimeType.replace('jpg', 'jpeg');
			}
		}, {
			key: 'notifySaveResult_',
			value: function notifySaveResult_(result) {
				this.components.loading.show = false;

				if (result && result.success) {
					Liferay.Util.getOpener().Liferay.fire(this.saveEventName, {
						data: result
					});

					Liferay.Util.getWindow().hide();
				} else if (result.error) {
					this.showError_(result.error.message);
				}
			}
		}, {
			key: 'redo',
			value: function redo() {
				this.historyIndex_++;
				this.syncHistory_();
			}
		}, {
			key: 'requestImageEditorEdit',
			value: function requestImageEditorEdit(event) {
				var _this5 = this;

				var controls = this.imageEditorCapabilities.tools.reduce(function (prev, curr) {
					return prev.concat(curr.controls);
				}, []);

				var target = event.delegateTarget || event.currentTarget;
				var targetControl = target.getAttribute('data-control');
				var targetTool = target.getAttribute('data-tool');

				this.syncHistory_().then(function () {
					_this5.selectedControl = controls.filter(function (tool) {
						return tool.variant === targetControl;
					})[0];
					_this5.selectedTool = targetTool;
				});
			}
		}, {
			key: 'requestImageEditorPreview',
			value: function requestImageEditorPreview() {
				var _this6 = this;

				var selectedControl = this.components[this.id + '_selected_control_' + this.selectedControl.variant];

				this.history_[this.historyIndex_].getImageData().then(function (imageData) {
					return selectedControl.preview(imageData);
				}).then(function (imageData) {
					return _this6.syncImageData_(imageData);
				});

				this.components.loading.show = true;
			}
		}, {
			key: 'reset',
			value: function reset() {
				this.historyIndex_ = 0;
				this.history_.length = 1;
				this.syncHistory_();
			}
		}, {
			key: 'save_',
			value: function save_(event) {
				var _this7 = this;

				if (!event.delegateTarget.disabled) {
					this.getImageEditorImageBlob().then(function (imageBlob) {
						return _this7.submitBlob_(imageBlob);
					}).then(function (result) {
						return _this7.notifySaveResult_(result);
					}).catch(function (error) {
						return _this7.showError_(error);
					});
				}
			}
		}, {
			key: 'setterSaveMimeTypeFn_',
			value: function setterSaveMimeTypeFn_(saveMimeType) {
				if (!saveMimeType) {
					var imageExtensionRegex = /(?:.*:\/\/)?(?:[^\/])*[^.]*.([^?\/$]*)/;
					var imageExtension = this.image.match(imageExtensionRegex)[1];

					saveMimeType = this.normalizeCanvasMimeType_('image/' + imageExtension);
				}

				return saveMimeType;
			}
		}, {
			key: 'showError_',
			value: function showError_(message) {
				var _this8 = this;

				this.components.loading.show = false;

				AUI().use('liferay-alert', function () {
					new Liferay.Alert({
						delay: {
							hide: 2000,
							show: 0
						},
						duration: 3000,
						icon: 'exclamation-circle',
						message: message.message,
						type: 'danger'
					}).render(_this8.element);
				});
			}
		}, {
			key: 'submitBlob_',
			value: function submitBlob_(imageBlob) {
				var _this9 = this;

				var saveFileName = this.saveFileName;
				var saveParamName = this.saveParamName;

				var promise = new _Promise.CancellablePromise(function (resolve, reject) {
					var formData = new FormData();

					formData.append(saveParamName, imageBlob, saveFileName);

					var requestConfig = {
						contentType: false,
						data: formData,
						dataType: "json",
						processData: false,
						type: 'POST',
						url: _this9.saveURL
					};

					AUI.$.ajax(requestConfig).done(resolve).fail(function (jqXHR, status, error) {
						return reject(error);
					});
				});

				this.components.loading.show = true;

				return promise;
			}
		}, {
			key: 'syncHistory_',
			value: function syncHistory_() {
				var _this10 = this;

				return new _Promise.CancellablePromise(function (resolve, reject) {
					_this10.history_[_this10.historyIndex_].getImageData().then(function (imageData) {
						_this10.syncImageData_(imageData);

						_this10.history = {
							canRedo: _this10.historyIndex_ < _this10.history_.length - 1,
							canReset: _this10.history_.length > 1,
							canUndo: _this10.historyIndex_ > 0
						};

						resolve();
					});
				});
			}
		}, {
			key: 'syncImageData_',
			value: function syncImageData_(imageData) {
				var width = imageData.width;
				var height = imageData.height;

				var aspectRatio = width / height;

				var offscreenCanvas = document.createElement('canvas');
				offscreenCanvas.width = width;
				offscreenCanvas.height = height;

				var offscreenContext = offscreenCanvas.getContext('2d');
				offscreenContext.clearRect(0, 0, width, height);
				offscreenContext.putImageData(imageData, 0, 0);

				var canvas = this.getImageEditorCanvas();

				var boundingBox = _dom2.default.closest(this.element, '.portlet-layout');
				var availableWidth = boundingBox.offsetWidth;

				var dialogFooterHeight = 0;
				var dialogFooter = this.element.querySelector('.dialog-footer');

				if (dialogFooter) {
					dialogFooterHeight = dialogFooter.offsetHeight;
				}

				var availableHeight = boundingBox.offsetHeight - 142 - 40 - dialogFooterHeight;
				var availableAspectRatio = availableWidth / availableHeight;

				if (availableAspectRatio > 1) {
					canvas.height = availableHeight;
					canvas.width = aspectRatio * availableHeight;
				} else {
					canvas.width = availableWidth;
					canvas.height = availableWidth / aspectRatio;
				}

				var context = canvas.getContext('2d');
				context.clearRect(0, 0, canvas.width, canvas.height);
				context.drawImage(offscreenCanvas, 0, 0, width, height, 0, 0, canvas.width, canvas.height);

				canvas.style.width = canvas.width + 'px';
				canvas.style.height = canvas.height + 'px';

				this.components.loading.show = false;
			}
		}, {
			key: 'undo',
			value: function undo() {
				this.historyIndex_--;
				this.syncHistory_();
			}
		}]);

		return ImageEditor;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */
	ImageEditor.STATE = {
		/**
   * Indicates that the editor is ready for user interaction
   * @review
   * @type {Object}
   */
		imageEditorReady: {
			validator: _metal.core.isBoolean,
			value: false
		},

		/**
   * Event to dispatch when the edition has been completed
   * @review
   * @type {String}
   */
		saveEventName: {
			validator: _metal.core.isString
		},

		/**
   * Name of the saved image that should be sent
   * to the server for the save action
   * @review
   * @type {String}
   */
		saveFileName: {
			validator: _metal.core.isString
		},

		/**
   * Mime type of the saved image. If not explicitly set,
   * the image mime type will be infered from the image url.
   * @review
   * @type {String}
   */
		saveMimeType: {
			setter: 'setterSaveMimeTypeFn_',
			validator: _metal.core.isString
		},

		/**
   * Name of the param where the image should be sent
   * to the server for the save action
   * @review
   * @type {String}
   */
		saveParamName: {
			validator: _metal.core.isString
		},

		/**
   * Url to save the image changes
   * @review
   * @type {String}
   */
		saveURL: {
			validator: _metal.core.isString
		}
	};

	_Soy2.default.register(ImageEditor, _ImageEditor2.default);

	exports.default = ImageEditor;
});
//# sourceMappingURL=ImageEditor.es.js.map
