"use strict";

Liferay.Loader.define("frontend-image-editor-capability-saturation@3.0.4/SaturationComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-web/liferay/compat/slider/Slider.es', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-promise', 'frontend-js-metal-web$metal', './SaturationComponent.soy', './SaturationControls.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _Slider = _interopRequireDefault(require("frontend-js-web/liferay/compat/slider/Slider.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalDebounce = _interopRequireDefault(require("frontend-js-metal-web$metal-debounce"));

  var _metalPromise = require("frontend-js-metal-web$metal-promise");

  var _metal = require("frontend-js-metal-web$metal");

  var _SaturationComponent = _interopRequireDefault(require("./SaturationComponent.soy"));

  var _SaturationControls = _interopRequireDefault(require("./SaturationControls.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Saturation component.
   */
  var SaturationComponent =
  /*#__PURE__*/
  function (_Component) {
    _inherits(SaturationComponent, _Component);

    function SaturationComponent() {
      _classCallCheck(this, SaturationComponent);

      return _possibleConstructorReturn(this, _getPrototypeOf(SaturationComponent).apply(this, arguments));
    }

    _createClass(SaturationComponent, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.requestImageEditorPreview_ = (0, _metalDebounce.default)(this.requestImageEditorPreview, 50);
        this.cache_ = {};
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        this.cache_ = {};
      }
      /**
       * Applies a saturation filter to the image.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {CancellablePromise} A promise that resolves when the webworker
       * finishes processing the image.
       */

    }, {
      key: "preview",
      value: function preview(imageData) {
        return this.process(imageData);
      }
      /**
       * Applies a saturation filter to the image.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {CancellablePromise} A promise that resolves when the webworker
       * finishes processing the image.
       */

    }, {
      key: "process",
      value: function process(imageData) {
        var saturationValue = this.components.slider.value;
        var promise = this.cache_[saturationValue];

        if (!promise) {
          promise = this.spawnWorker_({
            saturationValue: saturationValue,
            imageData: imageData
          });
          this.cache_[saturationValue] = promise;
        }

        return promise;
      }
      /**
       * Notifies the editor that this component wants to generate a different
       * preview version of the current image. It debounces the calls.
       */

    }, {
      key: "requestPreview",
      value: function requestPreview() {
        this.requestImageEditorPreview_();
      }
      /**
       * Spawns a webworker to process the image in a different thread.
       *
       * @param  {Object} message The image and saturation value.
       * @return {CancellablePromise} A promise that resolves when the webworker
       * finishes processing the image.
       */

    }, {
      key: "spawnWorker_",
      value: function spawnWorker_(message) {
        var _this = this;

        return new _metalPromise.CancellablePromise(function (resolve, reject) {
          var workerURI = _this.modulePath + '/SaturationWorker.js';
          var processWorker = new Worker(workerURI);

          processWorker.onmessage = function (event) {
            return resolve(event.data);
          };

          processWorker.postMessage(message);
        });
      }
    }]);

    return SaturationComponent;
  }(_metalComponent.default);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  SaturationComponent.STATE = {
    /**
     * Path of this module.
     *
     * @type {String}
     */
    modulePath: {
      validator: _metal.core.isString
    },

    /**
     * Injected method that notifies the editor that this component wants to
     * generate a preview version of the image.
     *
     * @type {Function}
     */
    requestImageEditorPreview: {
      validator: _metal.core.isFunction
    }
  };

  _metalSoy.default.register(SaturationComponent, _SaturationComponent.default);

  var _default = SaturationComponent;
  exports.default = _default;
  //# sourceMappingURL=SaturationComponent.es.js.map
});
//# sourceMappingURL=SaturationComponent.es.js.map