Liferay.Loader.define("frontend-image-editor-capability-saturation@2.0.4/SaturationComponent.es", ['exports', 'metal-component/src/all/component', 'frontend-js-web/liferay/compat/slider/Slider.es', 'metal-soy/src/Soy', 'metal-debounce/src/debounce', 'metal-promise/src/promise/Promise', 'metal/src/metal', './SaturationComponent.soy', './SaturationControls.soy'], function (exports, _component, _Slider, _Soy, _debounce, _Promise, _metal, _SaturationComponent, _SaturationControls) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _component2 = _interopRequireDefault(_component);

	var _Slider2 = _interopRequireDefault(_Slider);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _debounce2 = _interopRequireDefault(_debounce);

	var _SaturationComponent2 = _interopRequireDefault(_SaturationComponent);

	var _SaturationControls2 = _interopRequireDefault(_SaturationControls);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var SaturationComponent = function (_Component) {
		_inherits(SaturationComponent, _Component);

		function SaturationComponent() {
			_classCallCheck(this, SaturationComponent);

			return _possibleConstructorReturn(this, (SaturationComponent.__proto__ || Object.getPrototypeOf(SaturationComponent)).apply(this, arguments));
		}

		_createClass(SaturationComponent, [{
			key: 'attached',
			value: function attached() {
				// Debounced version of requestImageEditorPreview
				this.requestImageEditorPreview_ = (0, _debounce2.default)(this.requestImageEditorPreview, 50);

				this.cache_ = {};
			}
		}, {
			key: 'detached',
			value: function detached() {
				this.cache_ = {};
			}
		}, {
			key: 'preview',
			value: function preview(imageData) {
				return this.process(imageData);
			}
		}, {
			key: 'process',
			value: function process(imageData) {
				var saturationValue = this.components.slider.value;
				var promise = this.cache_[saturationValue];

				if (!promise) {
					promise = this.spawnWorker_({
						saturationValue: saturationValue,
						imageData: imageData
					});

					this.cache_[saturationValue] = promise;
				}

				return promise;
			}
		}, {
			key: 'requestPreview',
			value: function requestPreview() {
				this.requestImageEditorPreview_();
			}
		}, {
			key: 'spawnWorker_',
			value: function spawnWorker_(message) {
				var _this2 = this;

				return new _Promise.CancellablePromise(function (resolve, reject) {
					var workerURI = _this2.modulePath + '/SaturationWorker.js';
					var processWorker = new Worker(workerURI);

					processWorker.onmessage = function (event) {
						return resolve(event.data);
					};
					processWorker.postMessage(message);
				});
			}
		}]);

		return SaturationComponent;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */
	SaturationComponent.STATE = {
		/**
   * Path of this module
   * @review
   * @type {String}
   */
		modulePath: {
			validator: _metal.core.isString
		},

		/**
   * Injected method to notify the editor this component
   * wants to generate a preview version of the image.
   * @review
   * @type {Function}
   */
		requestImageEditorPreview: {
			validator: _metal.core.isFunction
		}
	};

	_Soy2.default.register(SaturationComponent, _SaturationComponent2.default);

	exports.default = SaturationComponent;
});
//# sourceMappingURL=SaturationComponent.es.js.map
