Liferay.Loader.define("frontend-image-editor-capability-rotate@3.0.22/RotateComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './RotateComponent.soy', './RotateControls.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _RotateComponent = _interopRequireDefault(require("./RotateComponent.soy"));

  require("./RotateControls.soy");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Rotate component.
   */
  var RotateComponent = /*#__PURE__*/function (_Component) {
    _inherits(RotateComponent, _Component);

    function RotateComponent() {
      _classCallCheck(this, RotateComponent);

      return _possibleConstructorReturn(this, _getPrototypeOf(RotateComponent).apply(this, arguments));
    }

    _createClass(RotateComponent, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.cache_ = {};
        this.rotationAngle_ = 0;
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        this.cache_ = {};
      }
      /**
       * Rotates the image to the current selected rotation angle.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {Promise} A promise that resolves when processing is
       * complete.
       */

    }, {
      key: "preview",
      value: function preview(imageData) {
        return this.process(imageData);
      }
      /**
       * Rotates the image to the current selected rotation angle.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {Promise} A promise that resolves when processing is
       * complete.
       */

    }, {
      key: "process",
      value: function process(imageData) {
        var promise = this.cache_[this.rotationAngle_];

        if (!promise) {
          promise = this.rotate_(imageData, this.rotationAngle_);
          this.cache_[this.rotationAngle_] = promise;
        }

        return promise;
      }
      /**
       * Rotates the passed image data to the current rotation angle.
       *
       * @param  {ImageData} imageData The image data to rotate.
       * @param  {number} rotationAngle The normalized rotation angle (in degrees)
       * in the range [0-360).
       * @protected
       * @return {Promise} A promise that resolves when the image is
       * rotated.
       */

    }, {
      key: "rotate_",
      value: function rotate_(imageData, rotationAngle) {
        var cancellablePromise = new Promise(function (resolve) {
          var imageWidth = imageData.width;
          var imageHeight = imageData.height;
          var swapDimensions = rotationAngle / 90 % 2;
          var imageCanvas = document.createElement('canvas');
          imageCanvas.width = imageWidth;
          imageCanvas.height = imageHeight;
          imageCanvas.getContext('2d').putImageData(imageData, 0, 0);
          var offscreenCanvas = document.createElement('canvas');
          offscreenCanvas.width = swapDimensions ? imageHeight : imageWidth;
          offscreenCanvas.height = swapDimensions ? imageWidth : imageHeight;
          var offscreenContext = offscreenCanvas.getContext('2d');
          offscreenContext.save();
          offscreenContext.translate(offscreenCanvas.width / 2, offscreenCanvas.height / 2);
          offscreenContext.rotate(rotationAngle * Math.PI / 180);
          offscreenContext.drawImage(imageCanvas, -imageCanvas.width / 2, -imageCanvas.height / 2);
          offscreenContext.restore();
          resolve(offscreenContext.getImageData(0, 0, offscreenCanvas.width, offscreenCanvas.height));
        });
        return cancellablePromise;
      }
      /**
       * Rotates the image 90º counter-clockwise.
       */

    }, {
      key: "rotateLeft",
      value: function rotateLeft() {
        this.rotationAngle_ = (this.rotationAngle_ - 90) % 360;
        this.requestImageEditorPreview();
      }
      /**
       * Rotates the image 90º clockwise.
       */

    }, {
      key: "rotateRight",
      value: function rotateRight() {
        this.rotationAngle_ = (this.rotationAngle_ + 90) % 360;
        this.requestImageEditorPreview();
      }
    }]);

    return RotateComponent;
  }(_metalComponent["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  RotateComponent.STATE = {
    /**
     * Path of this module.
     *
     * @type {Function}
     */
    modulePath: {
      validator: _metal.core.isString
    },

    /**
     * Injected method that notifies the editor that this component wants to
     * generate a preview version of the image.
     *
     * @type {Function}
     */
    requestImageEditorPreview: {
      validator: _metal.core.isFunction
    }
  };

  _metalSoy["default"].register(RotateComponent, _RotateComponent["default"]);

  var _default = RotateComponent;
  exports["default"] = _default;
  //# sourceMappingURL=RotateComponent.es.js.map
});
//# sourceMappingURL=RotateComponent.es.js.map