"use strict";

Liferay.Loader.define("frontend-image-editor-capability-crop@3.0.5/CropHandles.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal', './CropHandles.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metal = require("frontend-js-metal-web$metal");

  var _CropHandles = _interopRequireDefault(require("./CropHandles.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Crop Handles Component.
   */
  var CropHandles =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CropHandles, _Component);

    function CropHandles() {
      _classCallCheck(this, CropHandles);

      return _possibleConstructorReturn(this, _getPrototypeOf(CropHandles).apply(this, arguments));
    }

    _createClass(CropHandles, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        var _this = this;

        this.parentNode_ = this.element.parentNode;
        this.resizer = this.element.querySelector('.resize-handle');
        this.selectionBorderWidth_ = parseInt(this.element.style.borderWidth, 10);
        this.croppedPreview_ = this.element.querySelector('.cropped-image-preview');
        this.croppedPreviewContext_ = this.croppedPreview_.getContext('2d');

        _metal.async.nextTick(function () {
          var canvas = _this.getImageEditorCanvas();

          _this.setSelectionInitialStyle_();

          _this.initializeDrags_();

          _metalDom.default.removeClasses(_this.element, 'hide');

          _metalDom.default.append(canvas.parentElement, _this.element);
        });
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        var canvas = this.getImageEditorCanvas();
        canvas.style.opacity = 1;
      }
      /**
       * Binds actions for the mover and size handler.
       *
       * @protected
       */

    }, {
      key: "bindDrags_",
      value: function bindDrags_() {
        this.resizer.addEventListener('mousedown', function (event) {
          return event.stopPropagation();
        });
        this.bindSelectionDrag_();
        this.bindSizeDrag_();
      }
      /**
       * Binds actions for the mover.
       *
       * @protected
       */

    }, {
      key: "bindSelectionDrag_",
      value: function bindSelectionDrag_() {
        var _this2 = this;

        var canvas = this.getImageEditorCanvas();
        this.selectionDrag_.on(_metalDragDrop.Drag.Events.DRAG, function (data, event) {
          var left = data.relativeX - canvas.offsetLeft + _this2.selectionBorderWidth_;
          var top = data.relativeY - canvas.offsetTop + _this2.selectionBorderWidth_;
          _this2.element.style.left = left + 'px';
          _this2.element.style.top = top + 'px';

          _this2.croppedPreviewContext_.drawImage(canvas, left, top, _this2.croppedPreview_.width, _this2.croppedPreview_.height, 0, 0, _this2.croppedPreview_.width, _this2.croppedPreview_.height);
        });
      }
      /**
       * Binds actions for the size handler.
       *
       * @protected
       */

    }, {
      key: "bindSizeDrag_",
      value: function bindSizeDrag_() {
        var _this3 = this;

        var canvas = this.getImageEditorCanvas();
        this.sizeDrag_.on(_metalDragDrop.Drag.Events.DRAG, function (data, event) {
          var width = data.relativeX + _this3.resizer.offsetWidth / 2;
          var height = data.relativeY + _this3.resizer.offsetHeight / 2;
          _this3.element.style.width = width + _this3.selectionBorderWidth_ * 2 + 'px';
          _this3.element.style.height = height + _this3.selectionBorderWidth_ * 2 + 'px';
          _this3.croppedPreview_.width = width;
          _this3.croppedPreview_.height = height;

          _this3.croppedPreviewContext_.drawImage(canvas, _this3.element.offsetLeft - canvas.offsetLeft + _this3.selectionBorderWidth_, _this3.element.offsetTop - canvas.offsetTop + _this3.selectionBorderWidth_, width, height, 0, 0, width, height);

          _this3.croppedPreview_.style.width = width + 'px';
          _this3.croppedPreview_.style.height = height + 'px';
        });
      }
      /**
       * Calculates the constrain region for the selection drag and resize.
       *
       * @protected
       */

    }, {
      key: "getSizeDragConstrain_",
      value: function getSizeDragConstrain_(region) {
        var canvas = this.getImageEditorCanvas();

        var constrain = _metalPosition.default.getRegion(canvas);

        var selection = _metalPosition.default.getRegion(this.element);

        constrain.left = selection.left + this.resizer.offsetWidth + this.selectionBorderWidth_ * 2;
        constrain.top = selection.top + this.resizer.offsetHeight + this.selectionBorderWidth_ * 2;
        constrain.width = constrain.right - constrain.left;
        constrain.height = constrain.bottom - constrain.top;
        constrain.right += this.resizer.offsetWidth / 2 - this.selectionBorderWidth_;
        constrain.bottom += this.resizer.offsetHeight / 2 - this.selectionBorderWidth_;

        if (region.left < constrain.left) {
          region.left = constrain.left;
        } else if (region.right > constrain.right) {
          region.left -= region.right - constrain.right;
        }

        if (region.top < constrain.top) {
          region.top = constrain.top;
        } else if (region.bottom > constrain.bottom) {
          region.top -= region.bottom - constrain.bottom;
        }

        region.right = region.left + region.width;
        region.bottom = region.top + region.height;
      }
      /**
       * Initializes the mover and size handler.
       *
       * @protected
       */

    }, {
      key: "initializeDrags_",
      value: function initializeDrags_() {
        var canvas = this.getImageEditorCanvas();
        this.selectionDrag_ = new _metalDragDrop.Drag({
          constrain: canvas,
          handles: this.element,
          sources: this.element
        });
        this.sizeDrag_ = new _metalDragDrop.Drag({
          constrain: this.getSizeDragConstrain_.bind(this),
          handles: this.resizer,
          sources: this.resizer
        });
        this.bindDrags_();
      }
      /**
       * Sets the initial style for the selection and preview.
       *
       * @protected
       */

    }, {
      key: "setSelectionInitialStyle_",
      value: function setSelectionInitialStyle_() {
        var canvas = this.getImageEditorCanvas();
        canvas.style.opacity = 0.5;
        this.element.style.width = canvas.offsetWidth + 'px';
        this.element.style.height = canvas.offsetHeight + 'px';
        this.element.style.left = canvas.offsetLeft + 'px';
        this.element.style.top = canvas.offsetTop + 'px';
        this.croppedPreview_.width = canvas.offsetWidth;
        this.croppedPreview_.height = canvas.offsetHeight;
        this.croppedPreviewContext_.drawImage(canvas, this.selectionBorderWidth_, this.selectionBorderWidth_, canvas.width - this.selectionBorderWidth_ * 2, canvas.height - this.selectionBorderWidth_ * 2, 0, 0, canvas.width - this.selectionBorderWidth_ * 2, canvas.height - this.selectionBorderWidth_ * 2);
        this.croppedPreview_.style.width = this.croppedPreview_.width + 'px';
        this.croppedPreview_.style.height = this.croppedPreview_.height + 'px';
      }
    }]);

    return CropHandles;
  }(_metalComponent.default);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  CropHandles.STATE = {
    /**
     * Injected helper that retrieves the editor canvas element.
     *
     * @type {Function}
     */
    getImageEditorCanvas: {
      validator: _metal.core.isFunction
    }
  };

  _metalSoy.default.register(CropHandles, _CropHandles.default);

  var _default = CropHandles;
  exports.default = _default;
  //# sourceMappingURL=CropHandles.es.js.map
});
//# sourceMappingURL=CropHandles.es.js.map