"use strict";

Liferay.Loader.define("frontend-image-editor-capability-crop@3.0.5/CropComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-promise', 'frontend-js-metal-web$metal', './CropComponent.soy', './CropControls.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalPromise = require("frontend-js-metal-web$metal-promise");

  var _metal = require("frontend-js-metal-web$metal");

  var _CropComponent = _interopRequireDefault(require("./CropComponent.soy"));

  var _CropControls = _interopRequireDefault(require("./CropControls.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Crop component.
   */
  var CropComponent =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CropComponent, _Component);

    function CropComponent() {
      _classCallCheck(this, CropComponent);

      return _possibleConstructorReturn(this, _getPrototypeOf(CropComponent).apply(this, arguments));
    }

    _createClass(CropComponent, [{
      key: "process",

      /**
       * Applies the brightness filter to generate a final version of the image.
       *
       * @param  {Object} imageData The image representations.
       * @return {CancellablePromise} A promise that resolves when the webworker
       * finishes processing the image for preview.
       */
      value: function process(imageData) {
        var imageCanvas = this.getImageEditorCanvas();
        var horizontalRatio = imageData.width / imageCanvas.offsetWidth;
        var verticalRatio = imageData.height / imageCanvas.offsetHeight;
        var cropHandles = this.components[this.ref + 'CropHandles'];
        var selection = {
          height: cropHandles.element.offsetHeight,
          left: cropHandles.element.offsetLeft - imageCanvas.offsetLeft,
          top: cropHandles.element.offsetTop - imageCanvas.offsetTop,
          width: cropHandles.element.offsetWidth
        };
        var rawCanvas = document.createElement('canvas');
        rawCanvas.width = imageData.width;
        rawCanvas.height = imageData.height;
        rawCanvas.getContext('2d').putImageData(imageData, 0, 0);
        var canvas = document.createElement('canvas');
        var normalizedLeft = selection.left * horizontalRatio;
        var normalizedWidth = selection.width * horizontalRatio;
        var normalizedTop = selection.top * verticalRatio;
        var normalizedHeight = selection.height * verticalRatio;
        canvas.width = normalizedWidth;
        canvas.height = normalizedHeight;
        var context = canvas.getContext('2d');
        context.drawImage(rawCanvas, normalizedLeft, normalizedTop, normalizedWidth, normalizedHeight, 0, 0, normalizedWidth, normalizedHeight);
        cropHandles.dispose();
        return _metalPromise.CancellablePromise.resolve(context.getImageData(0, 0, canvas.width, canvas.height));
      }
    }]);

    return CropComponent;
  }(_metalComponent.default);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  CropComponent.STATE = {
    /**
     * Injected helper that retrieves the editor canvas.
     *
     * @type {Function}
     */
    getImageEditorCanvas: {
      validator: _metal.core.isFunction
    }
  };

  _metalSoy.default.register(CropComponent, _CropComponent.default);

  var _default = CropComponent;
  exports.default = _default;
  //# sourceMappingURL=CropComponent.es.js.map
});
//# sourceMappingURL=CropComponent.es.js.map