/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.tinymce.web.internal.editor.configuration;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseTinyMCEEditorConfigContributor
extends BaseEditorConfigContributor {
    private static final String _EXTENDED_VALID_ELEMENTS = StringBundler.concat((String[])new String[]{"a[name|href|target|title|onclick],img[class|src|border=0", "|alt|title|hspace|vspace|width|height|align|onmouseover", "|onmouseout|name|usemap],hr[class|width|size|noshade],", "font[face|size|color|style],span[class|align|style]"});
    private static final Map<String, String> _tinyMCELanguages = new HashMap<String, String>(){
        {
            this.put("ar_SA", "ar");
            this.put("bg_BG", "bg_BG");
            this.put("ca_ES", "ca");
            this.put("cs_CZ", "cs");
            this.put("de_DE", "de");
            this.put("el_GR", "el");
            this.put("en_AU", "en_GB");
            this.put("en_GB", "en_GB");
            this.put("en_US", "en_GB");
            this.put("es_ES", "es");
            this.put("et_EE", "et");
            this.put("eu_ES", "eu");
            this.put("fa_IR", "fa");
            this.put("fi_FI", "fi");
            this.put("fr_FR", "fr_FR");
            this.put("gl_ES", "gl");
            this.put("hr_HR", "hr");
            this.put("hu_HU", "hu_HU");
            this.put("in_ID", "id");
            this.put("it_IT", "it");
            this.put("iw_IL", "he_IL");
            this.put("ja_JP", "ja");
            this.put("ko_KR", "ko_KR");
            this.put("lt_LT", "lt");
            this.put("nb_NO", "nb_NO");
            this.put("nl_NL", "nl");
            this.put("pl_PL", "pl");
            this.put("pt_BR", "pt_BR");
            this.put("pt_PT", "pt_PT");
            this.put("ro_RO", "ro");
            this.put("ru_RU", "ru");
            this.put("sk_SK", "sk");
            this.put("sl_SI", "sl_SI");
            this.put("sr_RS", "sr");
            this.put("sv_SE", "sv_SE");
            this.put("tr_TR", "tr_TR");
            this.put("uk_UA", "uk");
            this.put("vi_VN", "vi");
            this.put("zh_CN", "zh_CN");
            this.put("zh_TW", "zh_TW");
        }
    };

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        StringBundler sb = new StringBundler(3);
        sb.append(HtmlUtil.escape((String)PortalUtil.getStaticResourceURL((HttpServletRequest)themeDisplay.getRequest(), (String)(themeDisplay.getPathThemeCss() + "/clay.css"))));
        sb.append(",");
        sb.append(HtmlUtil.escape((String)PortalUtil.getStaticResourceURL((HttpServletRequest)themeDisplay.getRequest(), (String)(themeDisplay.getPathThemeCss() + "/main.css"))));
        jsonObject.put("content_css", sb.toString()).put("convert_urls", (Object)Boolean.FALSE).put("extended_valid_elements", _EXTENDED_VALID_ELEMENTS);
        ItemSelector itemSelector = this.getItemSelector();
        String filebrowserImageBrowseUrl = jsonObject.getString("filebrowserImageBrowseUrl");
        String itemSelectedEventName = itemSelector.getItemSelectedEventName(filebrowserImageBrowseUrl);
        List itemSelectorCriteria = itemSelector.getItemSelectorCriteria(filebrowserImageBrowseUrl);
        ImageItemSelectorCriterion itemSelectorCriterion = new ImageItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        itemSelectorCriteria.add(itemSelectorCriterion);
        PortletURL itemSelectorURL = itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, itemSelectedEventName, itemSelectorCriteria.toArray(new ItemSelectorCriterion[0]));
        jsonObject.put("filebrowserImageBrowseUrl", itemSelectorURL.toString()).put("invalid_elements", "script");
        String contentsLanguageId = (String)inputEditorTaglibAttributes.get("liferay-ui:input-editor:contentsLanguageId");
        jsonObject.put("language", this.getTinyMCELanguage(contentsLanguageId)).put("menubar", (Object)Boolean.FALSE).put("mode", "textareas").put("relative_urls", (Object)Boolean.FALSE).put("remove_script_host", (Object)Boolean.FALSE);
        String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
        String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        jsonObject.put("selector", "#" + namespace + name).put("toolbar", "bold italic underline | alignleft aligncenter alignright | preview print").put("toolbar_items_size", "small");
    }

    protected abstract ItemSelector getItemSelector();

    protected String getTinyMCELanguage(String contentsLanguageId) {
        Locale contentsLocale = LocaleUtil.fromLanguageId((String)contentsLanguageId);
        String tinyMCELanguage = _tinyMCELanguages.get(contentsLanguageId = LocaleUtil.toLanguageId((Locale)contentsLocale));
        if (Validator.isNull((String)tinyMCELanguage)) {
            tinyMCELanguage = _tinyMCELanguages.get("en_US");
        }
        return tinyMCELanguage;
    }

    protected boolean isShowSource(Map<String, Object> inputEditorTaglibAttributes) {
        return GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:showSource"));
    }
}

