/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.tinymce.web.internal.editor.configuration;

import com.liferay.frontend.editor.tinymce.web.internal.editor.configuration.BaseTinyMCEEditorConfigContributor;
import com.liferay.item.selector.ItemSelector;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.TextFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=tinymce"}, service={EditorConfigContributor.class})
public class TinyMCEEditorConfigContributor
extends BaseTinyMCEEditorConfigContributor {
    @Reference
    private BrowserSniffer _browserSniffer;
    @Reference
    private ItemSelector _itemSelector;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("mode", "exact");
        jsonObject.put("plugins", this.getPluginsJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("style_formats", this.getStyleFormatsJSONArray(themeDisplay.getLocale()));
        jsonObject.put("toolbar", this.getToolbarJSONArray(inputEditorTaglibAttributes, themeDisplay));
    }

    @Override
    protected ItemSelector getItemSelector() {
        return this._itemSelector;
    }

    protected JSONArray getPluginsJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put("advlist autolink autosave link image lists charmap print preview hr anchor");
        jsonArray.put("searchreplace wordcount fullscreen media");
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put("code");
        }
        jsonArray.put("table contextmenu emoticons textcolor paste fullpage textcolor colorpicker textpattern");
        return jsonArray;
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String type, String element, String cssClasses) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        styleJSONObject.put(type, element);
        styleJSONObject.put("classes", cssClasses);
        styleJSONObject.put("title", styleFormatName);
        return styleJSONObject;
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "inline", "p", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "block", "h1", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "block", "h2", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "block", "h3", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "block", "h4", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"preformatted-text"), "block", "pre", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "inline", "cite", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "inline", "code", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"info-message"), "block", "div", "portlet-msg-info"));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"alert-message"), "block", "div", "portlet-msg-alert"));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"error-message"), "block", "div", "portlet-msg-error"));
        return jsonArray;
    }

    protected JSONArray getToolbarJSONArray(Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay) {
        JSONArray toolbarJSONArray;
        JSONObject toolbarsJSONObject = this.getToolbarsJSONObject(inputEditorTaglibAttributes);
        String toolbarSet = (String)inputEditorTaglibAttributes.get("liferay-ui:input-editor:toolbarSet");
        String currentToolbarSet = TextFormatter.format((String)HtmlUtil.escapeJS((String)toolbarSet), (int)12);
        if (this._browserSniffer.isMobile(themeDisplay.getRequest())) {
            currentToolbarSet = "phone";
        }
        if ((toolbarJSONArray = toolbarsJSONObject.getJSONArray(currentToolbarSet)) == null) {
            toolbarJSONArray = toolbarsJSONObject.getJSONArray("liferay");
        }
        return toolbarJSONArray;
    }

    protected JSONArray getToolbarsEmailJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put("fontselect fontsizeselect | forecolor backcolor | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify");
        String buttons = "cut copy paste bullist numlist | blockquote | undo redo | link unlink image ";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + "code ";
        }
        buttons = buttons + "| hr removeformat | preview print fullscreen";
        jsonArray.put(buttons);
        return jsonArray;
    }

    protected JSONObject getToolbarsJSONObject(Map<String, Object> inputEditorTaglibAttributes) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("email", this.getToolbarsEmailJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("liferay", this.getToolbarsLiferayJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("phone", this.getToolbarsPhoneJSONArray());
        jsonObject.put("simple", this.getToolbarsSimpleJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("tablet", this.getToolbarsTabletJSONArray(inputEditorTaglibAttributes));
        return jsonObject;
    }

    protected JSONArray getToolbarsLiferayJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put("styleselect fontselect fontsizeselect | forecolor backcolor | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify");
        String buttons = "cut copy paste searchreplace bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media ";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + "code";
        }
        jsonArray.put(buttons);
        jsonArray.put("table | hr removeformat | subscript superscript | charmap emoticons | preview print fullscreen");
        return jsonArray;
    }

    protected JSONArray getToolbarsPhoneJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put("bold italic underline | bullist numlist");
        jsonArray.put("link unlink image");
        return jsonArray;
    }

    protected JSONArray getToolbarsSimpleJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        String buttons = "bold italic underline strikethrough | bullist numlist | table | link unlink image";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + " code";
        }
        jsonArray.put(buttons);
        return jsonArray;
    }

    protected JSONArray getToolbarsTabletJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put("styleselect fontselect fontsizeselect | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify");
        String buttons = "bullist numlist | link unlink image";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + " code";
        }
        jsonArray.put(buttons);
        return jsonArray;
    }
}

