Liferay.Loader.define("frontend-editor-ckeditor-web@4.0.8/editor/ClassicEditor", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$react', './Editor'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Editor = require("./Editor");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var getToolbarSet = function getToolbarSet(toolbarSet) {
    if ((0, _frontendJsWeb.isPhone)()) {
      toolbarSet = 'phone';
    } else if ((0, _frontendJsWeb.isTablet)()) {
      toolbarSet = 'tablet';
    }

    return toolbarSet;
  };

  var ClassicEditor = function ClassicEditor(_ref) {
    var contents = _ref.contents,
        cssClass = _ref.cssClass,
        editorConfig = _ref.editorConfig,
        initialToolbarSet = _ref.initialToolbarSet,
        name = _ref.name;
    var editorRef = (0, _react.useRef)();

    var _useState = (0, _react.useState)(),
        _useState2 = _slicedToArray(_useState, 2),
        toolbarSet = _useState2[0],
        setToolbarSet = _useState2[1];

    var config = (0, _react.useMemo)(function () {
      return _objectSpread({
        toolbar: toolbarSet
      }, editorConfig);
    }, [editorConfig, toolbarSet]);
    (0, _react.useEffect)(function () {
      setToolbarSet(getToolbarSet(initialToolbarSet));
    }, [initialToolbarSet]);
    return _react["default"].createElement("div", {
      className: cssClass,
      id: "".concat(name, "Container")
    }, _react["default"].createElement(_Editor.Editor, {
      className: "lfr-editable",
      config: config,
      data: contents,
      id: name,
      onBeforeLoad: function onBeforeLoad(CKEDITOR) {
        CKEDITOR.disableAutoInline = true;
        CKEDITOR.dtd.$removeEmpty.i = 0;
        CKEDITOR.dtd.$removeEmpty.span = 0;
      },
      ref: editorRef
    }));
  };

  var _default = ClassicEditor;
  exports["default"] = _default;
  //# sourceMappingURL=ClassicEditor.js.map
});
//# sourceMappingURL=ClassicEditor.js.map