Liferay.Loader.define("frontend-editor-ckeditor-web@4.0.24/editor/ClassicEditor", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './Editor'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.ClassicEditor = void 0;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Editor = require("./Editor");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var ClassicEditor = function ClassicEditor(_ref) {
      var _ref$contents = _ref.contents,
          contents = _ref$contents === void 0 ? '' : _ref$contents,
          editorConfig = _ref.editorConfig,
          _ref$initialToolbarSe = _ref.initialToolbarSet,
          initialToolbarSet = _ref$initialToolbarSe === void 0 ? 'simple' : _ref$initialToolbarSe,
          name = _ref.name,
          onChange = _ref.onChange,
          onChangeMethodName = _ref.onChangeMethodName,
          title = _ref.title,
          otherProps = _objectWithoutProperties(_ref, ["contents", "editorConfig", "initialToolbarSet", "name", "onChange", "onChangeMethodName", "title"]);

      var editorRef = (0, _react.useRef)();

      var _useState = (0, _react.useState)(initialToolbarSet),
          _useState2 = _slicedToArray(_useState, 2),
          toolbarSet = _useState2[0],
          setToolbarSet = _useState2[1];

      var getHTML = (0, _react.useCallback)(function () {
        var data = contents;
        var editor = editorRef.current.editor;

        if (editor && editor.instanceReady) {
          data = editor.getData();

          if (CKEDITOR.env.gecko && CKEDITOR.tools.trim(data) === '<br />') {
            data = '';
          }
        }

        return data;
      }, [contents]);

      (0, _react.useEffect)(function () {
        setToolbarSet(initialToolbarSet);
      }, [initialToolbarSet]);
      (0, _react.useEffect)(function () {
        window[name] = {
          getHTML: getHTML,
          getText: function getText() {
            return contents;
          }
        };
      }, [contents, getHTML, name]);
      var onResize = (0, _frontendJsWeb.debounce)(function () {
        setToolbarSet(initialToolbarSet);
      }, 200);
      (0, _frontendJsReactWeb.useEventListener)('resize', onResize, true, window);
      return _react["default"].createElement("div", {
        id: "".concat(name, "Container")
      }, title && _react["default"].createElement("label", {
        className: "control-label",
        htmlFor: name
      }, title), _react["default"].createElement(_Editor.Editor, _extends({
        className: "lfr-editable",
        config: function getConfig() {
          return _objectSpread({
            toolbar: toolbarSet
          }, editorConfig);
        }(),
        onBeforeLoad: function onBeforeLoad(CKEDITOR) {
          CKEDITOR.disableAutoInline = true;
          CKEDITOR.dtd.$removeEmpty.i = 0;
          CKEDITOR.dtd.$removeEmpty.span = 0;

          CKEDITOR.getNextZIndex = function () {
            return CKEDITOR.dialog._.currentZIndex ? CKEDITOR.dialog._.currentZIndex + 10 : Liferay.zIndex.WINDOW + 10;
          };

          CKEDITOR.on('instanceCreated', function (_ref2) {
            var editor = _ref2.editor;
            editor.name = name;
            editor.on('drop', function (event) {
              var data = event.data.dataTransfer.getData('text/html');

              if (data) {
                var fragment = CKEDITOR.htmlParser.fragment.fromHtml(data);
                var name = fragment.children[0].name;

                if (name) {
                  return editor.pasteFilter.check(name);
                }
              }
            });
            editor.on('instanceReady', function () {
              editor.setData(contents);
            });
          });
        },
        onChange: function onChangeCallback() {
          if (!onChangeMethodName && !onChange) {
            return;
          }

          var editor = editorRef.current.editor;

          if (editor.checkDirty()) {
            if (onChangeMethodName) {
              window[onChangeMethodName](getHTML());
            } else {
              onChange(getHTML());
            }

            editor.resetDirty();
          }
        },
        ref: editorRef
      }, otherProps)));
    };

    exports.ClassicEditor = ClassicEditor;
    var _default = ClassicEditor;
    exports["default"] = _default;
    //# sourceMappingURL=ClassicEditor.js.map
  }
});
//# sourceMappingURL=ClassicEditor.js.map