/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.ckeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.ckeditor.web.internal.editor.configuration.BaseCKEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=ckeditor"}, service={EditorConfigContributor.class})
public class CKEditorConfigContributor
extends BaseCKEditorConfigContributor {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("autoParagraph", (Object)Boolean.FALSE);
        jsonObject.put("autoSaveTimeout", 3000);
        ColorScheme colorScheme = themeDisplay.getColorScheme();
        String cssClasses = (String)inputEditorTaglibAttributes.get("liferay-ui:input-editor:cssClasses");
        jsonObject.put("bodyClass", StringBundler.concat((String[])new String[]{"html-editor ", HtmlUtil.escape((String)colorScheme.getCssClass()), " ", HtmlUtil.escape((String)cssClasses)}));
        jsonObject.put("closeNoticeTimeout", 8000);
        jsonObject.put("entities", (Object)Boolean.FALSE);
        String extraPlugins = "a11yhelpbtn,itemselector,lfrpopup,media";
        boolean inlineEdit = GetterUtil.getBoolean((String)((String)inputEditorTaglibAttributes.get("liferay-ui:input-editor:inlineEdit")));
        if (inlineEdit) {
            extraPlugins = extraPlugins + ",ajaxsave,restore";
        }
        jsonObject.put("extraPlugins", extraPlugins);
        jsonObject.put("filebrowserWindowFeatures", "title=" + LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"browse"));
        jsonObject.put("pasteFromWordRemoveFontStyles", (Object)Boolean.FALSE);
        jsonObject.put("pasteFromWordRemoveStyles", (Object)Boolean.FALSE);
        jsonObject.put("stylesSet", this.getStyleFormatsJSONArray(themeDisplay.getLocale()));
        jsonObject.put("toolbar_editInPlace", this.getToolbarEditInPlaceJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_email", this.getToolbarEmailJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_liferay", this.getToolbarLiferayJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_liferayArticle", this.getToolbarLiferayArticleJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_phone", this.getToolbarPhoneJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_simple", this.getToolbarSimpleJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_tablet", this.getToolbarTabletJSONArray(inputEditorTaglibAttributes));
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, String cssClass) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            JSONObject attributesJSONObject = JSONFactoryUtil.createJSONObject();
            attributesJSONObject.put("class", cssClass);
            styleJSONObject.put("attributes", attributesJSONObject);
        }
        styleJSONObject.put("element", element);
        styleJSONObject.put("name", styleFormatName);
        return styleJSONObject;
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "p", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "h1", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "h2", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "h3", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "h4", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"preformatted-text"), "pre", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "cite", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "code", null));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"info-message"), "div", "portlet-msg-info"));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"alert-message"), "div", "portlet-msg-alert"));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"error-message"), "div", "portlet-msg-error"));
        return jsonArray;
    }

    protected JSONArray getToolbarEditInPlaceJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike', '-', 'Subscript', 'Superscript', '-', 'RemoveFormat']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent']"));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Styles']"));
        jsonArray.put(this.toJSONArray("['SpellChecker', 'Scayt', '-', 'SpecialChar']"));
        jsonArray.put(this.toJSONArray("['Undo', 'Redo']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        jsonArray.put(this.toJSONArray("['A11YBtn']"));
        return jsonArray;
    }

    protected JSONArray getToolbarEmailJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike', '-', 'RemoveFormat']"));
        jsonArray.put(this.toJSONArray("['TextColor', 'BGColor']"));
        jsonArray.put(this.toJSONArray("['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']"));
        jsonArray.put(this.toJSONArray("['FontSize']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['ImageSelector']"));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Cut', 'Copy', 'Paste', '-', 'PasteText', 'PasteFromWord', '-', 'SelectAll', '-', 'Undo', 'Redo' ]"));
        jsonArray.put(this.toJSONArray("['SpellChecker', 'Scayt']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        jsonArray.put(this.toJSONArray("['A11YBtn']"));
        return jsonArray;
    }

    protected JSONArray getToolbarLiferayArticleJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike', '-', 'Subscript', 'Superscript', '-', 'RemoveFormat']"));
        jsonArray.put(this.toJSONArray("['TextColor', 'BGColor']"));
        jsonArray.put(this.toJSONArray("['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList', '-' ,'Outdent', 'Indent', '-', 'Blockquote']"));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Styles', 'FontSize']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink', 'Anchor']"));
        String buttons = "['Table', '-', 'ImageSelector',";
        if (XugglerUtil.isEnabled()) {
            buttons = buttons + " 'AudioSelector', 'VideoSelector',";
        }
        buttons = buttons + " 'Flash', '-', 'LiferayPageBreak', '-', 'Smiley', 'SpecialChar']";
        jsonArray.put(this.toJSONArray(buttons));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Cut', 'Copy', 'Paste', '-', 'PasteText', 'PasteFromWord', '-', 'SelectAll' , '-', 'Undo', 'Redo']"));
        jsonArray.put(this.toJSONArray("['Find', 'Replace', '-', 'SpellChecker', 'Scayt']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        jsonArray.put(this.toJSONArray("['A11YBtn']"));
        return jsonArray;
    }

    protected JSONArray getToolbarLiferayJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike', '-', 'Subscript', 'Superscript', '-', 'RemoveFormat']"));
        jsonArray.put(this.toJSONArray("['TextColor', 'BGColor']"));
        jsonArray.put(this.toJSONArray("['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent']"));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Styles', 'FontSize']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink', 'Anchor']"));
        String buttons = "['Table', '-', 'ImageSelector',";
        if (XugglerUtil.isEnabled()) {
            buttons = buttons.concat(" 'AudioSelector', 'VideoSelector',");
        }
        buttons = buttons.concat(" 'Flash', '-', 'Smiley', 'SpecialChar']");
        jsonArray.put(this.toJSONArray(buttons));
        jsonArray.put("/");
        boolean inlineEdit = GetterUtil.getBoolean((String)((String)inputEditorTaglibAttributes.get("liferay-ui:input-editor:inlineEdit")));
        if (inlineEdit) {
            jsonArray.put(this.toJSONArray("['AjaxSave', '-', 'Restore']"));
        }
        jsonArray.put(this.toJSONArray("['Cut', 'Copy', 'Paste', '-', 'PasteText', 'PasteFromWord', '-', 'SelectAll' , '-', 'Undo', 'Redo']"));
        jsonArray.put(this.toJSONArray("['Find', 'Replace', '-', 'SpellChecker', 'Scayt']"));
        if (!inlineEdit && this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        jsonArray.put(this.toJSONArray("['A11YBtn']"));
        return jsonArray;
    }

    protected JSONArray getToolbarPhoneJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['ImageSelector']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        return jsonArray;
    }

    protected JSONArray getToolbarSimpleJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['Table', 'ImageSelector']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        return jsonArray;
    }

    protected JSONArray getToolbarTabletJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike']"));
        jsonArray.put(this.toJSONArray("['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList']"));
        jsonArray.put(this.toJSONArray("['Styles', 'FontSize']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['ImageSelector']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        return jsonArray;
    }
}

