/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration.BaseAlloyEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=alloyeditor"}, service={EditorConfigContributor.class})
public class AlloyEditorConfigContributor
extends BaseAlloyEditorConfigContributor {
    private static final int _CKEDITOR_STYLE_BLOCK = 1;
    private static final int _CKEDITOR_STYLE_INLINE = 2;
    private ResourceBundleLoader _aggregateResourceBundleLoader;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("entities", (Object)Boolean.FALSE);
        String extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = Validator.isNotNull((String)extraPlugins) ? extraPlugins + ",itemselector,media,embedurl" : "itemselector,media,embedurl";
        jsonObject.put("extraPlugins", extraPlugins).put("toolbars", this.getToolbarsJSONObject(themeDisplay.getLocale()));
    }

    @Activate
    protected void activate() {
        this._aggregateResourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{this._resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, String cssClass, int type) {
        return JSONUtil.put((String)"name", (Object)styleFormatName).put("style", this.getStyleJSONObject(element, cssClass, type));
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._aggregateResourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        return JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "p", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "h1", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "h2", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "h3", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "h4", null, 1), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"preformatted-text"), "pre", null, 1), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "cite", null, 2), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "code", null, 2), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"info-message"), "div", "portlet-msg-info", 1), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"alert-message"), "div", "portlet-msg-alert", 1), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"error-message"), "div", "portlet-msg-error", 1)});
    }

    protected JSONObject getStyleFormatsJSONObject(Locale locale) {
        JSONObject stylesJSONObject = JSONUtil.put((String)"styles", (Object)this.getStyleFormatsJSONArray(locale));
        return JSONUtil.put((String)"cfg", (Object)stylesJSONObject).put("name", "styles");
    }

    protected JSONObject getStyleJSONObject(String element, String cssClass, int type) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            JSONObject attributesJSONObject = JSONUtil.put((String)"class", (Object)cssClass);
            styleJSONObject.put("attributes", attributesJSONObject);
        }
        styleJSONObject.put("element", element).put("type", type);
        return styleJSONObject;
    }

    protected JSONObject getToolbarsAddJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['image', 'embedVideo', 'table', 'hline']")).put("tabIndex", 2);
    }

    protected JSONObject getToolbarsJSONObject(Locale locale) {
        return JSONUtil.put((String)"add", (Object)this.getToolbarsAddJSONObject()).put("styles", this.getToolbarsStylesJSONObject(locale));
    }

    protected JSONObject getToolbarsStylesJSONObject(Locale locale) {
        return JSONUtil.put((String)"selections", (Object)this.getToolbarsStylesSelectionsJSONArray(locale)).put("tabIndex", 1);
    }

    protected JSONObject getToolbarsStylesSelectionsEmbedURLJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['imageLeft', 'imageCenter', 'imageRight']")).put("name", "embedurl").put("test", "AlloyEditor.SelectionTest.embedUrl");
    }

    protected JSONObject getToolbarsStylesSelectionsImageJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['imageLeft', 'imageCenter', 'imageRight', 'linkBrowse', 'imageAlt']")).put("name", "image").put("setPosition", "AlloyEditor.SelectionSetPosition.image").put("test", "AlloyEditor.SelectionTest.image");
    }

    protected JSONArray getToolbarsStylesSelectionsJSONArray(Locale locale) {
        return JSONUtil.putAll((Object[])new Object[]{this.getToolbarsStylesSelectionsEmbedURLJSONObject(), this.getToolbarsStylesSelectionsLinkJSONObject(), this.getToolbarsStylesSelectionsImageJSONObject(), this.getToolbarsStylesSelectionsTextJSONObject(locale), this.getToolbarsStylesSelectionsTableJSONObject()});
    }

    protected JSONObject getToolbarsStylesSelectionsLinkJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['linkEditBrowse']")).put("name", "link").put("test", "AlloyEditor.SelectionTest.link");
    }

    protected JSONObject getToolbarsStylesSelectionsTableJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['tableHeading', 'tableRow', 'tableColumn', 'tableCell', 'tableRemove']")).put("getArrowBoxClasses", "AlloyEditor.SelectionGetArrowBoxClasses.table").put("name", "table").put("setPosition", "AlloyEditor.SelectionSetPosition.table").put("test", "AlloyEditor.SelectionTest.table");
    }

    protected JSONObject getToolbarsStylesSelectionsTextJSONObject(Locale locale) {
        return JSONUtil.put((String)"buttons", (Object)JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatsJSONObject(locale), "bold", "italic", "underline", "ol", "ul", "linkBrowse"})).put("name", "text").put("test", "AlloyEditor.SelectionTest.text");
    }
}

