/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration.BaseAlloyEditorConfigContributor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=alloyeditor_creole"}, service={EditorConfigContributor.class})
public class AlloyEditorCreoleConfigContributor
extends BaseAlloyEditorConfigContributor {
    private static final int _CKEDITOR_STYLE_BLOCK = 1;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        String attachmentURLPrefix;
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("allowedContent", "b strong i hr h1 h2 h3 h4 h5 h6 em ul ol li pre table tr th; img a[*]");
        Map fileBrowserParams = (Map)inputEditorTaglibAttributes.get("liferay-ui:input-editor:fileBrowserParams");
        if (fileBrowserParams != null && Validator.isNotNull((String)(attachmentURLPrefix = (String)fileBrowserParams.get("attachmentURLPrefix")))) {
            jsonObject.put("attachmentURLPrefix", attachmentURLPrefix);
        }
        JSONObject buttonCfgJSONObject = JSONFactoryUtil.createJSONObject();
        JSONObject linkEditJSONObject = JSONFactoryUtil.createJSONObject();
        linkEditJSONObject.put("appendProtocol", false);
        linkEditJSONObject.put("showTargetSelector", false);
        buttonCfgJSONObject.put("linkEditBrowse", linkEditJSONObject);
        jsonObject.put("buttonCfg", buttonCfgJSONObject);
        jsonObject.put("decodeLinks", (Object)Boolean.TRUE);
        jsonObject.put("disableObjectResizing", (Object)Boolean.TRUE);
        String extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = extraPlugins.concat(",creole,itemselector,media");
        jsonObject.put("extraPlugins", extraPlugins);
        jsonObject.put("format_tags", "p;h1;h2;h3;h4;h5;h6;pre");
        String removePlugins = jsonObject.getString("removePlugins");
        StringBundler sb = new StringBundler(4);
        sb.append("ae_dragresize,ae_tableresize,bidi,div,flash,font,forms,");
        sb.append("indentblock,justify,keystrokes,maximize,newpage,pagebreak,");
        sb.append("preview,print,save,showblocks,smiley,stylescombo,");
        sb.append("templates,video");
        jsonObject.put("removePlugins", removePlugins.concat(",").concat(sb.toString()));
        jsonObject.put("toolbars", this.getToolbarsJSONObject(themeDisplay.getLocale()));
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, int type) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("name", styleFormatName);
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        styleJSONObject.put("element", element);
        styleJSONObject.put("type", type);
        jsonObject.put("style", styleJSONObject);
        return jsonObject;
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "p", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "h1", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "h2", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "h3", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "h4", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"5"), "h5", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"6"), "h6", 1));
        return jsonArray;
    }

    protected JSONObject getStyleFormatsJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
        stylesJSONObject.put("styles", this.getStyleFormatsJSONArray(locale));
        jsonObject.put("cfg", stylesJSONObject);
        jsonObject.put("name", "styles");
        return jsonObject;
    }

    protected JSONObject getToolbarsAddJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray buttonsJSONArray = JSONFactoryUtil.createJSONArray();
        buttonsJSONArray.put("image");
        JSONObject buttonJSONObject = JSONFactoryUtil.createJSONObject();
        JSONObject cfgJSONObject = JSONFactoryUtil.createJSONObject();
        cfgJSONObject.put("tableAttributes", JSONFactoryUtil.createJSONObject());
        buttonJSONObject.put("cfg", cfgJSONObject);
        buttonJSONObject.put("name", "table");
        buttonsJSONArray.put(buttonJSONObject);
        buttonsJSONArray.put("hline");
        jsonObject.put("buttons", buttonsJSONArray);
        jsonObject.put("tabIndex", 2);
        return jsonObject;
    }

    protected JSONObject getToolbarsJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("add", this.getToolbarsAddJSONObject());
        jsonObject.put("styles", this.getToolbarsStylesJSONObject(locale));
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("selections", this.getToolbarsStylesSelectionsJSONArray(locale));
        jsonObject.put("tabIndex", 1);
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsHeadingTextJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getStyleFormatsJSONObject(locale));
        jsonObject.put("buttons", jsonArray);
        jsonObject.put("name", "headertext");
        jsonObject.put("test", "AlloyEditor.SelectionTest.headingtext");
        return jsonObject;
    }

    protected JSONArray getToolbarsStylesSelectionsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getToolbarsStylesSelectionsHeadingTextJSONObject(locale));
        jsonArray.put(this.getToolbarsStylesSelectionsLinkJSONObject());
        jsonArray.put(this.getToolbarsStylesSelectionsTextJSONObject(locale));
        jsonArray.put(this.getToolbarsStylesSelectionsTableJSONObject());
        return jsonArray;
    }

    protected JSONObject getToolbarsStylesSelectionsLinkJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray linkButtonsJSONArray = JSONFactoryUtil.createJSONArray();
        JSONObject linkEditJSONObject = JSONFactoryUtil.createJSONObject();
        JSONObject cfgJSONObject = JSONFactoryUtil.createJSONObject();
        cfgJSONObject.put("appendProtocol", false);
        cfgJSONObject.put("showTargetSelector", false);
        linkEditJSONObject.put("cfg", cfgJSONObject);
        linkEditJSONObject.put("name", "linkEditBrowse");
        linkButtonsJSONArray.put(linkEditJSONObject);
        jsonObject.put("buttons", linkButtonsJSONArray);
        jsonObject.put("name", "link");
        jsonObject.put("test", "AlloyEditor.SelectionTest.link");
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsTableJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['tableHeading', 'tableRow', 'tableColumn', 'tableCell', 'tableRemove']"));
        jsonObject.put("getArrowBoxClasses", "AlloyEditor.SelectionGetArrowBoxClasses.table");
        jsonObject.put("name", "table");
        jsonObject.put("setPosition", "AlloyEditor.SelectionSetPosition.table");
        jsonObject.put("test", "AlloyEditor.SelectionTest.table");
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsTextJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getStyleFormatsJSONObject(locale));
        jsonArray.put("bold");
        jsonArray.put("italic");
        jsonArray.put("ul");
        jsonArray.put("ol");
        jsonArray.put("linkBrowse");
        jsonArray.put("removeFormat");
        jsonObject.put("buttons", jsonArray);
        jsonObject.put("name", "text");
        jsonObject.put("test", "AlloyEditor.SelectionTest.text");
        return jsonObject;
    }
}

