/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration.BaseAlloyEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=alloyeditor"}, service={EditorConfigContributor.class})
public class AlloyEditorConfigContributor
extends BaseAlloyEditorConfigContributor {
    private static final int _CKEDITOR_STYLE_BLOCK = 1;
    private static final int _CKEDITOR_STYLE_INLINE = 2;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("entities", (Object)Boolean.FALSE);
        String extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = Validator.isNotNull((String)extraPlugins) ? extraPlugins + ",itemselector,media,embedurl" : "itemselector,media,embedurl";
        jsonObject.put("extraPlugins", extraPlugins);
        jsonObject.put("toolbars", this.getToolbarsJSONObject(themeDisplay.getLocale()));
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, String cssClass, int type) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("name", styleFormatName);
        jsonObject.put("style", this.getStyleJSONObject(element, cssClass, type));
        return jsonObject;
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "p", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "h1", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "h2", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "h3", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "h4", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"preformatted-text"), "pre", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "cite", null, 2));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "code", null, 2));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"info-message"), "div", "portlet-msg-info", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"alert-message"), "div", "portlet-msg-alert", 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"error-message"), "div", "portlet-msg-error", 1));
        return jsonArray;
    }

    protected JSONObject getStyleFormatsJSONObject(Locale locale) {
        JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
        stylesJSONObject.put("styles", this.getStyleFormatsJSONArray(locale));
        JSONObject styleFormatsJSONObject = JSONFactoryUtil.createJSONObject();
        styleFormatsJSONObject.put("cfg", stylesJSONObject);
        styleFormatsJSONObject.put("name", "styles");
        return styleFormatsJSONObject;
    }

    protected JSONObject getStyleJSONObject(String element, String cssClass, int type) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            JSONObject attributesJSONObject = JSONFactoryUtil.createJSONObject();
            attributesJSONObject.put("class", cssClass);
            styleJSONObject.put("attributes", attributesJSONObject);
        }
        styleJSONObject.put("element", element);
        styleJSONObject.put("type", type);
        return styleJSONObject;
    }

    protected JSONObject getToolbarsAddJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['image', 'embedVideo', 'table', 'hline']"));
        jsonObject.put("tabIndex", 2);
        return jsonObject;
    }

    protected JSONObject getToolbarsJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("add", this.getToolbarsAddJSONObject());
        jsonObject.put("styles", this.getToolbarsStylesJSONObject(locale));
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("selections", this.getToolbarsStylesSelectionsJSONArray(locale));
        jsonObject.put("tabIndex", 1);
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsEmbedURLJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['imageLeft', 'imageCenter', 'imageRight']"));
        jsonObject.put("name", "embedurl");
        jsonObject.put("test", "AlloyEditor.SelectionTest.embedurl");
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsImageJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['imageLeft', 'imageCenter', 'imageRight', 'linkBrowse']"));
        jsonObject.put("name", "image");
        jsonObject.put("setPosition", "AlloyEditor.SelectionSetPosition.image");
        jsonObject.put("test", "AlloyEditor.SelectionTest.image");
        return jsonObject;
    }

    protected JSONArray getToolbarsStylesSelectionsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getToolbarsStylesSelectionsEmbedURLJSONObject());
        jsonArray.put(this.getToolbarsStylesSelectionsLinkJSONObject());
        jsonArray.put(this.getToolbarsStylesSelectionsImageJSONObject());
        jsonArray.put(this.getToolbarsStylesSelectionsTextJSONObject(locale));
        jsonArray.put(this.getToolbarsStylesSelectionsTableJSONObject());
        return jsonArray;
    }

    protected JSONObject getToolbarsStylesSelectionsLinkJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['linkEditBrowse']"));
        jsonObject.put("name", "link");
        jsonObject.put("test", "AlloyEditor.SelectionTest.link");
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsTableJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['tableHeading', 'tableRow', 'tableColumn', 'tableCell', 'tableRemove']"));
        jsonObject.put("getArrowBoxClasses", "AlloyEditor.SelectionGetArrowBoxClasses.table");
        jsonObject.put("name", "table");
        jsonObject.put("setPosition", "AlloyEditor.SelectionSetPosition.table");
        jsonObject.put("test", "AlloyEditor.SelectionTest.table");
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsTextJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getStyleFormatsJSONObject(locale));
        jsonArray.put("bold");
        jsonArray.put("italic");
        jsonArray.put("underline");
        jsonArray.put("ol");
        jsonArray.put("ul");
        jsonArray.put("linkBrowse");
        jsonObject.put("buttons", jsonArray);
        jsonObject.put("name", "text");
        jsonObject.put("test", "AlloyEditor.SelectionTest.text");
        return jsonObject;
    }
}

