/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration.BaseAlloyEditorConfigContributor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=alloyeditor_bbcode"}, service={EditorConfigContributor.class})
public class AlloyEditorBBCodeConfigContributor
extends BaseAlloyEditorConfigContributor {
    private static final int _CKEDITOR_STYLE_BLOCK = 1;
    private static final int _CKEDITOR_STYLE_INLINE = 2;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("allowedContent", (Object)Boolean.TRUE);
        jsonObject.put("enterMode", 1);
        String extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = extraPlugins.concat(",bbcode,itemselector");
        jsonObject.put("extraPlugins", extraPlugins);
        jsonObject.put("forceEnterMode", (Object)Boolean.TRUE);
        jsonObject.put("format_tags", "p;pre");
        jsonObject.put("lang", this.getLangJSONObject(inputEditorTaglibAttributes));
        jsonObject.put("newThreadURL", "${newThreadURL}");
        String removePlugins = jsonObject.getString("removePlugins");
        StringBundler sb = new StringBundler(3);
        sb.append("bidi,div,flash,font,forms,indentblock,keystrokes,maximize,");
        sb.append("newpage,pagebreak,preview,print,save,showblocks,smiley,");
        sb.append("stylescombo,templates,video");
        jsonObject.put("removePlugins", removePlugins.concat(",").concat(sb.toString()));
        jsonObject.put("smiley_images", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonFiles()));
        jsonObject.put("smiley_path", HtmlUtil.escape((String)themeDisplay.getPathThemeImages()) + "/emoticons/");
        jsonObject.put("smiley_symbols", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonSymbols()));
        jsonObject.put("toolbars", this.getToolbarsJSONObject(themeDisplay.getLocale()));
    }

    protected JSONObject getLangJSONObject(Map<String, Object> inputEditorTaglibAttributes) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("code", LanguageUtil.get((Locale)this.getContentsLocale(inputEditorTaglibAttributes), (String)"code"));
        return jsonObject;
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, String cssClass, int type) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("name", styleFormatName);
        jsonObject.put("style", this.getStyleJSONObject(element, cssClass, type));
        return jsonObject;
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "p", null, 1));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "cite", null, 2));
        jsonArray.put(this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "code", null, 2));
        return jsonArray;
    }

    protected JSONObject getStyleFormatsJSONObject(Locale locale) {
        JSONObject styleFormatsJSONObject = JSONFactoryUtil.createJSONObject();
        JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
        stylesJSONObject.put("styles", this.getStyleFormatsJSONArray(locale));
        styleFormatsJSONObject.put("cfg", stylesJSONObject);
        styleFormatsJSONObject.put("name", "styles");
        return styleFormatsJSONObject;
    }

    protected JSONObject getStyleJSONObject(String element, String cssClass, int type) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            JSONObject attributesJSONObject = JSONFactoryUtil.createJSONObject();
            attributesJSONObject.put("class", cssClass);
            styleJSONObject.put("attributes", attributesJSONObject);
        }
        styleJSONObject.put("element", element);
        styleJSONObject.put("type", type);
        return styleJSONObject;
    }

    protected JSONObject getToolbarsAddJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray buttonsJSONArray = JSONFactoryUtil.createJSONArray();
        buttonsJSONArray.put("image");
        jsonObject.put("buttons", buttonsJSONArray);
        jsonObject.put("tabIndex", 2);
        return jsonObject;
    }

    protected JSONObject getToolbarsJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("add", this.getToolbarsAddJSONObject());
        jsonObject.put("styles", this.getToolbarsStylesJSONObject(locale));
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("selections", this.getToolbarsStylesSelectionsJSONArray(locale));
        jsonObject.put("tabIndex", 1);
        return jsonObject;
    }

    protected JSONArray getToolbarsStylesSelectionsJSONArray(Locale locale) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getToolbarsStylesSelectionsLinkJSONObject());
        jsonArray.put(this.getToolbarsStylesSelectionsTextJSONObject(locale));
        return jsonArray;
    }

    protected JSONObject getToolbarsStylesSelectionsLinkJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("buttons", this.toJSONArray("['linkEditBrowse']"));
        jsonObject.put("name", "link");
        jsonObject.put("test", "AlloyEditor.SelectionTest.link");
        return jsonObject;
    }

    protected JSONObject getToolbarsStylesSelectionsTextJSONObject(Locale locale) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.getStyleFormatsJSONObject(locale));
        jsonArray.put("bold");
        jsonArray.put("italic");
        jsonArray.put("underline");
        jsonArray.put("ol");
        jsonArray.put("ul");
        jsonArray.put("linkBrowse");
        jsonArray.put("quote");
        jsonObject.put("buttons", jsonArray);
        jsonObject.put("name", "text");
        jsonObject.put("test", "AlloyEditor.SelectionTest.text");
        return jsonObject;
    }
}

