/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.view;

import com.liferay.frontend.data.set.view.FDSView;
import com.liferay.frontend.data.set.view.FDSViewContextContributor;
import com.liferay.frontend.data.set.view.FDSViewContextContributorRegistry;
import com.liferay.frontend.data.set.view.FDSViewRegistry;
import com.liferay.frontend.data.set.view.FDSViewSerializer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FDSViewSerializer.class})
public class FDSViewSerializerImpl
implements FDSViewSerializer {
    @Reference
    private FDSViewContextContributorRegistry _fdsViewContextContributorRegistry;
    @Reference
    private FDSViewRegistry _fdsViewRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public JSONArray serialize(String fdsName, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        List fdsViews = this._fdsViewRegistry.getFDSViews(fdsName);
        for (FDSView fdsView : fdsViews) {
            JSONObject jsonObject = JSONUtil.put((String)"contentRenderer", (Object)fdsView.getContentRenderer()).put("contentRendererModuleURL", fdsView.getContentRendererModuleURL()).put("default", fdsView.isDefault()).put("label", this._language.get(ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass()), fdsView.getLabel())).put("name", fdsView.getName()).put("thumbnail", fdsView.getThumbnail());
            List fdsViewContextContributors = this._fdsViewContextContributorRegistry.getFDSViewContextContributors(fdsView.getContentRenderer());
            for (FDSViewContextContributor fdsViewContextContributor : fdsViewContextContributors) {
                Map fdsViewContext = fdsViewContextContributor.getFDSViewContext(fdsView, locale);
                if (fdsViewContext == null) continue;
                for (Map.Entry fdsViewContextEntry : fdsViewContext.entrySet()) {
                    jsonObject.put((String)fdsViewContextEntry.getKey(), fdsViewContextEntry.getValue());
                }
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }
}

