/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.provider;

import com.liferay.frontend.data.set.provider.FDSActionProvider;
import com.liferay.frontend.data.set.provider.FDSActionProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={FDSActionProviderRegistry.class})
public class FDSActionProviderRegistryImpl
implements FDSActionProviderRegistry {
    private static final Log _log = LogFactoryUtil.getLog(FDSActionProviderRegistryImpl.class);
    private ServiceTrackerMap<String, List<ServiceTrackerCustomizerFactory.ServiceWrapper<FDSActionProvider>>> _serviceTrackerMap;

    public List<FDSActionProvider> getFDSActionProviders(String fdsActionProviderKey) {
        List fdsActionProviderServiceWrappers = (List)this._serviceTrackerMap.getService((Object)fdsActionProviderKey);
        if (fdsActionProviderServiceWrappers == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No frontend data set action provider is associated with " + fdsActionProviderKey));
            }
            return Collections.emptyList();
        }
        ArrayList<FDSActionProvider> fdsActionProviders = new ArrayList<FDSActionProvider>();
        for (ServiceTrackerCustomizerFactory.ServiceWrapper tableActionProviderServiceWrapper : fdsActionProviderServiceWrappers) {
            fdsActionProviders.add((FDSActionProvider)tableActionProviderServiceWrapper.getService());
        }
        return fdsActionProviders;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, FDSActionProvider.class, (String)"fds.data.provider.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

