/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.filter;

import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.frontend.data.set.filter.FDSFilterContextContributor;
import com.liferay.frontend.data.set.filter.FDSFilterContextContributorRegistry;
import com.liferay.frontend.data.set.filter.FDSFilterRegistry;
import com.liferay.frontend.data.set.filter.FDSFilterSerializer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FDSFilterSerializer.class})
public class FDSFilterSerializerImpl
implements FDSFilterSerializer {
    @Reference
    private FDSFilterContextContributorRegistry _fdsFilterContextContributorRegistry;
    @Reference
    private FDSFilterRegistry _fdsFilterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public JSONArray serialize(String fdsDisplayName, List<FDSFilter> fdsFilters, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        this._serialize(fdsFilters, jsonArray, locale);
        this._serialize(this._fdsFilterRegistry.getFDSFilters(fdsDisplayName), jsonArray, locale);
        return jsonArray;
    }

    private void _serialize(List<FDSFilter> fdsFilters, JSONArray jsonArray, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        for (FDSFilter fdsFilter : fdsFilters) {
            JSONObject jsonObject = JSONUtil.put((String)"entityFieldType", (Object)fdsFilter.getEntityFieldType()).put("id", fdsFilter.getId()).put("label", this._language.get(resourceBundle, fdsFilter.getLabel())).put("preloadedData", (Object)fdsFilter.getPreloadedData()).put("type", fdsFilter.getType());
            List fdsFilterContextContributors = this._fdsFilterContextContributorRegistry.getFDSFilterContextContributors(fdsFilter.getType());
            for (FDSFilterContextContributor fdsFilterContextContributor : fdsFilterContextContributors) {
                Map fdsFilterContext = fdsFilterContextContributor.getFDSFilterContext(fdsFilter, locale);
                if (fdsFilterContext == null) continue;
                for (Map.Entry entry : fdsFilterContext.entrySet()) {
                    jsonObject.put((String)entry.getKey(), entry.getValue());
                }
            }
            jsonArray.put(jsonObject);
        }
    }
}

