/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.renderer.react.internal.renderer;

import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.react.internal.util.FragmentEntryFragmentRendererReactUtil;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.react.renderer.ComponentDescriptor;
import com.liferay.portal.template.react.renderer.ReactRenderer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class FragmentEntryFragmentRendererReact
implements FragmentRenderer {
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private JSONFactory _jsonFactory;
    private JSPackage _jsPackage;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private ReactRenderer _reactRenderer;

    public String getCollectionKey() {
        return "";
    }

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        return fragmentEntryLink.getConfiguration();
    }

    public String getKey() {
        return "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY_REACT";
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        return false;
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            FragmentEntryLink fragmentEntryLink = this._getFragmentEntryLink(fragmentRendererContext);
            JSONObject configurationJSONObject = this._jsonFactory.createJSONObject();
            if (Validator.isNotNull((String)fragmentEntryLink.getConfiguration())) {
                configurationJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), LocaleUtil.getMostRelevantLocale());
            }
            printWriter.write(this._renderFragmentEntry(fragmentEntryLink, fragmentRendererContext.getFragmentElementId(), fragmentRendererContext, HashMapBuilder.put((Object)"configuration", (Object)configurationJSONObject).build(), httpServletRequest));
        }
        catch (PortalException portalException) {
            throw new IOException(portalException);
        }
    }

    @Activate
    protected void activate() {
        this._jsPackage = this._npmResolver.getJSPackage();
    }

    private FragmentEntry _getContributedFragmentEntry(FragmentEntryLink fragmentEntryLink) {
        Map fragmentCollectionContributorEntries = this._fragmentCollectionContributorRegistry.getFragmentEntries();
        return (FragmentEntry)fragmentCollectionContributorEntries.get(fragmentEntryLink.getRendererKey());
    }

    private FragmentEntryLink _getFragmentEntryLink(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        FragmentEntry fragmentEntry = this._getContributedFragmentEntry(fragmentEntryLink);
        if (fragmentEntry != null) {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            fragmentEntryLink.setHtml(fragmentEntry.getHtml());
            fragmentEntryLink.setJs(fragmentEntry.getJs());
            fragmentEntryLink.setType(fragmentEntry.getType());
        }
        return fragmentEntryLink;
    }

    private String _renderFragmentEntry(FragmentEntryLink fragmentEntryLink, String fragmentElementId, FragmentRendererContext fragmentRendererContext, Map<String, Object> data, HttpServletRequest httpServletRequest) throws IOException {
        StringBundler sb = new StringBundler(9);
        sb.append("<div id=\"");
        sb.append(fragmentElementId);
        sb.append("\" >");
        sb.append(fragmentEntryLink.getHtml());
        CharArrayWriter writer = new CharArrayWriter();
        this._reactRenderer.renderReact(new ComponentDescriptor(ModuleNameUtil.getModuleResolvedId((JSPackage)this._jsPackage, (String)FragmentEntryFragmentRendererReactUtil.getModuleName(fragmentEntryLink)), "fragment" + fragmentEntryLink.getFragmentEntryLinkId(), Collections.emptyList(), true), data, httpServletRequest, (Writer)writer);
        sb.append(((Object)writer).toString());
        sb.append("</div>");
        if (Validator.isNotNull((String)fragmentEntryLink.getCss())) {
            if (Objects.equals(fragmentRendererContext.getMode(), "EDIT") || Objects.equals(fragmentRendererContext.getMode(), "INDEX")) {
                sb.append("<style>");
                sb.append(fragmentEntryLink.getCss());
                sb.append("</style>");
            } else {
                String outputKey = fragmentEntryLink.getFragmentEntryId() + "_CSS";
                OutputData outputData = (OutputData)httpServletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
                boolean cssLoaded = false;
                if (outputData != null) {
                    Set outputKeys = outputData.getOutputKeys();
                    cssLoaded = outputKeys.contains(outputKey);
                    StringBundler cssSB = outputData.getDataSB(outputKey, "");
                    if (cssSB != null) {
                        cssLoaded = Objects.equals(cssSB.toString(), fragmentEntryLink.getCss());
                    }
                } else {
                    outputData = new OutputData();
                }
                if (!cssLoaded) {
                    sb.append("<style>");
                    sb.append(fragmentEntryLink.getCss());
                    sb.append("</style>");
                    outputData.addOutputKey(outputKey);
                    outputData.setDataSB(outputKey, "", new StringBundler(fragmentEntryLink.getCss()));
                    httpServletRequest.setAttribute("LIFERAY_SHARED_OUTPUT_DATA", (Object)outputData);
                }
            }
        }
        return sb.toString();
    }
}

