/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.renderer.react.internal.model.listener;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistryUpdate;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class FragmentEntryLinkModelListener
extends BaseModelListener<FragmentEntryLink> {
    private static final List<String> _dependencies = Collections.singletonList("frontend-js-react-web$react");
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    private JSPackage _jsPackage;
    @Reference
    private NPMRegistry _npmRegistry;
    @Reference
    private NPMResolver _npmResolver;

    public void onAfterCreate(FragmentEntryLink fragmentEntryLink) {
        if (!this._isReactFragmentEntry(fragmentEntryLink.getFragmentEntryId())) {
            return;
        }
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        npmRegistryUpdate.registerJSModule(this._jsPackage, this._getModuleName(fragmentEntryLink), _dependencies, this._getJs(fragmentEntryLink), null);
        npmRegistryUpdate.finish();
    }

    public void onAfterRemove(FragmentEntryLink fragmentEntryLink) {
        if (!this._isReactFragmentEntry(fragmentEntryLink.getFragmentEntryId())) {
            return;
        }
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        npmRegistryUpdate.unregisterJSModule(this._jsPackage.getJSModule(this._getModuleName(fragmentEntryLink)));
        npmRegistryUpdate.finish();
    }

    public void onAfterUpdate(FragmentEntryLink fragmentEntryLink) {
        if (!this._isReactFragmentEntry(fragmentEntryLink.getFragmentEntryId())) {
            return;
        }
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        JSModule jsModule = this._jsPackage.getJSModule(this._getModuleName(fragmentEntryLink));
        npmRegistryUpdate.updateJSModule(jsModule, _dependencies, this._getJs(fragmentEntryLink), null);
        npmRegistryUpdate.finish();
    }

    @Activate
    protected void activate() {
        this._jsPackage = this._npmResolver.getJSPackage();
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(2, -1, -1, null);
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            npmRegistryUpdate.registerJSModule(this._jsPackage, this._getModuleName(fragmentEntryLink), _dependencies, this._getJs(fragmentEntryLink), null);
        }
        npmRegistryUpdate.finish();
    }

    @Deactivate
    protected void deactivate() {
        this._jsPackage = this._npmResolver.getJSPackage();
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(2, -1, -1, null);
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            npmRegistryUpdate.unregisterJSModule(this._jsPackage.getJSModule(this._getModuleName(fragmentEntryLink)));
        }
        npmRegistryUpdate.finish();
    }

    private String _getJs(FragmentEntryLink fragmentEntryLink) {
        return StringUtil.replace((String)fragmentEntryLink.getJs(), (String)"'__FRAGMENT_MODULE_NAME__'", (String)StringBundler.concat((String[])new String[]{"'", ModuleNameUtil.getModuleResolvedId((JSPackage)this._jsPackage, (String)this._getModuleName(fragmentEntryLink)), "'"}));
    }

    private String _getModuleName(FragmentEntryLink fragmentEntryLink) {
        return "fragmentEntryLink/" + fragmentEntryLink.getFragmentEntryLinkId();
    }

    private boolean _isReactFragmentEntry(long fragmentEntryId) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryId);
        return fragmentEntry != null && fragmentEntry.getType() == 2;
    }
}

