/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.resources;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.service.FragmentCollectionService;
import com.liferay.fragment.service.FragmentEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=4"}, service={FragmentEntryProcessor.class})
public class ResourcesFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final Pattern _pattern = Pattern.compile("\\[resources:(.+?)\\]");
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FragmentCollectionService _fragmentCollectionService;
    @Reference
    private FragmentEntryService _fragmentEntryService;

    public String processFragmentEntryLinkCSS(FragmentEntryLink fragmentEntryLink, String css, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        return this._processResources(fragmentEntryLink, css);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        return this._processResources(fragmentEntryLink, html);
    }

    public void validateFragmentEntryHTML(String html, String configuration) {
    }

    private String _processResources(FragmentEntryLink fragmentEntryLink, String code) throws PortalException {
        FragmentEntry fragmentEntry = this._fragmentEntryService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry == null) {
            return code;
        }
        FragmentCollection fragmentCollection = this._fragmentCollectionService.fetchFragmentCollection(fragmentEntry.getFragmentCollectionId());
        Matcher matcher = _pattern.matcher(code);
        while (matcher.find()) {
            if (fragmentEntry.getGroupId() <= 0L) continue;
            FileEntry fileEntry = PortletFileRepositoryUtil.fetchPortletFileEntry((long)fragmentEntry.getGroupId(), (long)fragmentCollection.getResourcesFolderId(), (String)matcher.group(1));
            String fileEntryURL = "";
            if (fileEntry != null) {
                fileEntryURL = this._dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
            }
            code = StringUtil.replace((String)code, (String)matcher.group(), (String)fileEntryURL);
        }
        return code;
    }
}

