/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.internal.util;

import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.entry.processor.internal.util.CommaSeparatedInfoCollectionTextFormatter;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.formatter.InfoCollectionTextFormatter;
import com.liferay.info.formatter.InfoTextFormatter;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.search.InfoSearchClassMapperRegistry;
import com.liferay.info.type.Labeled;
import com.liferay.info.type.WebImage;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorHelper.class})
public class FragmentEntryProcessorHelperImpl
implements FragmentEntryProcessorHelper {
    private static final DateFormat _DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yy hh:mm a", LocaleUtil.US);
    private static final InfoCollectionTextFormatter<Object> _INFO_COLLECTION_TEXT_FORMATTER = new CommaSeparatedInfoCollectionTextFormatter();
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryProcessorHelperImpl.class);
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private InfoSearchClassMapperRegistry _infoSearchClassMapperRegistry;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public String getEditableValue(JSONObject jsonObject, Locale locale) {
        String value = jsonObject.getString(this._language.getLanguageId(locale), null);
        if (value != null) {
            return value;
        }
        return jsonObject.getString(this._language.getLanguageId(LocaleUtil.getSiteDefault()), jsonObject.getString("defaultValue"));
    }

    public Object getFieldValue(JSONObject editableValueJSONObject, Map<Long, InfoItemFieldValues> infoDisplaysFieldValues, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (!(this.isMapped(editableValueJSONObject) || this.isMappedCollection(editableValueJSONObject) || this.isMappedDisplayPage(editableValueJSONObject))) {
            return null;
        }
        long classPK = 0L;
        String className = "";
        String fieldName = "";
        Object object = null;
        if (this.isMapped(editableValueJSONObject)) {
            className = this._portal.getClassName(editableValueJSONObject.getLong("classNameId"));
            classPK = editableValueJSONObject.getLong("classPK");
            fieldName = editableValueJSONObject.getString("fieldId");
            ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(classPK);
            if (fragmentEntryProcessorContext.getPreviewClassPK() > 0L) {
                infoItemIdentifier = new ClassPKInfoItemIdentifier(fragmentEntryProcessorContext.getPreviewClassPK());
                if (Validator.isNotNull((String)fragmentEntryProcessorContext.getPreviewVersion())) {
                    infoItemIdentifier.setVersion(fragmentEntryProcessorContext.getPreviewVersion());
                }
            }
            object = this._getInfoItem(className, (InfoItemIdentifier)infoItemIdentifier);
        } else if (this.isMappedCollection(editableValueJSONObject)) {
            Optional infoItemReferenceOptional = fragmentEntryProcessorContext.getContextInfoItemReferenceOptional();
            if (!infoItemReferenceOptional.isPresent()) {
                return null;
            }
            InfoItemReference infoItemReference = (InfoItemReference)infoItemReferenceOptional.get();
            className = infoItemReference.getClassName();
            classPK = infoItemReference.getClassPK();
            fieldName = editableValueJSONObject.getString("collectionFieldId");
            object = this._getInfoItem(infoItemReference);
        } else if (this.isMappedDisplayPage(editableValueJSONObject)) {
            HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
            if (httpServletRequest == null) {
                return null;
            }
            LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = (LayoutDisplayPageObjectProvider)httpServletRequest.getAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER");
            if (layoutDisplayPageObjectProvider == null) {
                return null;
            }
            className = layoutDisplayPageObjectProvider.getClassName();
            classPK = layoutDisplayPageObjectProvider.getClassPK();
            fieldName = editableValueJSONObject.getString("mappedField");
            object = layoutDisplayPageObjectProvider.getDisplayObject();
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler != null && trashHandler.isInTrash(classPK)) {
            return null;
        }
        InfoItemFieldValuesProvider<Object> infoItemFieldValuesProvider = this._getInfoItemFieldValuesProvider(className);
        if (infoItemFieldValuesProvider == null) {
            return null;
        }
        InfoItemFieldValues infoItemFieldValues = infoDisplaysFieldValues.get(classPK);
        if (infoItemFieldValues == null) {
            infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(object);
            infoDisplaysFieldValues.put(classPK, infoItemFieldValues);
        }
        return this._getMappedInfoItemFieldValue(editableValueJSONObject, fieldName, infoItemFieldValuesProvider, fragmentEntryProcessorContext.getLocale(), object);
    }

    public long getFileEntryId(InfoItemReference infoItemReference, String fieldName, Locale locale) {
        return this._getFileEntryId(infoItemReference.getClassName(), this._getInfoItem(infoItemReference), fieldName, locale);
    }

    public long getFileEntryId(long classNameId, long classPK, String fieldName, Locale locale) throws PortalException {
        if (classNameId == 0L) {
            return 0L;
        }
        ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(classPK);
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, this._portal.getClassName(classNameId), infoItemIdentifier.getInfoItemServiceFilter());
        if (infoItemObjectProvider == null) {
            return 0L;
        }
        Object object = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)infoItemIdentifier);
        if (object == null) {
            return 0L;
        }
        return this._getFileEntryId(this._portal.getClassName(classNameId), object, fieldName, locale);
    }

    public long getFileEntryId(String className, long classPK) {
        if (!Objects.equals(className, FileEntry.class.getName())) {
            return 0L;
        }
        return classPK;
    }

    public long getFileEntryId(WebImage webImage) {
        InfoItemReference infoItemReference = webImage.getInfoItemReference();
        if (infoItemReference == null || !Objects.equals(infoItemReference.getClassName(), FileEntry.class.getName())) {
            return 0L;
        }
        InfoItemIdentifier fileEntryInfoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(fileEntryInfoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return 0L;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)fileEntryInfoItemIdentifier;
        return classPKInfoItemIdentifier.getClassPK();
    }

    public boolean isMapped(JSONObject jsonObject) {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        String fieldId = jsonObject.getString("fieldId");
        return classNameId > 0L && classPK > 0L && Validator.isNotNull((String)fieldId);
    }

    public boolean isMappedCollection(JSONObject jsonObject) {
        return jsonObject.has("collectionFieldId");
    }

    public boolean isMappedDisplayPage(JSONObject jsonObject) {
        return jsonObject.has("mappedField");
    }

    private String _getDateValue(JSONObject editableValueJSONObject, Date date, Locale locale) {
        if (editableValueJSONObject == null) {
            return _DEFAULT_DATE_FORMAT.format(date);
        }
        JSONObject configJSONObject = editableValueJSONObject.getJSONObject("config");
        if (configJSONObject == null) {
            return _DEFAULT_DATE_FORMAT.format(date);
        }
        JSONObject dateFormatJSONObject = configJSONObject.getJSONObject("dateFormat");
        if (dateFormatJSONObject == null) {
            return _DEFAULT_DATE_FORMAT.format(date);
        }
        String pattern = dateFormatJSONObject.getString(this._language.getLanguageId(locale), null);
        if (Validator.isNull((String)pattern)) {
            return _DEFAULT_DATE_FORMAT.format(date);
        }
        SimpleDateFormat dateFormatPattern = new SimpleDateFormat(pattern);
        return dateFormatPattern.format(date);
    }

    private long _getFileEntryId(String className, Object displayObject, String fieldName, Locale locale) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
        if (infoItemFieldValuesProvider == null) {
            return 0L;
        }
        InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(displayObject, fieldName);
        Object value = "";
        if (infoFieldValue != null) {
            value = infoFieldValue.getValue(locale);
        }
        if (!(value instanceof WebImage)) {
            return 0L;
        }
        WebImage webImage = (WebImage)value;
        return this.getFileEntryId(webImage);
    }

    private InfoCollectionTextFormatter<Object> _getInfoCollectionTextFormatter(String itemClassName) {
        if (itemClassName.equals(String.class.getName())) {
            return _INFO_COLLECTION_TEXT_FORMATTER;
        }
        InfoCollectionTextFormatter<Object> infoCollectionTextFormatter = (InfoCollectionTextFormatter<Object>)this._infoItemServiceRegistry.getFirstInfoItemService(InfoCollectionTextFormatter.class, itemClassName);
        if (infoCollectionTextFormatter == null) {
            infoCollectionTextFormatter = _INFO_COLLECTION_TEXT_FORMATTER;
        }
        return infoCollectionTextFormatter;
    }

    private Object _getInfoItem(InfoItemReference infoItemReference) {
        if (infoItemReference == null) {
            return null;
        }
        return this._getInfoItem(infoItemReference.getClassName(), infoItemReference.getInfoItemIdentifier());
    }

    private Object _getInfoItem(String className, InfoItemIdentifier infoItemIdentifier) {
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className, infoItemIdentifier.getInfoItemServiceFilter());
        try {
            return infoItemObjectProvider.getInfoItem(infoItemIdentifier);
        }
        catch (NoSuchInfoItemException noSuchInfoItemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchInfoItemException);
            }
            return null;
        }
    }

    private InfoItemFieldValuesProvider<Object> _getInfoItemFieldValuesProvider(String className) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className = this._infoSearchClassMapperRegistry.getClassName(className));
        if (infoItemFieldValuesProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get info item form provider for class " + className));
            }
            return null;
        }
        return infoItemFieldValuesProvider;
    }

    private Object _getMappedInfoItemFieldValue(JSONObject editableValueJSONObject, String fieldName, InfoItemFieldValuesProvider infoItemFieldValuesProvider, Locale locale, Object object) {
        InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(object, fieldName);
        if (infoFieldValue == null) {
            return null;
        }
        Object value = infoFieldValue.getValue(locale);
        if (value == null) {
            return null;
        }
        if (value instanceof WebImage) {
            WebImage webImage = (WebImage)value;
            JSONObject valueJSONObject = webImage.toJSONObject();
            long fileEntryId = this.getFileEntryId(webImage);
            if (fileEntryId != 0L) {
                valueJSONObject.put("fileEntryId", String.valueOf(fileEntryId));
            }
            return valueJSONObject;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return "";
            }
            Iterator iterator = collection.iterator();
            Object firstItem = iterator.next();
            Class<?> firstItemClass = firstItem.getClass();
            InfoCollectionTextFormatter<Object> infoCollectionTextFormatter = this._getInfoCollectionTextFormatter(firstItemClass.getName());
            return infoCollectionTextFormatter.format(collection, locale);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Labeled) {
            Labeled labeledFieldValue = (Labeled)value;
            return labeledFieldValue.getLabel(locale);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return this._getDateValue(editableValueJSONObject, date, locale);
        }
        Class<?> fieldValueClass = value.getClass();
        InfoTextFormatter infoTextFormatter = (InfoTextFormatter)this._infoItemServiceRegistry.getFirstInfoItemService(InfoTextFormatter.class, fieldValueClass.getName());
        if (infoTextFormatter != null) {
            return infoTextFormatter.format(value, locale);
        }
        return value.toString();
    }
}

