/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.internal.util;

import com.liferay.asset.info.display.contributor.util.ContentAccessor;
import com.liferay.asset.info.display.contributor.util.ContentAccessorUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.entry.processor.internal.util.CommaSeparatedInfoCollectionTextFormatter;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.formatter.InfoCollectionTextFormatter;
import com.liferay.info.formatter.InfoTextFormatter;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.type.Labeled;
import com.liferay.info.type.WebImage;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorHelper.class})
public class FragmentEntryProcessorHelperImpl
implements FragmentEntryProcessorHelper {
    private static final InfoCollectionTextFormatter<Object> _INFO_COLLECTION_TEXT_FORMATTER = new CommaSeparatedInfoCollectionTextFormatter();
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryProcessorHelperImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private Portal _portal;

    public String formatMappedValue(Object fieldValue, Locale locale) {
        String formattedFieldValue;
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Collection) {
            Collection collection = (Collection)fieldValue;
            if (collection.isEmpty()) {
                return "";
            }
            Iterator iterator = collection.iterator();
            Object firstItem = iterator.next();
            Class<?> firstItemClass = firstItem.getClass();
            String itemClassName = firstItemClass.getName();
            InfoCollectionTextFormatter<Object> infoCollectionTextFormatter = this._getInfoCollectionTextFormatter(itemClassName);
            formattedFieldValue = infoCollectionTextFormatter.format(collection, locale);
        } else if (fieldValue instanceof String) {
            formattedFieldValue = (String)fieldValue;
        } else if (fieldValue instanceof Labeled) {
            Labeled labeledFieldValue = (Labeled)fieldValue;
            formattedFieldValue = labeledFieldValue.getLabel(locale);
        } else {
            Class<?> fieldValueClass = fieldValue.getClass();
            String itemClassName = fieldValueClass.getName();
            InfoTextFormatter infoTextFormatter = (InfoTextFormatter)this._infoItemServiceTracker.getFirstInfoItemService(InfoTextFormatter.class, itemClassName);
            formattedFieldValue = infoTextFormatter == null ? fieldValue.toString() : infoTextFormatter.format(fieldValue, locale);
        }
        return formattedFieldValue;
    }

    public String getEditableValue(JSONObject jsonObject, Locale locale) {
        return this._getEditableValueByLocale(jsonObject, locale);
    }

    @Deprecated
    public String getEditableValue(JSONObject jsonObject, Locale locale, long[] segmentsExperienceIds) {
        return this._getEditableValueByLocale(jsonObject, locale);
    }

    public Object getMappedCollectionValue(JSONObject jsonObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider;
        if (!this.isMappedCollection(jsonObject)) {
            return JSONFactoryUtil.createJSONObject();
        }
        Optional displayObjectOptional = fragmentEntryProcessorContext.getDisplayObjectOptional();
        if (!displayObjectOptional.isPresent()) {
            return null;
        }
        Object displayObject = displayObjectOptional.get();
        if (!(displayObject instanceof ClassedModel)) {
            return null;
        }
        ClassedModel classedModel = (ClassedModel)displayObject;
        String className = classedModel.getModelClassName();
        if (classedModel instanceof FileEntry) {
            className = FileEntry.class.getName();
        }
        if ((infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className)) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get info item form provider for class " + className));
            }
            return null;
        }
        InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoItemFieldValue(displayObjectOptional.get(), jsonObject.getString("collectionFieldId"));
        if (infoFieldValue == null) {
            return null;
        }
        Object value = infoFieldValue.getValue(fragmentEntryProcessorContext.getLocale());
        if (value instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)infoFieldValue;
            value = contentAccessor.getContent();
        }
        return this.formatMappedValue(value, fragmentEntryProcessorContext.getLocale());
    }

    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String fieldId;
        Object fieldValue;
        Object object;
        if (!this.isMapped(jsonObject) && !this.isAssetDisplayPage(fragmentEntryProcessorContext.getMode())) {
            return JSONFactoryUtil.createJSONObject();
        }
        long classNameId = jsonObject.getLong("classNameId");
        String className = this._portal.getClassName(classNameId);
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        if (infoItemObjectProvider == null) {
            return null;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        long classPK = jsonObject.getLong("classPK");
        if (trashHandler != null && trashHandler.isInTrash(classPK)) {
            return null;
        }
        ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(classPK);
        if (fragmentEntryProcessorContext.getPreviewClassPK() > 0L) {
            infoItemIdentifier = new ClassPKInfoItemIdentifier(fragmentEntryProcessorContext.getPreviewClassPK());
            if (Validator.isNotNull((String)fragmentEntryProcessorContext.getPreviewVersion())) {
                infoItemIdentifier.setVersion(fragmentEntryProcessorContext.getPreviewVersion());
            }
        }
        if ((object = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)infoItemIdentifier)) == null) {
            return null;
        }
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
        if (infoItemFieldValuesProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get info item form provider for class " + className));
            }
            return null;
        }
        Map fieldsValues = infoDisplaysFieldValues.get(classPK);
        if (fieldsValues == null) {
            InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(object);
            fieldsValues = infoItemFieldValues.getMap(fragmentEntryProcessorContext.getLocale());
            infoDisplaysFieldValues.put(classPK, fieldsValues);
        }
        if ((fieldValue = fieldsValues.getOrDefault(fieldId = jsonObject.getString("fieldId"), (Object)"")) == null) {
            return null;
        }
        if (fieldValue instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)fieldValue;
            fieldValue = contentAccessor.getContent();
        }
        if (fieldValue instanceof WebImage) {
            WebImage webImage = (WebImage)fieldValue;
            fieldValue = webImage.toJSONObject();
        } else {
            fieldValue = this.formatMappedValue(fieldValue, fragmentEntryProcessorContext.getLocale());
        }
        return fieldValue;
    }

    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, String mode, Locale locale, long previewClassPK, long previewClassNameId, int previewType) throws PortalException {
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(null, null, mode, locale);
        defaultFragmentEntryProcessorContext.setPreviewClassNameId(previewClassNameId);
        defaultFragmentEntryProcessorContext.setPreviewClassPK(previewClassPK);
        defaultFragmentEntryProcessorContext.setPreviewType(previewType);
        return this.getMappedValue(jsonObject, infoDisplaysFieldValues, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
    }

    public boolean isAssetDisplayPage(String mode) {
        return Objects.equals(mode, "ASSET_DISPLAY_PAGE");
    }

    public boolean isMapped(JSONObject jsonObject) {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        String fieldId = jsonObject.getString("fieldId");
        return classNameId > 0L && classPK > 0L && Validator.isNotNull((String)fieldId);
    }

    public boolean isMappedCollection(JSONObject jsonObject) {
        return jsonObject.has("collectionFieldId");
    }

    public String processTemplate(String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.put((Object)"writer", (Object)unsyncStringWriter);
        template.put((Object)"contentAccessorUtil", (Object)ContentAccessorUtil.getInstance());
        Optional fieldValuesOptional = fragmentEntryProcessorContext.getFieldValuesOptional();
        if (fieldValuesOptional.isPresent() && MapUtil.isNotEmpty((Map)((Map)fieldValuesOptional.get()))) {
            template.putAll((Map)fieldValuesOptional.get());
        }
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    private String _getEditableValueByLocale(JSONObject jsonObject, Locale locale) {
        String value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)locale), null);
        if (value != null) {
            return value;
        }
        value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNull((String)value)) {
            value = jsonObject.getString("defaultValue");
        }
        return value;
    }

    private InfoCollectionTextFormatter<Object> _getInfoCollectionTextFormatter(String itemClassName) {
        if (itemClassName.equals(String.class.getName())) {
            return _INFO_COLLECTION_TEXT_FORMATTER;
        }
        InfoCollectionTextFormatter<Object> infoCollectionTextFormatter = (InfoCollectionTextFormatter<Object>)this._infoItemServiceTracker.getFirstInfoItemService(InfoCollectionTextFormatter.class, itemClassName);
        if (infoCollectionTextFormatter == null) {
            infoCollectionTextFormatter = _INFO_COLLECTION_TEXT_FORMATTER;
        }
        return infoCollectionTextFormatter;
    }
}

