/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=2"}, service={FragmentEntryProcessor.class})
public class EditableFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final String[] _REQUIRED_ATTRIBUTE_NAMES = new String[]{"id", "type"};
    private ServiceTrackerMap<String, EditableElementMapper> _editableElementMapperServiceTrackerMap;
    private ServiceTrackerMap<String, EditableElementParser> _editableElementParserServiceTrackerMap;
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private PortletRegistry _portletRegistry;

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String key : this._editableElementParserServiceTrackerMap.keySet()) {
            StringBundler sb = new StringBundler(2 + 5 * _REQUIRED_ATTRIBUTE_NAMES.length);
            sb.append("<lfr-editable");
            for (String attributeName : _REQUIRED_ATTRIBUTE_NAMES) {
                sb.append(" ");
                sb.append(attributeName);
                sb.append("=\"");
                String value = "";
                if (attributeName.equals("type")) {
                    value = key;
                }
                sb.append(value);
                sb.append("\"");
            }
            sb.append("></lfr-editable>");
            jsonArray.put(JSONUtil.put((String)"content", (Object)sb.toString()).put("name", "lfr-editable:" + key));
        }
        return jsonArray;
    }

    public JSONArray getDataAttributesJSONArray() {
        JSONArray jsonArray = JSONUtil.put((Object)"lfr-editable-id");
        for (String key : this._editableElementParserServiceTrackerMap.keySet()) {
            jsonArray.put("lfr-editable-type:" + key);
        }
        return jsonArray;
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return this._getDefaultEditableValuesJSONObject(html);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
        if (jsonObject.length() == 0) {
            Class<?> clazz = this.getClass();
            jsonObject.put(clazz.getName(), this.getDefaultEditableValuesJSONObject(html, fragmentEntryLink.getConfiguration()));
        }
        Document document = this._getDocument(html);
        HashMap infoDisplaysFieldValues = new HashMap();
        for (Element element : document.select("lfr-editable,*[data-lfr-editable-id]")) {
            EditableElementMapper editableElementMapper;
            EditableElementParser editableElementParser = this._getEditableElementParser(element);
            if (editableElementParser == null) continue;
            String id = EditableFragmentEntryProcessorUtil.getElementId((Element)element);
            Class<?> clazz = this.getClass();
            JSONObject editableValuesJSONObject = jsonObject.getJSONObject(clazz.getName());
            if (editableValuesJSONObject == null || !editableValuesJSONObject.has(id)) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = "";
            JSONObject mappedValueConfigJSONObject = this._jsonFactory.createJSONObject();
            if (this._fragmentEntryProcessorHelper.isMapped(editableValueJSONObject) || this._fragmentEntryProcessorHelper.isMappedCollection(editableValueJSONObject) || this._fragmentEntryProcessorHelper.isMappedDisplayPage(editableValueJSONObject)) {
                Object fieldValue = this._fragmentEntryProcessorHelper.getFieldValue(editableValueJSONObject, infoDisplaysFieldValues, fragmentEntryProcessorContext);
                if (fieldValue != null) {
                    String fieldId = "";
                    fieldId = this._fragmentEntryProcessorHelper.isMappedDisplayPage(editableValueJSONObject) ? editableValueJSONObject.getString("mappedField") : (this._fragmentEntryProcessorHelper.isMapped(editableValueJSONObject) ? editableValueJSONObject.getString("fieldId") : editableValueJSONObject.getString("collectionFieldId"));
                    mappedValueConfigJSONObject = editableElementParser.getFieldTemplateConfigJSONObject(fieldId, fragmentEntryProcessorContext.getLocale(), fieldValue);
                    value = editableElementParser.parseFieldValue(fieldValue);
                } else {
                    value = editableValueJSONObject.getString("defaultValue");
                }
            } else {
                value = this._fragmentEntryProcessorHelper.getEditableValue(editableValueJSONObject, fragmentEntryProcessorContext.getLocale());
            }
            JSONObject configJSONObject = JSONUtil.merge((JSONObject)editableValueJSONObject.getJSONObject("config"), (JSONObject)mappedValueConfigJSONObject);
            JSONObject localizedJSONObject = configJSONObject.getJSONObject(LocaleUtil.toLanguageId((Locale)fragmentEntryProcessorContext.getLocale()));
            String mapperType = configJSONObject.getString("mapperType", element.attr("type"));
            if (localizedJSONObject != null && localizedJSONObject.length() > 0) {
                configJSONObject = localizedJSONObject;
            }
            editableElementParser.replace(element, value, configJSONObject);
            if (fragmentEntryProcessorContext.isEditMode()) continue;
            if (Validator.isNull((String)mapperType)) {
                mapperType = element.attr("data-lfr-editable-type");
            }
            if ((editableElementMapper = (EditableElementMapper)this._editableElementMapperServiceTrackerMap.getService((Object)mapperType)) == null) continue;
            editableElementMapper.map(element, configJSONObject, fragmentEntryProcessorContext);
        }
        if (fragmentEntryProcessorContext.isViewMode()) {
            for (Element element : document.select("lfr-editable")) {
                element.removeAttr("id");
                element.removeAttr("type");
                String tagName = element.attr("view-tag-name");
                if (!Objects.equals(tagName, "span")) {
                    tagName = "div";
                }
                element.tagName(tagName);
                element.removeAttr("view-tag-name");
            }
        }
        Element bodyElement = document.body();
        if (!infoDisplaysFieldValues.containsKey(fragmentEntryProcessorContext.getPreviewClassPK())) {
            return bodyElement.html();
        }
        Element previewElement = new Element("div");
        previewElement.attr("style", "border: 1px solid #0B5FFF");
        bodyElement = previewElement.html(bodyElement.html());
        return bodyElement.outerHtml();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        Document document = this._getDocument(html);
        this._validateAttributes(document);
        Elements elements = document.select("lfr-editable,*[data-lfr-editable-id]");
        this._validateDuplicatedIds(elements);
        this._validateEditableElements(elements);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._editableElementMapperServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementMapper.class, (String)"type");
        this._editableElementParserServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementParser.class, (String)"type");
    }

    @Deactivate
    protected void deactivate() {
        this._editableElementParserServiceTrackerMap.close();
        this._editableElementMapperServiceTrackerMap.close();
    }

    private JSONObject _getDefaultEditableValuesJSONObject(String html) {
        JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select("lfr-editable,*[data-lfr-editable-id]")) {
            EditableElementParser editableElementParser = this._getEditableElementParser(element);
            if (editableElementParser == null) continue;
            JSONObject defaultValueJSONObject = JSONUtil.put((String)"config", (Object)editableElementParser.getAttributes(element)).put("defaultValue", editableElementParser.getValue(element));
            defaultEditableValuesJSONObject.put(EditableFragmentEntryProcessorUtil.getElementId((Element)element), defaultValueJSONObject);
        }
        return defaultEditableValuesJSONObject;
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private EditableElementParser _getEditableElementParser(Element element) {
        String type = EditableFragmentEntryProcessorUtil.getElementType((Element)element);
        return (EditableElementParser)this._editableElementParserServiceTrackerMap.getService((Object)type);
    }

    private boolean _hasNestedWidget(Element element) {
        List portletAliases = this._portletRegistry.getPortletAliases();
        for (String portletAlias : portletAliases) {
            Elements tagElements = element.select("> lfr-widget-" + portletAlias);
            if (tagElements.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void _validateAttribute(Element element, String attributeName) throws FragmentEntryContentException {
        if (Validator.isNotNull((String)element.attr(attributeName))) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(this._language.format(resourceBundle, "you-must-define-all-required-attributes-x-for-each-editable-element", (Object)StringUtil.merge((Object[])_REQUIRED_ATTRIBUTE_NAMES)));
    }

    private void _validateAttributes(Document document) throws FragmentEntryContentException {
        for (Element element : document.getElementsByTag("lfr-editable")) {
            for (String attributeName : _REQUIRED_ATTRIBUTE_NAMES) {
                this._validateAttribute(element, attributeName);
            }
            this._validateType(element);
        }
        for (Element element : document.select("*[data-lfr-editable-id],*[data-lfr-editable-type]")) {
            this._validateAttribute(element, "data-lfr-editable-id");
            this._validateAttribute(element, "data-lfr-editable-type");
            this._validateType(element);
        }
    }

    private void _validateDuplicatedIds(Elements elements) throws FragmentEntryContentException {
        HashSet<String> ids = new HashSet<String>();
        for (Element element : elements) {
            if (ids.add(EditableFragmentEntryProcessorUtil.getElementId((Element)element))) continue;
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.get(resourceBundle, "you-must-define-a-unique-id-for-each-editable-element"));
        }
    }

    private void _validateEditableElements(Elements elements) throws FragmentEntryContentException {
        for (Element element : elements) {
            EditableElementParser editableElementParser = this._getEditableElementParser(element);
            if (editableElementParser == null) continue;
            this._validateNestedEditableElements(element);
            editableElementParser.validate(element);
        }
    }

    private void _validateNestedEditableElements(Element element) throws FragmentEntryContentException {
        Elements attributeElements = element.getElementsByAttribute("[data-lfr-editable-id]");
        Elements dropZoneElements = element.select("> lfr-drop-zone");
        Elements tagElements = element.select("> lfr-editable");
        if (attributeElements.size() > 0 || dropZoneElements.size() > 0 || this._hasNestedWidget(element) || tagElements.size() > 0) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.get(resourceBundle, "editable-fields-cannot-include-nested-editables-drop-zones-or-widgets-in-it"));
        }
    }

    private void _validateType(Element element) throws FragmentEntryContentException {
        EditableElementParser editableElementParser = this._getEditableElementParser(element);
        if (editableElementParser != null) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(this._language.get(resourceBundle, "you-must-define-a-valid-type-for-each-editable-element"));
    }
}

