/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.mapper;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=link"}, service={EditableElementMapper.class})
public class LinkEditableElementMapper
implements EditableElementMapper {
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;

    @Override
    public void map(Element element, JSONObject configJSONObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String href = configJSONObject.getString("href");
        boolean assetDisplayPage = this._fragmentEntryProcessorHelper.isAssetDisplayPage(fragmentEntryProcessorContext.getMode());
        boolean mapped = this._fragmentEntryProcessorHelper.isMapped(configJSONObject);
        if (Validator.isNull((String)href) && !assetDisplayPage && !mapped) {
            return;
        }
        Element linkElement = new Element("a");
        Elements elements = element.children();
        Element firstChild = elements.first();
        boolean replaceLink = false;
        if (firstChild != null && StringUtil.equalsIgnoreCase((String)firstChild.tagName(), (String)"a")) {
            linkElement = firstChild;
            replaceLink = true;
        }
        if (configJSONObject.has("target")) {
            linkElement.attr("target", configJSONObject.getString("target"));
        }
        String mappedField = configJSONObject.getString("mappedField");
        if (mapped) {
            Object fieldValue = this._fragmentEntryProcessorHelper.getMappedValue(configJSONObject, new HashMap(), fragmentEntryProcessorContext);
            if (fieldValue == null) {
                return;
            }
            linkElement.attr("href", fieldValue.toString());
            linkElement.html(replaceLink ? firstChild.html() : element.html());
            element.html(linkElement.outerHtml());
        } else if (Validator.isNotNull((String)href)) {
            linkElement.attr("href", href);
            linkElement.html(replaceLink ? firstChild.html() : element.html());
            element.html(linkElement.outerHtml());
        } else if (assetDisplayPage && Validator.isNotNull((String)mappedField)) {
            linkElement.attr("href", "${" + mappedField + "}");
            linkElement.html(replaceLink ? firstChild.html() : element.html());
            element.html(this._fragmentEntryProcessorHelper.processTemplate(linkElement.outerHtml(), fragmentEntryProcessorContext));
        }
    }
}

