/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.asset.info.display.contributor.util.ContentAccessorUtil;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.util.FragmentEntryProcessorUtil;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=2"}, service={FragmentEntryProcessor.class})
public class EditableFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final String[] _REQUIRED_ATTRIBUTE_NAMES = new String[]{"id", "type"};
    private final Map<String, EditableElementParser> _editableElementParsers = new HashMap<String, EditableElementParser>();
    @Reference
    private FragmentEntryProcessorUtil _fragmentEntryProcessorUtil;

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map.Entry<String, EditableElementParser> editableElementParser : this._editableElementParsers.entrySet()) {
            StringBundler sb = new StringBundler(2 + 5 * _REQUIRED_ATTRIBUTE_NAMES.length);
            sb.append("<lfr-editable");
            for (String attributeName : _REQUIRED_ATTRIBUTE_NAMES) {
                sb.append(" ");
                sb.append(attributeName);
                sb.append("=\"");
                String value = "";
                if (attributeName.equals("type")) {
                    value = editableElementParser.getKey();
                }
                sb.append(value);
                sb.append("\"");
            }
            sb.append("></lfr-editable>");
            JSONObject jsonObject = JSONUtil.put((String)"content", (Object)sb.toString()).put("name", "lfr-editable:" + editableElementParser.getKey());
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html) {
        JSONObject defaultEditableValuesJSONObject = JSONFactoryUtil.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select("lfr-editable")) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            JSONObject defaultValueJSONObject = JSONUtil.put((String)"config", (Object)editableElementParser.getAttributes(element)).put("defaultValue", editableElementParser.getValue(element));
            defaultEditableValuesJSONObject.put(element.attr("id"), defaultValueJSONObject);
        }
        return defaultEditableValuesJSONObject;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
        if (jsonObject.length() == 0) {
            Class<?> clazz = this.getClass();
            jsonObject.put(clazz.getName(), this.getDefaultEditableValuesJSONObject(fragmentEntryLink.getHtml()));
        }
        Document document = this._getDocument(html);
        HashMap infoDisplaysFieldValues = new HashMap();
        for (Element element : document.select("lfr-editable")) {
            Object fieldValue;
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            String id = element.attr("id");
            Class<?> clazz = this.getClass();
            JSONObject editableValuesJSONObject = jsonObject.getJSONObject(clazz.getName());
            if (editableValuesJSONObject == null || !editableValuesJSONObject.has(id)) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = "";
            JSONObject mappedValueConfigJSONObject = JSONFactoryUtil.createJSONObject();
            if (this._fragmentEntryProcessorUtil.isAssetDisplayPage(fragmentEntryProcessorContext.getMode()) && Validator.isNotNull((String)(value = editableValueJSONObject.getString("mappedField")))) {
                mappedValueConfigJSONObject = editableElementParser.getFieldTemplateConfigJSONObject(value, fragmentEntryProcessorContext.getLocale(), null);
                value = StringUtil.replace((String)editableElementParser.getFieldTemplate(), (String)"field_name", (String)value);
                value = this._processTemplate(value, fragmentEntryProcessorContext);
            }
            if (this._fragmentEntryProcessorUtil.isMapped(editableValueJSONObject) && (fieldValue = this._fragmentEntryProcessorUtil.getMappedValue(editableValueJSONObject, infoDisplaysFieldValues, fragmentEntryProcessorContext.getMode(), fragmentEntryProcessorContext.getLocale(), fragmentEntryProcessorContext.getPreviewClassPK(), fragmentEntryProcessorContext.getPreviewType())) != null) {
                String fieldId = editableValueJSONObject.getString("fieldId");
                mappedValueConfigJSONObject = editableElementParser.getFieldTemplateConfigJSONObject(fieldId, fragmentEntryProcessorContext.getLocale(), fieldValue);
                value = editableElementParser.parseFieldValue(fieldValue);
                value = this._processTemplate(value, fragmentEntryProcessorContext);
            }
            if (Validator.isNull((String)value)) {
                value = this._fragmentEntryProcessorUtil.getEditableValue(editableValueJSONObject, fragmentEntryProcessorContext.getLocale(), fragmentEntryProcessorContext.getSegmentsExperienceIds());
            }
            if (Objects.equals(fragmentEntryProcessorContext.getMode(), "EDIT")) {
                editableElementParser.replace(element, value);
                continue;
            }
            JSONObject configJSONObject = JSONUtil.merge((JSONObject)editableValueJSONObject.getJSONObject("config"), (JSONObject)mappedValueConfigJSONObject);
            editableElementParser.replace(element, value, configJSONObject);
        }
        if (Objects.equals(fragmentEntryProcessorContext.getMode(), "ASSET_DISPLAY_PAGE") || Objects.equals(fragmentEntryProcessorContext.getMode(), "VIEW")) {
            for (Element element : document.select("lfr-editable")) {
                element.removeAttr("id");
                element.removeAttr("type");
                element.tagName("div");
            }
        }
        Element bodyElement = document.body();
        if (!infoDisplaysFieldValues.containsKey(fragmentEntryProcessorContext.getPreviewClassPK())) {
            return bodyElement.html();
        }
        Element previewElement = new Element("div");
        previewElement.attr("style", "border: 1px solid #0B5FFF");
        bodyElement = previewElement.html(bodyElement.html());
        return bodyElement.outerHtml();
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, String mode, Locale locale, long[] segmentsExperienceIds, long previewClassPK, int previewType) throws PortalException {
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(null, null, mode, locale);
        defaultFragmentEntryProcessorContext.setPreviewClassPK(previewClassPK);
        defaultFragmentEntryProcessorContext.setPreviewType(previewType);
        defaultFragmentEntryProcessorContext.setSegmentsExperienceIds(segmentsExperienceIds);
        return this.processFragmentEntryLinkHTML(fragmentEntryLink, html, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerEditableElementParser(EditableElementParser editableElementParser, Map<String, Object> properties) {
        String editableTagName = (String)properties.get("type");
        this._editableElementParsers.put(editableTagName, editableElementParser);
    }

    public void unregisterEditableElementParser(EditableElementParser editableElementParser, Map<String, Object> properties) {
        String editableTagName = (String)properties.get("type");
        this._editableElementParsers.remove(editableTagName);
    }

    public void validateFragmentEntryHTML(String html) throws PortalException {
        this._validateAttributes(html);
        this._validateDuplicatedIds(html);
        this._validateEditableElements(html);
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _processTemplate(String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl]\n" + html), (boolean)true);
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"ftl");
        templateManager.addTaglibSupport((Map)template, fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        templateManager.addTaglibTheme((Map)template, "taglibLiferay", fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.put((Object)"writer", (Object)unsyncStringWriter);
        template.put((Object)"contentAccessorUtil", (Object)ContentAccessorUtil.getInstance());
        Optional fieldValuesOptional = fragmentEntryProcessorContext.getFieldValuesOptional();
        if (fieldValuesOptional.isPresent() && MapUtil.isNotEmpty((Map)((Map)fieldValuesOptional.get()))) {
            template.putAll((Map)fieldValuesOptional.get());
        }
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    private void _validateAttribute(Element element, String attributeName) throws FragmentEntryContentException {
        if (element.hasAttr(attributeName)) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"you-must-define-all-require-attributes-x-for-each-editable-element", (Object)StringUtil.merge((Object[])_REQUIRED_ATTRIBUTE_NAMES)));
    }

    private void _validateAttributes(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        for (Element element : document.getElementsByTag("lfr-editable")) {
            for (String attributeName : _REQUIRED_ATTRIBUTE_NAMES) {
                this._validateAttribute(element, attributeName);
            }
            this._validateType(element);
        }
    }

    private void _validateDuplicatedIds(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        Elements elements = document.getElementsByTag("lfr-editable");
        Stream uniqueNodesStream = elements.stream();
        Map<String, Long> idsMap = uniqueNodesStream.collect(Collectors.groupingBy(element -> element.attr("id"), Collectors.counting()));
        Set<String> ids = idsMap.keySet();
        Stream<Object> idsStream = ids.stream();
        if ((idsStream = idsStream.filter(id -> (Long)idsMap.get(id) > 1L)).count() > 0L) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-a-unique-id-for-each-editable-element"));
        }
    }

    private void _validateEditableElements(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        for (Element element : document.select("lfr-editable")) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            editableElementParser.validate(element);
        }
    }

    private void _validateType(Element element) throws FragmentEntryContentException {
        EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
        if (editableElementParser != null) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-a-valid-type-for-each-editable-element"));
    }
}

