/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=2"}, service={FragmentEntryProcessor.class})
public class EditableFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final String _LFR_EDITABLE = "lfr-editable";
    private static final String[] _REQUIRED_ATTRIBUTES = new String[]{"id", "type"};
    private final Map<String, EditableElementParser> _editableElementParsers = new HashMap<String, EditableElementParser>();

    public JSONObject getDefaultEditableValuesJSONObject(String html) {
        JSONObject defaultEditableValuesJSONObject = JSONFactoryUtil.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select(_LFR_EDITABLE)) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            JSONObject defaultValueJSONObject = JSONFactoryUtil.createJSONObject();
            defaultValueJSONObject.put("defaultValue", editableElementParser.getValue(element));
            defaultEditableValuesJSONObject.put(element.attr("id"), defaultValueJSONObject);
        }
        return defaultEditableValuesJSONObject;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, String mode) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
        Document document = this._getDocument(html);
        for (Element element : document.select(_LFR_EDITABLE)) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            String id = element.attr("id");
            Class<?> clazz = this.getClass();
            JSONObject editableValuesJSONObject = jsonObject.getJSONObject(clazz.getName());
            if (editableValuesJSONObject == null || !editableValuesJSONObject.has(id)) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = "";
            if (Objects.equals(mode, "ASSET_DISPLAY_PAGE")) {
                value = this._getMappedValue(editableElementParser, editableValueJSONObject);
            }
            if (Validator.isNull((String)value)) {
                value = this._getEditableValue(editableValueJSONObject, LocaleUtil.getMostRelevantLocale());
            }
            editableElementParser.replace(element, value);
        }
        if (Objects.equals(mode, "ASSET_DISPLAY_PAGE") || Objects.equals(mode, "VIEW")) {
            for (Element element : document.select(_LFR_EDITABLE)) {
                Document elementDocument = this._getDocument(element.html());
                element.replaceWith((Node)elementDocument.body());
            }
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerEditableElementParser(EditableElementParser editableElementParser, Map<String, Object> properties) {
        String editableTagName = (String)properties.get("type");
        this._editableElementParsers.put(editableTagName, editableElementParser);
    }

    public void unregisterEditableElementParser(EditableElementParser editableElementParser, Map<String, Object> properties) {
        String editableTagName = (String)properties.get("type");
        this._editableElementParsers.remove(editableTagName);
    }

    public void validateFragmentEntryHTML(String html) throws PortalException {
        this._validateAttributes(html);
        this._validateDuplicatedIds(html);
        this._validateEditableElements(html);
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _getEditableValue(JSONObject jsonObject, Locale locale) {
        String value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)locale));
        if (Validator.isNull((String)value)) {
            value = jsonObject.getString("defaultValue");
        }
        return value;
    }

    private String _getMappedValue(EditableElementParser editableElementParser, JSONObject jsonObject) {
        String value = jsonObject.getString("mappedField");
        if (Validator.isNull((String)value)) {
            return "";
        }
        return StringUtil.replace((String)editableElementParser.getFieldTemplate(), (String)"field_name", (String)value);
    }

    private void _validateAttribute(Element element, String attribute) throws FragmentEntryContentException {
        if (element.hasAttr(attribute)) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"you-must-define-all-require-attributes-x-for-each-editable-element", (Object)String.join((CharSequence)",", _REQUIRED_ATTRIBUTES)));
    }

    private void _validateAttributes(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        for (Element element : document.getElementsByTag(_LFR_EDITABLE)) {
            for (String attribute : _REQUIRED_ATTRIBUTES) {
                this._validateAttribute(element, attribute);
            }
            this._validateType(element);
        }
    }

    private void _validateDuplicatedIds(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        Elements elements = document.getElementsByTag(_LFR_EDITABLE);
        Stream uniqueNodesStream = elements.stream();
        Map<String, Long> idsMap = uniqueNodesStream.collect(Collectors.groupingBy(element -> element.attr("id"), Collectors.counting()));
        Set<String> ids = idsMap.keySet();
        Stream<Object> idsStream = ids.stream();
        if ((idsStream = idsStream.filter(id -> (Long)idsMap.get(id) > 1L)).count() > 0L) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-an-unique-id-for-each-editable-element"));
        }
    }

    private void _validateEditableElements(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        for (Element element : document.select(_LFR_EDITABLE)) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            editableElementParser.validate(element);
        }
    }

    private void _validateType(Element element) throws FragmentEntryContentException {
        EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
        if (editableElementParser != null) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-a-valid-type-for-each-editable-element"));
    }
}

