/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.drop.zone;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.renderer.FragmentDropZoneRenderer;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=6"}, service={FragmentEntryProcessor.class})
public class DropZoneFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentDropZoneRenderer _fragmentDropZoneRenderer;
    @Reference
    private Language _language;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;

    public JSONArray getAvailableTagsJSONArray() {
        return JSONUtil.put((Object)JSONUtil.put((String)"content", (Object)"<lfr-drop-zone></lfr-drop-zone>").put("name", "lfr-drop-zone"));
    }

    public JSONArray getDataAttributesJSONArray() {
        return JSONUtil.put((Object)"lfr-priority");
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        LayoutStructureItem layoutStructureItem;
        Document document = this._getDocument(html);
        Elements elements = document.select("lfr-drop-zone");
        if (elements.size() <= 0) {
            return html;
        }
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        LayoutStructure layoutStructure = null;
        if (httpServletRequest != null) {
            layoutStructure = (LayoutStructure)httpServletRequest.getAttribute("LAYOUT_STRUCTURE");
        }
        if (layoutStructure == null) {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid());
            if (layoutPageTemplateStructure == null) {
                return html;
            }
            layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(fragmentEntryLink.getSegmentsExperienceId()));
        }
        if ((layoutStructureItem = layoutStructure.getLayoutStructureItemByFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId())) == null) {
            return html;
        }
        List dropZoneItemIds = layoutStructureItem.getChildrenItemIds();
        if (Objects.equals(fragmentEntryProcessorContext.getMode(), "EDIT")) {
            int i;
            Element element2;
            boolean idsAvailable = true;
            for (Element element2 : elements) {
                if (!Validator.isNull((String)element2.id())) continue;
                idsAvailable = false;
                break;
            }
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-167932")) || !idsAvailable) {
                for (i = 0; i < dropZoneItemIds.size() && i < elements.size(); ++i) {
                    element2 = (Element)elements.get(i);
                    element2.attr("uuid", (String)dropZoneItemIds.get(i));
                }
            } else {
                block2: for (i = 0; i < elements.size(); ++i) {
                    element2 = (Element)elements.get(i);
                    String id = element2.id();
                    for (String itemId : dropZoneItemIds) {
                        FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem;
                        LayoutStructureItem childLayoutStructureItem = layoutStructure.getLayoutStructureItem(itemId);
                        if (!(childLayoutStructureItem instanceof FragmentDropZoneLayoutStructureItem) || !Objects.equals(id, (fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)childLayoutStructureItem).getFragmentDropZoneId())) continue;
                        element2.attr("uuid", itemId);
                        continue block2;
                    }
                }
            }
            Element bodyElement = document.body();
            return bodyElement.html();
        }
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            String dropZoneHTML = this._fragmentDropZoneRenderer.renderDropZone(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), (String)dropZoneItemIds.get(i), fragmentEntryProcessorContext.getMode(), true);
            Element dropZoneElement = new Element("div");
            dropZoneElement.html(dropZoneHTML);
            element.replaceWith((Node)dropZoneElement);
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-167932"))) {
            return;
        }
        Document document = this._getDocument(html);
        Elements elements = document.select("lfr-drop-zone");
        if (elements.isEmpty()) {
            return;
        }
        LinkedHashSet<String> elementIds = new LinkedHashSet<String>();
        for (Element element : elements) {
            String id = element.id();
            if (!Validator.isNotNull((String)id)) continue;
            elementIds.add(id);
        }
        if (!elementIds.isEmpty() && elementIds.size() != elements.size()) {
            throw new FragmentEntryContentException(this._language.get(this._portal.getResourceBundle(LocaleUtil.getDefault()), "you-must-define-a-unique-id-for-each-drop-zone"));
        }
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }
}

