/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.contributor;

import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseFragmentCollectionContributor
implements FragmentCollectionContributor {
    @Reference
    protected FragmentEntryLinkLocalService fragmentEntryLinkLocalService;
    @Reference
    protected FragmentEntryLocalService fragmentEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseFragmentCollectionContributor.class);
    private Bundle _bundle;
    private final Map<Integer, List<FragmentEntry>> _fragmentEntries = new HashMap<Integer, List<FragmentEntry>>();
    private String _name;

    @Override
    public List<FragmentEntry> getFragmentEntries(int type) {
        return this._fragmentEntries.getOrDefault(type, Collections.emptyList());
    }

    @Override
    public String getName() {
        return this._name;
    }

    public abstract ServletContext getServletContext();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
        this.readAndCheckFragmentCollectionStructure();
    }

    protected void readAndCheckFragmentCollectionStructure() {
        block4: {
            try {
                String name = this._getContributedCollectionName();
                Enumeration enumeration = this._bundle.findEntries("", "fragment.json", true);
                if (Validator.isNull((String)name) || !enumeration.hasMoreElements()) {
                    return;
                }
                this._name = name;
                while (enumeration.hasMoreElements()) {
                    URL url = (URL)enumeration.nextElement();
                    FragmentEntry fragmentEntry = this._getFragmentEntry(FileUtil.getPath((String)url.getPath()));
                    this._updateFragmentEntryLinks(fragmentEntry);
                    List fragmentEntryList = this._fragmentEntries.getOrDefault(fragmentEntry.getType(), new ArrayList());
                    fragmentEntryList.add(fragmentEntry);
                    this._fragmentEntries.put(fragmentEntry.getType(), fragmentEntryList);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    private String _getContributedCollectionName() throws Exception {
        Class<?> clazz = this.getClass();
        String json = StringUtil.read((InputStream)clazz.getResourceAsStream("dependencies/collection.json"));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        return jsonObject.getString("name");
    }

    private String _getFileContent(String path, String fileName) throws Exception {
        Class<?> clazz = this.getClass();
        StringBundler sb = new StringBundler(3);
        sb.append(path);
        sb.append("/");
        sb.append(fileName);
        return StringUtil.read((InputStream)clazz.getResourceAsStream(sb.toString()));
    }

    private FragmentEntry _getFragmentEntry(String path) throws Exception {
        JSONObject jsonObject = this._getStructure(path + "/fragment.json");
        String name = jsonObject.getString("name");
        String fragmentEntryKey = StringBundler.concat((String[])new String[]{this.getFragmentCollectionKey(), "-", jsonObject.getString("fragmentEntryKey")});
        String css = this._getFileContent(path, jsonObject.getString("cssPath"));
        String html = this._getFileContent(path, jsonObject.getString("htmlPath"));
        String js = this._getFileContent(path, jsonObject.getString("jsPath"));
        String thumbnailURL = this._getImagePreviewURL(jsonObject.getString("thumbnail"));
        int type = FragmentConstants.getTypeFromLabel(jsonObject.getString("type"));
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.createFragmentEntry(0L);
        fragmentEntry.setFragmentEntryKey(fragmentEntryKey);
        fragmentEntry.setName(name);
        fragmentEntry.setCss(css);
        fragmentEntry.setHtml(html);
        fragmentEntry.setJs(js);
        fragmentEntry.setType(type);
        fragmentEntry.setImagePreviewURL(thumbnailURL);
        return fragmentEntry;
    }

    private String _getImagePreviewURL(String fileName) {
        URL url = this._bundle.getResource("META-INF/resources/thumbnails/" + fileName);
        if (url == null) {
            return "";
        }
        ServletContext servletContext = this.getServletContext();
        return servletContext.getContextPath() + "/thumbnails/" + fileName;
    }

    private JSONObject _getStructure(String path) throws Exception {
        Class<?> clazz = this.getClass();
        String json = StringUtil.read((InputStream)clazz.getResourceAsStream(path));
        return JSONFactoryUtil.createJSONObject((String)json);
    }

    private void _updateFragmentEntryLinks(FragmentEntry fragmentEntry) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.fragmentEntryLinkLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"rendererKey", (Object)fragmentEntry.getFragmentEntryKey())));
        actionableDynamicQuery.setPerformActionMethod(fragmentEntryLink -> {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            fragmentEntryLink.setHtml(fragmentEntry.getHtml());
            fragmentEntryLink.setJs(fragmentEntry.getJs());
            this.fragmentEntryLinkLocalService.updateFragmentEntryLink((FragmentEntryLink)fragmentEntryLink);
        });
        actionableDynamicQuery.performActions();
    }
}

