/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.architect.util;

import com.liferay.apio.architect.functional.Try;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;

public class StructuredContentUtil {
    private static final Log _log = LogFactoryUtil.getLog(StructuredContentUtil.class);

    public static Long getFileEntryId(String value, DLAppService dlAppService) {
        return (Long)Try.fromFallible(() -> value).filter(StructuredContentUtil::isJSONObject).filter(s -> s.contains("fileEntryId")).map(JSONFactoryUtil::createJSONObject).map(jsonObject -> StructuredContentUtil._getFileEntry(jsonObject, dlAppService)).map(FileEntry::getFileEntryId).orElse(null);
    }

    public static boolean isJSONObject(String json) {
        try {
            return json.startsWith("{") && JSONFactoryUtil.createJSONObject((String)json) != null;
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
            }
            return false;
        }
    }

    private static FileEntry _getFileEntry(JSONObject jsonObject, DLAppService dlAppService) throws PortalException {
        String uuid = jsonObject.getString("uuid");
        long groupId = jsonObject.getLong("groupId");
        return dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
    }
}

