/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.helper;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureModel;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.forms.apio.internal.util.LocalizedValueUtil;
import com.liferay.structure.apio.architect.model.FormLayoutPage;
import com.liferay.structure.apio.architect.util.StructureRepresentorBuilderHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FormStructureRepresentorBuilderHelper.class})
public class FormStructureRepresentorBuilderHelper {
    @Reference
    private StructureRepresentorBuilderHelper _structureRepresentorBuilderHelper;

    public Representor.FirstStep<DDMStructure> buildDDMStructureFirstStep(Representor.Builder<DDMStructure, Long> builder) {
        Representor.FirstStep ddmStructureFirstStep = this._structureRepresentorBuilderHelper.buildDDMStructureFirstStep(builder);
        Representor.FirstStep bidirectionalModelStepBuilder = ddmStructureFirstStep.addBidirectionalModel("contentSpace", "formStructures", ContentSpaceIdentifier.class, DDMStructureModel::getGroupId);
        ((Representor.FirstStep)bidirectionalModelStepBuilder.addNested("successPage", this::_getDDMFormSuccessPageSettings, this::_buildDDMFormSuccessPageSettings)).addNestedList("formPages", arg_0 -> ((StructureRepresentorBuilderHelper)this._structureRepresentorBuilderHelper).getFormLayoutPages(arg_0), nestedBuilder -> (NestedRepresentor)this._buildFormLayoutPage((NestedRepresentor.Builder<FormLayoutPage>)nestedBuilder).build());
        return ddmStructureFirstStep;
    }

    private static Function<DDMFormField, Boolean> _getHasFormRulesFunction() {
        return ddmFormField -> ((Stream)Try.fromFallible(() -> ((DDMFormField)ddmFormField).getDDMForm()).map(DDMForm::getDDMFormRules).map(Collection::stream).orElseGet(Stream::empty)).map(DDMFormRule::getCondition).anyMatch(ruleCondition -> ruleCondition.contains(ddmFormField.getName()));
    }

    private NestedRepresentor<DDMFormField> _buildDDMFormField(NestedRepresentor.Builder<DDMFormField> builder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormFieldProperties", new String[0]).addNestedList("columns", this._structureRepresentorBuilderHelper.getLocalizedValueEntriesFunction("columns"), this::_buildFieldOptions)).addNestedList("rows", this._structureRepresentorBuilderHelper.getLocalizedValueEntriesFunction("rows"), this::_buildFieldOptions)).build();
    }

    private NestedRepresentor.FirstStep<DDMFormField> _buildDDMFormFields(NestedRepresentor.Builder<DDMFormField> builder) {
        NestedRepresentor.FirstStep ddmFormFieldFirstStepBuilder = this._structureRepresentorBuilderHelper.buildDDMFormFieldFirstStep(builder);
        ((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)ddmFormFieldFirstStepBuilder.addBoolean("hasFormRules", FormStructureRepresentorBuilderHelper._getHasFormRulesFunction())).addBoolean("transient", DDMFormField::isTransient)).addNested("grid", ddmFormField -> ddmFormField, this::_buildDDMFormField);
        return ddmFormFieldFirstStepBuilder;
    }

    private NestedRepresentor<DDMFormSuccessPageSettings> _buildDDMFormSuccessPageSettings(NestedRepresentor.Builder<DDMFormSuccessPageSettings> builder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormSuccessPageSettings", new String[0]).addLocalizedStringByLocale("description", LocalizedValueUtil.getLocalizedString(DDMFormSuccessPageSettings::getBody))).addLocalizedStringByLocale("headline", LocalizedValueUtil.getLocalizedString(DDMFormSuccessPageSettings::getTitle))).build();
    }

    private NestedRepresentor<Map.Entry<String, LocalizedValue>> _buildFieldOptions(NestedRepresentor.Builder<Map.Entry<String, LocalizedValue>> builder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormFieldOptions", new String[0]).addLocalizedStringByLocale("label", LocalizedValueUtil.getLocalizedString(Map.Entry::getValue))).addString("value", Map.Entry::getKey)).build();
    }

    private NestedRepresentor.FirstStep<FormLayoutPage> _buildFormLayoutPage(NestedRepresentor.Builder<FormLayoutPage> builder) {
        NestedRepresentor.FirstStep formLayoutPageFirstStep = this._structureRepresentorBuilderHelper.buildFormLayoutPageFirstStep(builder);
        formLayoutPageFirstStep.addNestedList("fields", FormLayoutPage::getFields, ddmFormFieldBuilder -> (NestedRepresentor)this._buildDDMFormFields((NestedRepresentor.Builder<DDMFormField>)ddmFormFieldBuilder).build());
        return formLayoutPageFirstStep;
    }

    private DDMFormSuccessPageSettings _getDDMFormSuccessPageSettings(DDMStructure ddmStructure) {
        return Optional.of(ddmStructure.getDDMForm()).map(DDMForm::getDDMFormSuccessPageSettings).filter(DDMFormSuccessPageSettings::isEnabled).orElse(null);
    }
}

