/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.architect.resource;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordModel;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.forms.apio.architect.identifier.FormInstanceIdentifier;
import com.liferay.forms.apio.architect.identifier.FormInstanceRecordIdentifier;
import com.liferay.forms.apio.internal.architect.form.FormInstanceRecordForm;
import com.liferay.forms.apio.internal.architect.locale.AcceptLocale;
import com.liferay.forms.apio.internal.helper.UploadFileHelper;
import com.liferay.forms.apio.internal.model.ServiceContextWrapper;
import com.liferay.forms.apio.internal.util.FormInstanceRecordResourceUtil;
import com.liferay.forms.apio.internal.util.FormValuesUtil;
import com.liferay.forms.apio.internal.util.LocalizedValueUtil;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.structured.content.apio.architect.util.StructuredContentUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionResource.class})
public class FormInstanceRecordNestedCollectionResource
implements NestedCollectionResource<DDMFormInstanceRecord, Long, FormInstanceRecordIdentifier, Long, FormInstanceIdentifier> {
    @Reference
    private DDMFormInstanceRecordService _ddmFormInstanceRecordService;
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private UploadFileHelper _uploadFileHelper;

    public NestedCollectionRoutes<DDMFormInstanceRecord, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<DDMFormInstanceRecord, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_addDDMFormInstanceRecord, AcceptLocale.class, ServiceContextWrapper.class, this._hasPermission.forAddingIn(FormInstanceRecordIdentifier.class), FormInstanceRecordForm::buildForm).build();
    }

    public String getName() {
        return "form-record";
    }

    public ItemRoutes<DDMFormInstanceRecord, Long> itemRoutes(ItemRoutes.Builder<DDMFormInstanceRecord, Long> builder) {
        return builder.addGetter(arg_0 -> ((DDMFormInstanceRecordService)this._ddmFormInstanceRecordService).getFormInstanceRecord(arg_0)).addUpdater(this::_updateDDMFormInstanceRecord, AcceptLocale.class, ServiceContextWrapper.class, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), FormInstanceRecordForm::buildForm).build();
    }

    public Representor<DDMFormInstanceRecord> representor(Representor.Builder<DDMFormInstanceRecord, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("FormRecord", new String[0]).identifier(DDMFormInstanceRecordModel::getFormInstanceRecordId).addBidirectionalModel("form", "formRecords", FormInstanceIdentifier.class, DDMFormInstanceRecordModel::getFormInstanceId).addBoolean("draft", this::_isDraft)).addDate("dateCreated", DDMFormInstanceRecordModel::getCreateDate)).addDate("dateModified", DDMFormInstanceRecordModel::getModifiedDate)).addDate("datePublished", DDMFormInstanceRecordModel::getLastPublishDate)).addLinkedModel("creator", PersonIdentifier.class, DDMFormInstanceRecordModel::getUserId)).addNestedList("fieldValues", this::_getDDMFormFieldValues, fieldValuesBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)fieldValuesBuilder.types("FormFieldValue", new String[0]).addLinkedModel("document", MediaObjectIdentifier.class, ddmFormFieldValue -> (Long)Try.fromFallible(() -> ((DDMFormFieldValue)ddmFormFieldValue).getValue()).map(value -> value.getString(LocaleUtil.getDefault())).map(string -> StructuredContentUtil.getFileEntryId(string, this._dlAppService)).orElse(null))).addLocalizedStringByLocale("value", LocalizedValueUtil.getLocalizedString(DDMFormFieldValue::getValue))).addString("name", DDMFormFieldValue::getName)).build())).build();
    }

    private DDMFormInstanceRecord _addDDMFormInstanceRecord(long ddmFormInstanceId, FormInstanceRecordForm formInstanceRecordForm, AcceptLocale acceptLocale, ServiceContextWrapper serviceContextWrapper) throws PortalException {
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId);
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMFormValues ddmFormValues = FormValuesUtil.getDDMFormValues(formInstanceRecordForm.getFieldValues(), ddmForm, (Locale)acceptLocale.get());
        this._uploadFileHelper.linkFiles(ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValues());
        ServiceContext serviceContext = FormInstanceRecordResourceUtil.calculateServiceContextAttributes(serviceContextWrapper, formInstanceRecordForm.isDraft());
        return this._ddmFormInstanceRecordService.addFormInstanceRecord(ddmFormInstance.getGroupId(), ddmFormInstance.getFormInstanceId(), ddmFormValues, serviceContext);
    }

    private List<DDMFormFieldValue> _getDDMFormFieldValues(DDMFormInstanceRecord ddmFormInstanceRecord) {
        return (List)Try.fromFallible(() -> ((DDMFormInstanceRecord)ddmFormInstanceRecord).getDDMFormValues()).map(DDMFormValues::getDDMFormFieldValues).orElse(null);
    }

    private PageItems<DDMFormInstanceRecord> _getPageItems(Pagination pagination, Long formInstanceId) throws PortalException {
        List ddmFormInstanceRecords = this._ddmFormInstanceRecordService.getFormInstanceRecords(formInstanceId.longValue(), -1, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._ddmFormInstanceRecordService.getFormInstanceRecordsCount(formInstanceId.longValue());
        return new PageItems((Collection)ddmFormInstanceRecords, count);
    }

    private Boolean _isDraft(DDMFormInstanceRecord ddmFormInstanceRecord) {
        return (Boolean)Try.fromFallible(() -> ((DDMFormInstanceRecord)ddmFormInstanceRecord).getStatus()).map(status -> status == 2).orElse((Object)false);
    }

    private DDMFormInstanceRecord _updateDDMFormInstanceRecord(long formInstanceRecordId, FormInstanceRecordForm formInstanceRecordForm, AcceptLocale acceptLocale, ServiceContextWrapper serviceContextWrapper) throws PortalException {
        DDMFormInstanceRecord ddmFormInstanceRecord = this._ddmFormInstanceRecordService.getFormInstanceRecord(formInstanceRecordId);
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMFormValues ddmFormValues = FormValuesUtil.getDDMFormValues(formInstanceRecordForm.getFieldValues(), ddmForm, (Locale)acceptLocale.get());
        this._uploadFileHelper.linkFiles(ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValues());
        ServiceContext serviceContext = FormInstanceRecordResourceUtil.calculateServiceContextAttributes(serviceContextWrapper, formInstanceRecordForm.isDraft());
        return this._ddmFormInstanceRecordService.updateFormInstanceRecord(formInstanceRecordId, false, ddmFormValues, serviceContext);
    }
}

