/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.folder.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.folder.apio.architect.identifier.FolderIdentifier;
import com.liferay.folder.apio.internal.architect.form.FolderForm;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class FolderNestedCollectionRouter
implements NestedCollectionRouter<Folder, Long, FolderIdentifier, Long, FolderIdentifier> {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.Folder)")
    private HasPermission<Long> _hasPermission;

    public NestedCollectionRoutes<Folder, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<Folder, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_addFolder, this._hasPermission.forAddingIn(FolderIdentifier.class), FolderForm::buildForm).build();
    }

    private Folder _addFolder(long parentFolderId, FolderForm folderForm) throws PortalException {
        Folder folder = this._dlAppLocalService.getFolder(parentFolderId);
        return this._dlAppService.addFolder(folder.getGroupId(), parentFolderId, folderForm.getName(), folderForm.getDescription(), new ServiceContext());
    }

    private PageItems<Folder> _getPageItems(Pagination pagination, long parentFolderId) throws PortalException {
        Folder parentFolder = this._dlAppService.getFolder(parentFolderId);
        long groupId = parentFolder.getGroupId();
        List folders = this._dlAppService.getFolders(groupId, parentFolderId, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._dlAppService.getFoldersCount(groupId, parentFolderId);
        return new PageItems((Collection)folders, count);
    }
}

