/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.exception.LARFileNameException;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.ui.util.SessionTreeJSClicks;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportPortlet", "mvc.command.name=exportLayouts"}, service={MVCActionCommand.class})
public class ExportLayoutsMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(ExportLayoutsMVCActionCommand.class);
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportConfigurationSettingsMapFactory _exportImportConfigurationSettingsMapFactory;
    @Reference
    private ExportImportHelper _exportImportHelper;
    private ExportImportService _exportImportService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block3: {
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            if (Validator.isNull((String)cmd)) {
                SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".forceSendRedirect"));
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                return;
            }
            this.setLayoutIdMap(actionRequest);
            try {
                ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(actionRequest);
                this._exportImportService.exportLayoutsAsFileInBackground(exportImportConfiguration);
                this.sendRedirect(actionRequest, actionResponse);
            }
            catch (Exception e) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                if (e instanceof LARFileNameException) break block3;
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected ExportImportConfiguration getExportImportConfiguration(ActionRequest actionRequest) throws Exception {
        String taskName;
        ExportImportConfiguration exportImportConfiguration;
        Map exportLayoutSettingsMap = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            exportLayoutSettingsMap = exportImportConfiguration.getSettingsMap();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        if (exportLayoutSettingsMap == null) {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
            long[] layoutIds = this.getLayoutIds((PortletRequest)actionRequest);
            exportLayoutSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildExportLayoutSettingsMap(themeDisplay.getUserId(), groupId, privateLayout, layoutIds, actionRequest.getParameterMap(), themeDisplay.getLocale(), themeDisplay.getTimeZone());
        }
        if (Validator.isNull((String)(taskName = ParamUtil.getString((PortletRequest)actionRequest, (String)"name")))) {
            taskName = privateLayout ? LanguageUtil.get((Locale)actionRequest.getLocale(), (String)"private-pages") : LanguageUtil.get((Locale)actionRequest.getLocale(), (String)"public-pages");
        }
        return this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), taskName, 0, exportLayoutSettingsMap);
    }

    protected long[] getLayoutIds(PortletRequest portletRequest) throws Exception {
        return this._exportImportHelper.getLayoutIds(portletRequest);
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportService(ExportImportService exportImportService) {
        this._exportImportService = exportImportService;
    }

    protected void setLayoutIdMap(ActionRequest actionRequest) {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        String treeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"treeId");
        String openNodes = SessionTreeJSClicks.getOpenNodes((HttpServletRequest)httpServletRequest, (String)(treeId + "SelectedNode"));
        String selectedLayoutsJSON = this._exportImportHelper.getSelectedLayoutsJSON(groupId, privateLayout, openNodes);
        actionRequest.setAttribute("layoutIdMap", (Object)selectedLayoutsJSON);
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

