/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.messaging;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.web.internal.configuration.ExportImportWebConfigurationValues;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Order;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DraftExportImportConfigurationMessageListener.class})
public class DraftExportImportConfigurationMessageListener
extends BaseMessageListener {
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    private GroupLocalService _groupLocalService;
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, ExportImportWebConfigurationValues.DRAFT_EXPORT_IMPORT_CONFIGURATION_CHECK_INTERVAL, TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    protected void addCommonCriterions(DynamicQuery dynamicQuery) {
        Property typeProperty = PropertyFactoryUtil.forName((String)"type");
        dynamicQuery.add(typeProperty.ne((Object)3));
        dynamicQuery.add(typeProperty.ne((Object)4));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dynamicQuery.add(statusProperty.eq((Object)2));
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws PortalException {
        Date lastCreateDate;
        if (ExportImportWebConfigurationValues.DRAFT_EXPORT_IMPORT_CONFIGURATION_CLEAN_UP_COUNT == -1) {
            return;
        }
        if (ExportImportWebConfigurationValues.DRAFT_EXPORT_IMPORT_CONFIGURATION_CLEAN_UP_COUNT == 0) {
            lastCreateDate = new Date();
        } else {
            DynamicQuery dynamicQuery2 = this._exportImportConfigurationLocalService.dynamicQuery();
            this.addCommonCriterions(dynamicQuery2);
            Order order = OrderFactoryUtil.desc((String)"createDate");
            dynamicQuery2.addOrder(order);
            dynamicQuery2.setLimit(-1, ExportImportWebConfigurationValues.DRAFT_EXPORT_IMPORT_CONFIGURATION_CLEAN_UP_COUNT);
            dynamicQuery2.setProjection(ProjectionFactoryUtil.property((String)"createDate"));
            List createDates = this._exportImportConfigurationLocalService.dynamicQuery(dynamicQuery2);
            if (ListUtil.isEmpty((List)createDates)) {
                return;
            }
            lastCreateDate = (Date)createDates.get(createDates.size() - 1);
        }
        ActionableDynamicQuery actionableDynamicQuery = this._exportImportConfigurationLocalService.getActionableDynamicQuery();
        Property createDate = PropertyFactoryUtil.forName((String)"createDate");
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            this.addCommonCriterions(dynamicQuery);
            dynamicQuery.add(createDate.lt((Object)lastCreateDate));
        });
        actionableDynamicQuery.setPerformActionMethod(exportImportConfiguration -> {
            List<BackgroundTask> backgroundTasks = this.getParentBackgroundTasks((ExportImportConfiguration)exportImportConfiguration);
            if (ListUtil.isEmpty(backgroundTasks)) {
                this._exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
                return;
            }
            for (BackgroundTask backgroundTask : backgroundTasks) {
                if (this.isLiveGroup(backgroundTask.getGroupId())) continue;
                this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTask.getBackgroundTaskId());
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected List<BackgroundTask> getParentBackgroundTasks(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        DynamicQuery dynamicQuery = this._backgroundTaskLocalService.dynamicQuery();
        Property completedProperty = PropertyFactoryUtil.forName((String)"completed");
        dynamicQuery.add(completedProperty.eq((Object)Boolean.TRUE));
        Property taskContextMapProperty = PropertyFactoryUtil.forName((String)"taskContextMap");
        StringBundler sb = new StringBundler(7);
        sb.append("%");
        sb.append("\"");
        sb.append("exportImportConfigurationId");
        sb.append("\"");
        sb.append(":");
        sb.append(exportImportConfiguration.getExportImportConfigurationId());
        sb.append("%");
        dynamicQuery.add(taskContextMapProperty.like((Object)sb.toString()));
        return this._backgroundTaskLocalService.dynamicQuery(dynamicQuery);
    }

    protected boolean isLiveGroup(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return false;
        }
        return group.hasStagingGroup();
    }

    @Reference(unbind="-")
    protected void setBackgroundTaskLocalService(BackgroundTaskLocalService backgroundTaskLocalService) {
        this._backgroundTaskLocalService = backgroundTaskLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setSchedulerEngineHelper(SchedulerEngineHelper schedulerEngineHelper) {
        this._schedulerEngineHelper = schedulerEngineHelper;
    }
}

