/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.exception.StructureDuplicateStructureKeyException;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARFileNameException;
import com.liferay.exportimport.kernel.exception.LARFileSizeException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportImportPortlet", "mvc.command.name=publishPortlet"}, service={MVCActionCommand.class})
public class PublishPortletMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(PublishPortletMVCActionCommand.class);
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        actionRequest = ActionUtil.getWrappedActionRequest(actionRequest, null);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".forceSendRedirect"));
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            return;
        }
        try {
            if (cmd.equals("copy_from_live")) {
                this._staging.copyFromLive((PortletRequest)actionRequest, portlet);
            } else if (cmd.equals("publish_to_live")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this._staging.publishToLive((PortletRequest)actionRequest, portlet);
            }
        }
        catch (Exception e) {
            if (e instanceof LARFileException || e instanceof LARFileNameException || e instanceof LARFileSizeException || e instanceof LARTypeException || e instanceof LocaleException || e instanceof NoSuchLayoutException || e instanceof PortletIdException || e instanceof PrincipalException || e instanceof StructureDuplicateStructureKeyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)PublishPortletMVCActionCommand.class.getName());
        }
    }
}

