/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateStructureKeyException;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARFileNameException;
import com.liferay.exportimport.kernel.exception.LARFileSizeException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.web.internal.portlet.action.ActionUtil;
import com.liferay.exportimport.web.internal.portlet.action.ImportLayoutsMVCActionCommand;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportImportPortlet", "mvc.command.name=exportImport"}, service={MVCActionCommand.class})
public class ExportImportMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportMVCActionCommand.class);
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportConfigurationSettingsMapFactory _exportImportConfigurationSettingsMapFactory;
    @Reference
    private ExportImportHelper _exportImportHelper;
    private ExportImportService _exportImportService;
    private ImportLayoutsMVCActionCommand _importLayoutsMVCActionCommand;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        actionRequest = ActionUtil.getWrappedActionRequest(actionRequest, null);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".forceSendRedirect"));
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            return;
        }
        try {
            if (cmd.equals("add_temp")) {
                this._importLayoutsMVCActionCommand.addTempFileEntry(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                this.validateFile(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("delete_temp")) {
                this._importLayoutsMVCActionCommand.deleteTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("export")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.exportData(actionRequest, portlet);
                this.sendRedirect(actionRequest, actionResponse);
            } else if (cmd.equals("import")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.importData(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".closeRefreshPortlet"), (Object)portlet.getPortletId());
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this._importLayoutsMVCActionCommand.handleUploadException(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId(), e);
            }
            if (e instanceof LARFileException || e instanceof LARFileNameException || e instanceof LARFileSizeException || e instanceof LARTypeException || e instanceof LocaleException || e instanceof NoSuchLayoutException || e instanceof PortletIdException || e instanceof PrincipalException || e instanceof StructureDuplicateStructureKeyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)ExportImportMVCActionCommand.class.getName());
        }
    }

    protected void exportData(ActionRequest actionRequest, Portlet portlet) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
            Map exportPortletSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildExportPortletSettingsMap(themeDisplay.getUserId(), plid, groupId, portlet.getPortletId(), actionRequest.getParameterMap(), themeDisplay.getLocale(), themeDisplay.getTimeZone(), fileName);
            ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), 5, exportPortletSettingsMap);
            this._exportImportService.exportPortletInfoAsFileInBackground(exportImportConfiguration);
        }
        catch (Exception e) {
            if (e instanceof LARFileNameException) {
                throw e;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
    }

    protected void importData(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Portlet portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        Map importPortletSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildImportPortletSettingsMap(themeDisplay.getUserId(), plid, groupId, portlet.getPortletId(), actionRequest.getParameterMap(), themeDisplay.getLocale(), themeDisplay.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), 7, importPortletSettingsMap);
        this._exportImportService.importPortletInfoInBackground(exportImportConfiguration, inputStream);
    }

    protected void importData(ActionRequest actionRequest, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = this._exportImportHelper.getTempFileEntry(groupId, themeDisplay.getUserId(), folderName);
        try (InputStream inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);){
            this.importData(actionRequest, inputStream);
            this._importLayoutsMVCActionCommand.deleteTempFileEntry(groupId, folderName);
        }
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportService(ExportImportService exportImportService) {
        this._exportImportService = exportImportService;
    }

    @Reference(unbind="-")
    protected void setImportLayoutsMVCActionCommand(ImportLayoutsMVCActionCommand importLayoutsMVCActionCommand) {
        this._importLayoutsMVCActionCommand = importLayoutsMVCActionCommand;
    }

    protected void validateFile(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = this._exportImportHelper.getTempFileEntry(groupId, themeDisplay.getUserId(), folderName);
        try (InputStream inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);){
            MissingReferences missingReferences = this.validateFile(actionRequest, inputStream);
            Map weakMissingReferences = missingReferences.getWeakMissingReferences();
            if (weakMissingReferences.isEmpty()) {
                return;
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
                jsonObject.put("warningMessages", this._staging.getWarningMessagesJSONArray(themeDisplay.getLocale(), weakMissingReferences));
            }
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
    }

    protected MissingReferences validateFile(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Portlet portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        Map importPortletSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildImportPortletSettingsMap(themeDisplay.getUserId(), plid, groupId, portlet.getPortletId(), actionRequest.getParameterMap(), themeDisplay.getLocale(), themeDisplay.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), 7, importPortletSettingsMap);
        return this._exportImportService.validateImportPortletInfo(exportImportConfiguration, inputStream);
    }
}

