/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.test.util.model.DummyFolder;
import com.liferay.portal.dao.orm.hibernate.DynamicQueryImpl;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.impl.CriteriaImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.exportimport.test.util.model.DummyFolder"}, service={StagedModelRepository.class})
public class DummyFolderStagedModelRepository
implements StagedModelRepository<DummyFolder> {
    @Reference
    protected Portal portal;
    @Reference
    protected SystemEventLocalService systemEventLocalService;
    private final List<DummyFolder> _dummyFolders = new ArrayList<DummyFolder>();

    public DummyFolder addStagedModel(PortletDataContext portletDataContext, DummyFolder dummyFolder) throws PortalException {
        if (portletDataContext != null && portletDataContext.getUserIdStrategy() != null) {
            dummyFolder.setUserId(portletDataContext.getUserId(dummyFolder.getUserUuid()));
        }
        dummyFolder.setId(new DummyFolder().getId());
        this._dummyFolders.add(dummyFolder);
        return dummyFolder;
    }

    public void deleteStagedModel(DummyFolder dummyFolder) throws PortalException {
        if (this._dummyFolders.remove(dummyFolder)) {
            this.systemEventLocalService.addSystemEvent(0L, dummyFolder.getGroupId(), dummyFolder.getModelClassName(), dummyFolder.getPrimaryKey(), dummyFolder.getUuid(), "", 1, "");
        }
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._dummyFolders.removeIf(dummyFolder -> Objects.equals(dummyFolder.getUuid(), uuid) && dummyFolder.getGroupId() == groupId);
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._dummyFolders.clear();
    }

    public DummyFolder fetchMissingReference(String uuid, long groupId) {
        return this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public DummyFolder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        Stream dummyFoldersStream = this._dummyFolders.stream();
        List dummyFolders = dummyFoldersStream.filter(dummyFolder -> Objects.equals(dummyFolder.getUuid(), uuid) && dummyFolder.getGroupId() == groupId).collect(Collectors.toList());
        if (dummyFolders.isEmpty()) {
            return null;
        }
        return (DummyFolder)dummyFolders.get(0);
    }

    public List<DummyFolder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        Stream dummyFoldersStream = this._dummyFolders.stream();
        return dummyFoldersStream.filter(dummyFolder -> Objects.equals(dummyFolder.getUuid(), uuid) && dummyFolder.getCompanyId() == companyId).collect(Collectors.toList());
    }

    public List<DummyFolder> getDummyFolders(long groupId) {
        Stream dummyFoldersStream = this._dummyFolders.stream();
        return dummyFoldersStream.filter(d -> d.getGroupId() == groupId).collect(Collectors.toList());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = DummyFolderStagedModelRepository.this._dummyFolders.size();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                manifestSummary.addModelDeletionCount(stagedModelType, 0L);
                return modelAdditionCount;
            }

            protected Projection getCountProjection() {
                return ProjectionFactoryUtil.countDistinct((String)"resourcePrimKey");
            }
        };
        exportActionableDynamicQuery.setBaseLocalService((BaseLocalService)new DummyFolderBaseLocalServiceImpl());
        Class<?> clazz = this.getClass();
        exportActionableDynamicQuery.setClassLoader(clazz.getClassLoader());
        exportActionableDynamicQuery.setModelClass(DummyFolder.class);
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("id");
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction disjunction;
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
            if (modifiedDateCriterion != null) {
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(modifiedDateCriterion);
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                disjunction.add(lastPublishDateProperty.isNull());
                conjunction.add((Criterion)disjunction);
                modifiedDateCriterion = conjunction;
            }
            Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
            if (modifiedDateCriterion != null && statusDateCriterion != null) {
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(modifiedDateCriterion);
                disjunction.add(statusDateCriterion);
                dynamicQuery.add((Criterion)disjunction);
            }
            StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
            long referrerClassNameId = stagedModelType.getReferrerClassNameId();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
            } else if (referrerClassNameId == -2L) {
                dynamicQuery.add(classNameIdProperty.isNotNull());
            }
            Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
            if (portletDataContext.isInitialPublication()) {
                dynamicQuery.add(workflowStatusProperty.ne((Object)8));
            } else {
                StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DummyFolder.class.getName());
                dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(dummyFolder -> StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dummyFolder));
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(this.portal.getClassNameId(DummyFolder.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public DummyFolder getFolder(long folderId) {
        Stream dummyFoldersStream = this._dummyFolders.stream();
        List dummyFolders = dummyFoldersStream.filter(f -> f.getId() == folderId).collect(Collectors.toList());
        if (dummyFolders.isEmpty()) {
            throw new RuntimeException((Throwable)new NoSuchModelException());
        }
        return (DummyFolder)dummyFolders.get(0);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, DummyFolder dummyFolder) throws PortletDataException {
    }

    public DummyFolder saveStagedModel(DummyFolder dummyFolder) throws PortalException {
        this.deleteStagedModel(dummyFolder);
        this.addStagedModel(null, dummyFolder);
        return dummyFolder;
    }

    public DummyFolder updateStagedModel(PortletDataContext portletDataContext, DummyFolder dummyFolder) throws PortalException {
        DummyFolder existingDummyFolder = this._fetchDummyFolder(dummyFolder);
        existingDummyFolder.setUserId(portletDataContext.getUserId(dummyFolder.getUserUuid()));
        return dummyFolder;
    }

    private DummyFolder _fetchDummyFolder(DummyFolder dummyFolder) throws NoSuchModelException {
        int i = this._dummyFolders.indexOf(dummyFolder);
        if (i < 0) {
            throw new NoSuchModelException();
        }
        return this._dummyFolders.get(i);
    }

    public class DummyFolderBaseLocalServiceImpl
    extends BaseLocalServiceImpl {
        public List<DummyFolder> dynamicQuery(DynamicQuery dynamicQuery) {
            DetachedCriteria detachedCriteria = ((DynamicQueryImpl)dynamicQuery).getDetachedCriteria();
            Class<?> detachedCriteriaClass = detachedCriteria.getClass();
            List result = DummyFolderStagedModelRepository.this._dummyFolders;
            try {
                Method method = detachedCriteriaClass.getDeclaredMethod("getCriteriaImpl", new Class[0]);
                method.setAccessible(true);
                CriteriaImpl detachedCriteriaImpl = (CriteriaImpl)method.invoke((Object)detachedCriteria, new Object[0]);
                Iterator iterator = detachedCriteriaImpl.iterateExpressionEntries();
                while (iterator.hasNext()) {
                    CriteriaImpl.CriterionEntry criteriaImpl = (CriteriaImpl.CriterionEntry)iterator.next();
                    Stream dummyFoldersStream = result.stream();
                    result = dummyFoldersStream.filter(this.getPredicate(criteriaImpl.toString())).collect(Collectors.toList());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
            return DummyFolderStagedModelRepository.this._dummyFolders.size();
        }

        public Predicate<? super DummyFolder> getPredicate(String expression) {
            if (expression.contains("groupId=")) {
                return d -> d.getGroupId() == Long.valueOf(expression.substring("groupId=".length())).longValue();
            }
            if (expression.contains("id>-1")) {
                return d -> d.getId() > -1L;
            }
            if (expression.contains("companyId=")) {
                return d -> d.getCompanyId() == Long.valueOf(expression.substring("companyId=".length())).longValue();
            }
            return d -> true;
        }

        protected ClassLoader getClassLoader() {
            return super.getClassLoader();
        }

        protected Map<Locale, String> getLocalizationMap(String value) {
            return super.getLocalizationMap(value);
        }
    }
}

