/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.changeset.web.internal.portlet.action;

import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.ChangesetManager;
import com.liferay.exportimport.changeset.exception.ExportImportEntityException;
import com.liferay.exportimport.changeset.portlet.action.ExportImportChangesetMVCActionCommand;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactory;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.kernel.staging.StagingURLHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.http.LayoutServiceHttp;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ChangesetPortlet", "mvc.command.name=exportImportChangeset"}, service={ExportImportChangesetMVCActionCommand.class, MVCActionCommand.class})
public class ExportImportChangesetMVCActionCommandImpl
extends BaseMVCActionCommand
implements ExportImportChangesetMVCActionCommand {
    @Reference
    private ChangesetManager _changesetManager;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportConfigurationParameterMapFactory _exportImportConfigurationParameterMapFactory;
    @Reference
    private ExportImportConfigurationSettingsMapFactory _exportImportConfigurationSettingsMapFactory;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLocalService _exportImportLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private StagingURLHelper _stagingURLHelper;

    public void processExportAction(ActionRequest actionRequest, ActionResponse actionResponse, Changeset changeset) throws Exception {
        this._changesetManager.addChangeset(changeset);
        this._processExportAndPublishAction(actionRequest, actionResponse, "export", changeset.getUuid());
    }

    public void processPublishAction(ActionRequest actionRequest, ActionResponse actionResponse, Changeset changeset) throws Exception {
        this._changesetManager.addChangeset(changeset);
        this._processExportAndPublishAction(actionRequest, actionResponse, "publish", changeset.getUuid());
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("export") || cmd.equals("publish") || cmd.equals("publish_changeset")) {
            this._processExportAndPublishAction(actionRequest, actionResponse, cmd, null);
        } else {
            SessionErrors.add((PortletRequest)actionRequest, ExportImportEntityException.class, (Object)new ExportImportEntityException(2));
        }
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse, long backgroundTaskId) throws IOException {
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        LiferayPortletURL renderURL = liferayPortletResponse.createRenderURL("com_liferay_exportimport_web_portlet_ExportImportPortlet");
        renderURL.setParameter("mvcPath", "/view_export_import.jsp");
        renderURL.setParameter("backURL", actionRequest.getParameter("backURL"));
        renderURL.setParameter("backgroundTaskId", String.valueOf(backgroundTaskId));
        actionRequest.setAttribute("REDIRECT", (Object)renderURL.toString());
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        this.sendRedirect(actionRequest, actionResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processExportAndPublishAction(ActionRequest actionRequest, ActionResponse actionResponse, String cmd, String changesetUuid) throws IOException, PortalException {
        if (Validator.isNotNull((String)actionRequest.getParameter("changesetUuid"))) {
            changesetUuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"changesetUuid");
        } else if (Validator.isNull((String)changesetUuid)) {
            SessionErrors.add((PortletRequest)actionRequest, ExportImportEntityException.class, (Object)new ExportImportEntityException(3));
            return;
        }
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap();
        parameterMap.put("DELETIONS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("changesetUuid", new String[]{changesetUuid});
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = MapUtil.getString((Map)actionRequest.getParameterMap(), (String)"portletId");
        if (Validator.isNull((String)portletId)) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletId = portletDisplay.getId();
        }
        long backgroundTaskId = 0L;
        if (cmd.equals("export")) {
            Portlet portlet = this._portletLocalService.getPortletById(portletId);
            Map settingsMap = this._exportImportConfigurationSettingsMapFactory.buildExportPortletSettingsMap(themeDisplay.getUser(), themeDisplay.getPlid(), themeDisplay.getScopeGroupId(), "com_liferay_exportimport_web_portlet_ChangesetPortlet", parameterMap, this._exportImportHelper.getPortletExportFileName(portlet));
            ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), portletId, 5, settingsMap);
            backgroundTaskId = this._exportImportLocalService.exportPortletInfoAsFileInBackground(themeDisplay.getUserId(), exportImportConfiguration);
        } else if (cmd.equals("publish") || cmd.equals("publish_changeset")) {
            Group scopeGroup = this._groupLocalService.fetchGroup(ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId"));
            if (scopeGroup == null) {
                scopeGroup = themeDisplay.getScopeGroup();
            }
            if (!scopeGroup.isStagingGroup() && !scopeGroup.isStagedRemotely()) {
                SessionErrors.add((PortletRequest)actionRequest, ExportImportEntityException.class, (Object)new ExportImportEntityException(1));
                return;
            }
            if (!scopeGroup.isStagedPortlet(portletId)) {
                SessionErrors.add((PortletRequest)actionRequest, ExportImportEntityException.class, (Object)new ExportImportEntityException(4));
                return;
            }
            int type = 8;
            if (scopeGroup.isStagedRemotely()) {
                type = 9;
            }
            long liveGroupId = 0L;
            long targetPlid = themeDisplay.getPlid();
            if (scopeGroup.isStagingGroup()) {
                liveGroupId = scopeGroup.getLiveGroupId();
            } else if (scopeGroup.isStagedRemotely()) {
                liveGroupId = scopeGroup.getRemoteLiveGroupId();
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                User user = permissionChecker.getUser();
                Group stagingGroup = scopeGroup;
                if (scopeGroup.isLayout()) {
                    stagingGroup = scopeGroup.getParentGroup();
                }
                UnicodeProperties typeSettingsProperties = stagingGroup.getTypeSettingsProperties();
                HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(typeSettingsProperties), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
                    Group liveGroup = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)liveGroupId);
                    Group controlPanelGroup = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)liveGroup.getCompanyId(), (String)"Control Panel");
                    targetPlid = LayoutServiceHttp.getDefaultPlid((HttpPrincipal)httpPrincipal, (long)controlPanelGroup.getGroupId(), (boolean)true);
                }
                finally {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
            }
            Map settingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishPortletSettingsMap(themeDisplay.getUser(), scopeGroup.getGroupId(), themeDisplay.getPlid(), liveGroupId, targetPlid, "com_liferay_exportimport_web_portlet_ChangesetPortlet", parameterMap);
            ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), portletId, type, settingsMap);
            backgroundTaskId = this._staging.publishPortlet(themeDisplay.getUserId(), exportImportConfiguration);
        }
        this.sendRedirect(actionRequest, actionResponse, backgroundTaskId);
    }
}

