/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.changeset.web.internal.portlet.data.handler;

import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.ChangesetManager;
import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryRegistryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ChangesetPortlet"}, service={PortletDataHandler.class})
public class ChangesetPortletDataHandler
extends BasePortletDataHandler {
    public static final String SCHEMA_VERSION = "1.0.0";
    private static final Log _log = LogFactoryUtil.getLog(ChangesetPortletDataHandler.class);
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ChangesetManager _changesetManager;
    @Reference
    private ClassNameLocalService _classNameLocalService;

    public String exportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        Map parameterMap = portletDataContext.getParameterMap();
        Object[] stagedModelTypesStrings = (Object[])parameterMap.get("stagedModelTypes");
        if (ArrayUtil.isEmpty((Object[])stagedModelTypesStrings)) {
            return super.exportData(portletDataContext, portletId, portletPreferences);
        }
        StagedModelType[] stagedModelTypes = new StagedModelType[stagedModelTypesStrings.length];
        for (int i = 0; i < stagedModelTypesStrings.length; ++i) {
            stagedModelTypes[i] = StagedModelType.parse((String)String.valueOf(stagedModelTypesStrings[i]));
        }
        this.setDeletionSystemEventStagedModelTypes(stagedModelTypes);
        return super.exportData(portletDataContext, portletId, portletPreferences);
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setDataAlwaysStaged(true);
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Map parameterMap = portletDataContext.getParameterMap();
        String changesetUuid = MapUtil.getString((Map)parameterMap, (String)"changesetUuid");
        if (Validator.isBlank((String)changesetUuid)) {
            long changesetCollectionId = MapUtil.getLong((Map)parameterMap, (String)"changesetCollectionId");
            ChangesetCollection changesetCollection = null;
            if (changesetCollectionId > 0L) {
                changesetCollection = this._changesetCollectionLocalService.getChangesetCollection(changesetCollectionId);
            } else if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
                changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(portletDataContext.getScopeGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
            }
            if (changesetCollection == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"ChangesetCollection is empty, there is nothing to export");
                }
                return this.getExportDataRootElementString(rootElement);
            }
            this._exportChangesetCollection(portletDataContext, changesetCollection);
        } else {
            Optional changesetOptional = this._changesetManager.popChangeset(changesetUuid);
            if (!changesetOptional.isPresent()) {
                return this.getExportDataRootElementString(rootElement);
            }
            Changeset changeset = (Changeset)changesetOptional.get();
            Stream stream = changeset.stream();
            stream.filter(Objects::nonNull).forEach(stagedModel -> {
                try {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel);
                }
                catch (PortletDataException pde) {
                    throw new ExportImportRuntimeException((Throwable)pde);
                }
            });
        }
        this._exportAssetLinks(portletDataContext);
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        List entityTypeElements = importDataRootElement.elements();
        for (Element entityTypeElement : entityTypeElements) {
            List entityElements = entityTypeElement.elements();
            for (Element entityElement : entityElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)entityElement);
            }
        }
        return portletPreferences;
    }

    private void _exportAssetLinks(PortletDataContext portletDataContext) throws PortletDataException {
        for (Long linkId : portletDataContext.getAssetLinkIds()) {
            AssetLink assetLink = this._assetLinkLocalService.fetchAssetLink(linkId.longValue());
            if (assetLink == null) continue;
            StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedAssetLink);
        }
    }

    private void _exportChangesetCollection(PortletDataContext portletDataContext, ChangesetCollection changesetCollection) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._changesetEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"changesetCollectionId", (Object)changesetCollection.getChangesetCollectionId())));
        actionableDynamicQuery.setPerformActionMethod(changesetEntry -> this._exportStagedModel(portletDataContext, (ChangesetEntry)changesetEntry));
        actionableDynamicQuery.performActions();
    }

    private boolean _exportStagedModel(PortletDataContext portletDataContext, ChangesetEntry changesetEntry) throws PortalException {
        ClassName className = this._classNameLocalService.getClassName(changesetEntry.getClassNameId());
        StagedModelRepository stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)className.getValue());
        if (stagedModelRepository == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Staged model repository not found for " + className.getValue()));
            }
            return false;
        }
        StagedModel stagedModel = stagedModelRepository.getStagedModel(changesetEntry.getClassPK());
        Map parameterMap = portletDataContext.getParameterMap();
        boolean exportModel = this._isExportModel(portletDataContext, className.getValue());
        if (!exportModel) {
            if (!(stagedModel instanceof TypedModel)) {
                return false;
            }
            TypedModel typedModel = (TypedModel)stagedModel;
            String referrerClassName = typedModel.getClassName();
            boolean exportTypedModel = MapUtil.getBoolean((Map)parameterMap, (String)(className.getValue() + "#" + referrerClassName));
            if (!exportTypedModel) {
                return false;
            }
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel);
        return true;
    }

    private boolean _isExportModel(PortletDataContext portletDataContext, String className) {
        Map parameterMap = portletDataContext.getParameterMap();
        boolean exportModel = MapUtil.getBoolean((Map)parameterMap, (String)className);
        if (exportModel) {
            return true;
        }
        return MapUtil.getBoolean((Map)parameterMap, (String)(className + "#" + "referrer-class-name-all"));
    }
}

