/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.changeset;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Changeset
implements Serializable {
    private final List<StagedModel> _stagedModels = new ArrayList<StagedModel>();
    private final String _uuid = PortalUUIDUtil.generate();

    public static Builder create() {
        return new Builder(new Changeset());
    }

    public static RawBuilder createRaw() {
        return new RawBuilder(new Changeset());
    }

    public String getUuid() {
        return this._uuid;
    }

    public Stream<StagedModel> stream() {
        return this._stagedModels.stream();
    }

    private static void _collectChildrenStagedModels(List<StagedModel> childrenStagedModels, StagedModel parentStagedModel, String parentClassName, Function<StagedModel, Collection<?>> hierarchyFunction) {
        LinkedList<StagedModel> queue = new LinkedList<StagedModel>();
        queue.add(parentStagedModel);
        StagedModel stagedModel = null;
        while ((stagedModel = (StagedModel)queue.poll()) != null) {
            String stagedModelClassName = stagedModel.getModelClassName();
            if (!stagedModelClassName.equals(parentClassName)) continue;
            for (Object object : hierarchyFunction.apply(parentStagedModel)) {
                StagedModel childStagedModel = (StagedModel)object;
                childrenStagedModels.add(childStagedModel);
                queue.add(childStagedModel);
            }
        }
    }

    private Changeset() {
    }

    public static class RawBuilder {
        private final Changeset _changeset;

        public RawBuilder(Changeset changeset) {
            this._changeset = changeset;
        }

        public RawBuilder addMultipleStagedModel(Collection<? extends StagedModel> stagedModels) {
            stagedModels.forEach(stagedModel -> {
                if (stagedModel != null) {
                    this._changeset._stagedModels.add(stagedModel);
                }
            });
            return this;
        }

        public RawBuilder addStagedModel(StagedModel stagedModel) {
            this._changeset._stagedModels.add(stagedModel);
            return this;
        }

        public Changeset build() {
            return this._changeset;
        }
    }

    public static class Builder {
        private final Changeset _changeset;

        public Builder(Changeset changeset) {
            this._changeset = changeset;
        }

        public Builder addModel(Supplier<ClassedModel> supplier, Function<ClassedModel, StagedModel> adapterFunction) {
            this._changeset._stagedModels.add(adapterFunction.apply(supplier.get()));
            return this;
        }

        public Builder addMultipleStagedModel(Supplier<Collection<? extends StagedModel>> supplier) {
            Collection<? extends StagedModel> stagedModels = supplier.get();
            stagedModels.forEach(stagedModel -> {
                if (stagedModel != null) {
                    this._changeset._stagedModels.add(stagedModel);
                }
            });
            return this;
        }

        public Builder addStagedModel(Supplier<StagedModel> supplier) {
            this._changeset._stagedModels.add(supplier.get());
            return this;
        }

        public <T extends StagedModel> Builder addStagedModelHierarchy(Supplier<T> supplier, Function<T, Collection<?>> hierarchyFunction) {
            Function<T, Collection<?>> function = hierarchyFunction;
            StagedModel stagedModel = (StagedModel)supplier.get();
            String stagedModelClassName = ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel);
            Changeset._collectChildrenStagedModels(this._changeset._stagedModels, stagedModel, stagedModelClassName, function);
            return this;
        }

        public Changeset build() {
            return this._changeset;
        }
    }
}

